/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.controlprogram.parfor.mqo;

import java.util.LinkedList;
import org.apache.sysml.lops.runtime.RunMRJobs;
import org.apache.sysml.runtime.controlprogram.parfor.mqo.MergedMRJobInstruction;
import org.apache.sysml.runtime.controlprogram.parfor.mqo.PiggybackingWorker;
import org.apache.sysml.runtime.controlprogram.parfor.mqo.RuntimePiggybacking;
import org.apache.sysml.runtime.instructions.MRJobInstruction;
import org.apache.sysml.runtime.matrix.JobReturn;
import org.apache.sysml.runtime.matrix.data.Pair;
import org.apache.sysml.utils.Statistics;

public class PiggybackingWorkerTimeSequential
extends PiggybackingWorker {
    private static long DEFAULT_MERGE_INTERVAL = 1000L;
    private static boolean SUBSTRACT_EXEC_TIME = true;
    private long _time;

    public PiggybackingWorkerTimeSequential() {
        this(DEFAULT_MERGE_INTERVAL);
    }

    public PiggybackingWorkerTimeSequential(long timeInterval) {
        this._time = timeInterval;
    }

    @Override
    public void run() {
        long lastTime = System.currentTimeMillis();
        while (!this._stop) {
            try {
                if (SUBSTRACT_EXEC_TIME) {
                    long currentTime = System.currentTimeMillis();
                    if (currentTime - lastTime < this._time) {
                        Thread.sleep(this._time - (currentTime - lastTime));
                    }
                    lastTime = currentTime;
                } else {
                    Thread.sleep(this._time);
                }
                LinkedList<Pair<Long, MRJobInstruction>> workingSet = RuntimePiggybacking.getMaxWorkingSet();
                if (workingSet == null) continue;
                LinkedList<MergedMRJobInstruction> mergedWorkingSet = this.mergeMRJobInstructions(workingSet);
                for (MergedMRJobInstruction minst : mergedWorkingSet) {
                    JobReturn mret = RunMRJobs.submitJob(minst.inst);
                    Statistics.incrementNoOfExecutedMRJobs();
                    if (!mret.successful) {
                        LOG.error("Failed to run merged mr-job instruction:\n" + minst.inst.toString());
                    }
                    LinkedList<JobReturn> ret = new LinkedList<JobReturn>();
                    for (Long id : minst.ids) {
                        ret.add(minst.constructJobReturn(id, mret));
                        Statistics.decrementNoOfExecutedMRJobs();
                    }
                    this.putJobResults(minst.ids, ret);
                }
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }
    }
}

