/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.instructions.gpu.context;

import jcuda.Pointer;
import jcuda.runtime.JCuda;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.sysml.api.DMLScript;
import org.apache.sysml.runtime.instructions.gpu.context.GPUObject;
import org.apache.sysml.runtime.matrix.data.LibMatrixCUDA;
import org.apache.sysml.runtime.matrix.data.MatrixBlock;
import org.apache.sysml.utils.GPUStatistics;

public class ShadowBuffer {
    private static final Log LOG = LogFactory.getLog(ShadowBuffer.class.getName());
    GPUObject gpuObj;
    float[] shadowPointer = null;
    private static boolean _warnedAboutShadowBuffer = false;

    public ShadowBuffer(GPUObject gpuObj) {
        this.gpuObj = gpuObj;
    }

    public boolean isBuffered() {
        return this.shadowPointer != null;
    }

    public void moveFromDevice(String instName) {
        long start = DMLScript.STATISTICS ? System.nanoTime() : 0L;
        int numElems = GPUObject.toIntExact(this.gpuObj.mat.getNumRows() * this.gpuObj.mat.getNumColumns());
        this.shadowPointer = new float[numElems];
        DMLScript.EVICTION_SHADOW_BUFFER_CURR_BYTES += (long)(this.shadowPointer.length * 4);
        JCuda.cudaMemcpy((Pointer)Pointer.to((float[])this.shadowPointer), (Pointer)this.gpuObj.jcudaDenseMatrixPtr, (long)(numElems * LibMatrixCUDA.sizeOfDataType), (int)2);
        this.gpuObj.getGPUContext().cudaFreeHelper(instName, this.gpuObj.jcudaDenseMatrixPtr, true);
        this.gpuObj.jcudaDenseMatrixPtr = null;
        if (DMLScript.STATISTICS) {
            long totalTime = System.nanoTime() - start;
            GPUStatistics.cudaFromDevToShadowTime.add(totalTime);
            GPUStatistics.cudaFromDevToShadowCount.increment();
        }
    }

    public void moveToHost() {
        long start = DMLScript.STATISTICS ? System.nanoTime() : 0L;
        MatrixBlock tmp = new MatrixBlock(GPUObject.toIntExact(this.gpuObj.mat.getNumRows()), GPUObject.toIntExact(this.gpuObj.mat.getNumColumns()), false);
        tmp.allocateDenseBlock();
        double[] tmpArr = tmp.getDenseBlockValues();
        for (int i = 0; i < this.shadowPointer.length; ++i) {
            tmpArr[i] = this.shadowPointer[i];
        }
        this.gpuObj.mat.acquireModify(tmp);
        this.gpuObj.mat.release();
        this.clearShadowPointer();
        this.gpuObj.dirty = false;
        if (DMLScript.STATISTICS) {
            long totalTime = System.nanoTime() - start;
            GPUStatistics.cudaFromShadowToHostTime.add(totalTime);
            GPUStatistics.cudaFromShadowToHostCount.increment();
            GPUStatistics.cudaFromDevTime.add(totalTime);
            GPUStatistics.cudaFromDevCount.increment();
        }
    }

    public void moveToDevice() {
        long start = DMLScript.STATISTICS ? System.nanoTime() : 0L;
        long numBytes = this.shadowPointer.length * LibMatrixCUDA.sizeOfDataType;
        this.gpuObj.jcudaDenseMatrixPtr = this.gpuObj.getGPUContext().allocate(null, numBytes);
        JCuda.cudaMemcpy((Pointer)this.gpuObj.jcudaDenseMatrixPtr, (Pointer)Pointer.to((float[])this.shadowPointer), (long)numBytes, (int)1);
        this.clearShadowPointer();
        if (DMLScript.STATISTICS) {
            long totalTime = System.nanoTime() - start;
            GPUStatistics.cudaFromShadowToDevTime.add(totalTime);
            GPUStatistics.cudaFromShadowToDevCount.increment();
        }
    }

    public boolean isEligibleForBuffering(boolean isEviction, boolean eagerDelete) {
        if (LibMatrixCUDA.sizeOfDataType == 4 && isEviction && eagerDelete && !this.gpuObj.isDensePointerNull()) {
            boolean ret;
            int numBytes = GPUObject.toIntExact(this.gpuObj.mat.getNumRows() * this.gpuObj.mat.getNumColumns()) * 4;
            boolean bl = ret = DMLScript.EVICTION_SHADOW_BUFFER_CURR_BYTES + (long)numBytes <= DMLScript.EVICTION_SHADOW_BUFFER_MAX_BYTES;
            if (!ret && !_warnedAboutShadowBuffer) {
                LOG.warn("Shadow buffer is full, so using CP bufferpool instead. Consider increasing sysml.gpu.eviction.shadow.bufferSize.");
                _warnedAboutShadowBuffer = true;
            }
            return ret;
        }
        return false;
    }

    public void clearShadowPointer() {
        if (this.shadowPointer != null) {
            DMLScript.EVICTION_SHADOW_BUFFER_CURR_BYTES -= (long)(this.shadowPointer.length * 4);
        }
        this.shadowPointer = null;
    }
}

