/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.instructions.spark;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Random;
import org.apache.commons.math3.distribution.PoissonDistribution;
import org.apache.commons.math3.random.Well1024a;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.spark.api.java.JavaPairRDD;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.function.FlatMapFunction;
import org.apache.spark.api.java.function.Function;
import org.apache.spark.api.java.function.PairFunction;
import org.apache.spark.util.random.SamplingUtils;
import org.apache.sysml.api.DMLScript;
import org.apache.sysml.hops.DataGenOp;
import org.apache.sysml.hops.Hop;
import org.apache.sysml.hops.OptimizerUtils;
import org.apache.sysml.parser.Expression;
import org.apache.sysml.runtime.DMLRuntimeException;
import org.apache.sysml.runtime.controlprogram.context.ExecutionContext;
import org.apache.sysml.runtime.controlprogram.context.SparkExecutionContext;
import org.apache.sysml.runtime.controlprogram.parfor.stat.InfrastructureAnalyzer;
import org.apache.sysml.runtime.instructions.InstructionUtils;
import org.apache.sysml.runtime.instructions.cp.CPOperand;
import org.apache.sysml.runtime.instructions.spark.SPInstruction;
import org.apache.sysml.runtime.instructions.spark.UnarySPInstruction;
import org.apache.sysml.runtime.instructions.spark.utils.RDDConverterUtils;
import org.apache.sysml.runtime.io.IOUtilFunctions;
import org.apache.sysml.runtime.matrix.MatrixCharacteristics;
import org.apache.sysml.runtime.matrix.data.LibMatrixDatagen;
import org.apache.sysml.runtime.matrix.data.MatrixBlock;
import org.apache.sysml.runtime.matrix.data.MatrixCell;
import org.apache.sysml.runtime.matrix.data.MatrixIndexes;
import org.apache.sysml.runtime.matrix.data.RandomMatrixGenerator;
import org.apache.sysml.runtime.matrix.operators.Operator;
import org.apache.sysml.runtime.util.UtilFunctions;
import org.apache.sysml.utils.Statistics;
import scala.Tuple2;

public class RandSPInstruction
extends UnarySPInstruction {
    private static final long INMEMORY_NUMBLOCKS_THRESHOLD = 0x100000L;
    private Hop.DataGenMethod method = Hop.DataGenMethod.INVALID;
    private final CPOperand rows;
    private final CPOperand cols;
    private final int rowsInBlock;
    private final int colsInBlock;
    private final double minValue;
    private final double maxValue;
    private final double sparsity;
    private final String pdf;
    private final String pdfParams;
    private long seed = 0L;
    private final String dir;
    private final CPOperand seq_from;
    private final CPOperand seq_to;
    private final CPOperand seq_incr;
    private final boolean replace;

    private RandSPInstruction(Operator op, Hop.DataGenMethod mthd, CPOperand in, CPOperand out, CPOperand rows, CPOperand cols, int rpb, int cpb, double minValue, double maxValue, double sparsity, long seed, String dir, String probabilityDensityFunction, String pdfParams, CPOperand seqFrom, CPOperand seqTo, CPOperand seqIncr, boolean replace, String opcode, String istr) {
        super(SPInstruction.SPType.Rand, op, in, out, opcode, istr);
        this.method = mthd;
        this.rows = rows;
        this.cols = cols;
        this.rowsInBlock = rpb;
        this.colsInBlock = cpb;
        this.minValue = minValue;
        this.maxValue = maxValue;
        this.sparsity = sparsity;
        this.seed = seed;
        this.dir = dir;
        this.pdf = probabilityDensityFunction;
        this.pdfParams = pdfParams;
        this.seq_from = seqFrom;
        this.seq_to = seqTo;
        this.seq_incr = seqIncr;
        this.replace = replace;
    }

    private RandSPInstruction(Operator op, Hop.DataGenMethod mthd, CPOperand in, CPOperand out, CPOperand rows, CPOperand cols, int rpb, int cpb, double minValue, double maxValue, double sparsity, long seed, String dir, String probabilityDensityFunction, String pdfParams, String opcode, String istr) {
        this(op, mthd, in, out, rows, cols, rpb, cpb, minValue, maxValue, sparsity, seed, dir, probabilityDensityFunction, pdfParams, null, null, null, false, opcode, istr);
    }

    private RandSPInstruction(Operator op, Hop.DataGenMethod mthd, CPOperand in, CPOperand out, CPOperand rows, CPOperand cols, int rpb, int cpb, CPOperand seqFrom, CPOperand seqTo, CPOperand seqIncr, String opcode, String istr) {
        this(op, mthd, in, out, rows, cols, rpb, cpb, -1.0, -1.0, -1.0, -1L, null, null, null, seqFrom, seqTo, seqIncr, false, opcode, istr);
    }

    private RandSPInstruction(Operator op, Hop.DataGenMethod mthd, CPOperand in, CPOperand out, CPOperand rows, CPOperand cols, int rpb, int cpb, double maxValue, boolean replace, long seed, String opcode, String istr) {
        this(op, mthd, in, out, rows, cols, rpb, cpb, -1.0, maxValue, -1.0, seed, null, null, null, null, null, null, replace, opcode, istr);
    }

    public long getRows() {
        return this.rows.isLiteral() ? Long.parseLong(this.rows.getName()) : -1L;
    }

    public long getCols() {
        return this.cols.isLiteral() ? Long.parseLong(this.cols.getName()) : -1L;
    }

    public int getRowsInBlock() {
        return this.rowsInBlock;
    }

    public int getColsInBlock() {
        return this.colsInBlock;
    }

    public double getMinValue() {
        return this.minValue;
    }

    public double getMaxValue() {
        return this.maxValue;
    }

    public double getSparsity() {
        return this.sparsity;
    }

    public static RandSPInstruction parseInstruction(String str) {
        String[] s = InstructionUtils.getInstructionPartsWithValueType(str);
        String opcode = s[0];
        Hop.DataGenMethod method = Hop.DataGenMethod.INVALID;
        if (opcode.equalsIgnoreCase("rand")) {
            method = Hop.DataGenMethod.RAND;
            InstructionUtils.checkNumFields(str, 12);
        } else if (opcode.equalsIgnoreCase("seq")) {
            method = Hop.DataGenMethod.SEQ;
            InstructionUtils.checkNumFields(str, 8);
        } else if (opcode.equalsIgnoreCase("sample")) {
            method = Hop.DataGenMethod.SAMPLE;
            InstructionUtils.checkNumFields(str, 7);
        }
        Operator op = null;
        CPOperand out = new CPOperand(s[s.length - 1]);
        if (method == Hop.DataGenMethod.RAND) {
            CPOperand rows = new CPOperand(s[1]);
            CPOperand cols = new CPOperand(s[2]);
            int rpb = Integer.parseInt(s[3]);
            int cpb = Integer.parseInt(s[4]);
            double minValue = !s[5].contains("\u00b6") ? Double.valueOf(s[5]) : -1.0;
            double maxValue = !s[6].contains("\u00b6") ? Double.valueOf(s[6]) : -1.0;
            double sparsity = !s[7].contains("\u00b6") ? Double.valueOf(s[7]) : -1.0;
            long seed = !s[8].contains("\u00b6") ? Long.valueOf(s[8]) : -1L;
            String dir = s[9];
            String pdf = s[10];
            String pdfParams = !s[11].contains("\u00b6") ? s[11] : null;
            return new RandSPInstruction(op, method, null, out, rows, cols, rpb, cpb, minValue, maxValue, sparsity, seed, dir, pdf, pdfParams, opcode, str);
        }
        if (method == Hop.DataGenMethod.SEQ) {
            int rpb = Integer.parseInt(s[3]);
            int cpb = Integer.parseInt(s[4]);
            CPOperand from = new CPOperand(s[5]);
            CPOperand to = new CPOperand(s[6]);
            CPOperand incr = new CPOperand(s[7]);
            CPOperand in = null;
            return new RandSPInstruction(op, method, in, out, null, null, rpb, cpb, from, to, incr, opcode, str);
        }
        if (method == Hop.DataGenMethod.SAMPLE) {
            double max = !s[1].contains("\u00b6") ? Double.valueOf(s[1]) : 0.0;
            CPOperand rows = new CPOperand(s[2]);
            CPOperand cols = new CPOperand("1", Expression.ValueType.INT, Expression.DataType.SCALAR);
            boolean replace = !s[3].contains("\u00b6") && Boolean.valueOf(s[3]) != false;
            long seed = Long.parseLong(s[4]);
            int rpb = Integer.parseInt(s[5]);
            int cpb = Integer.parseInt(s[6]);
            return new RandSPInstruction(op, method, null, out, rows, cols, rpb, cpb, max, replace, seed, opcode, str);
        }
        throw new DMLRuntimeException("Unrecognized data generation method: " + (Object)((Object)method));
    }

    @Override
    public void processInstruction(ExecutionContext ec) {
        SparkExecutionContext sec = (SparkExecutionContext)ec;
        switch (this.method) {
            case RAND: {
                this.generateRandData(sec);
                break;
            }
            case SEQ: {
                this.generateSequence(sec);
                break;
            }
            case SAMPLE: {
                this.generateSample(sec);
                break;
            }
            default: {
                throw new DMLRuntimeException("Invalid datagen method: " + (Object)((Object)this.method));
            }
        }
    }

    private void generateRandData(SparkExecutionContext sec) {
        JavaPairRDD seedsRDD;
        long lcols;
        long lrows;
        block11: {
            long numColBlocks;
            long numBlocks;
            double hdfsBlkSize;
            double totalSize;
            Well1024a bigrand;
            block10: {
                lrows = sec.getScalarInput(this.rows).getLongValue();
                lcols = sec.getScalarInput(this.cols).getLongValue();
                long lSeed = this.seed;
                if (lSeed == -1L) {
                    lSeed = DataGenOp.generateRandomSeed();
                }
                if (LOG.isTraceEnabled()) {
                    LOG.trace("Process RandSPInstruction rand with seed = " + lSeed + ".");
                }
                if (RandSPInstruction.isMemAvail(lrows, lcols, this.sparsity, this.minValue, this.maxValue) && DMLScript.rtplatform != DMLScript.RUNTIME_PLATFORM.SPARK) {
                    RandomMatrixGenerator rgen = LibMatrixDatagen.createRandomMatrixGenerator(this.pdf, (int)lrows, (int)lcols, this.rowsInBlock, this.colsInBlock, this.sparsity, this.minValue, this.maxValue, this.pdfParams);
                    MatrixBlock mb = MatrixBlock.randOperations(rgen, lSeed);
                    sec.setMatrixOutput(this.output.getName(), mb, this.getExtendedOpcode());
                    Statistics.decrementNoOfExecutedSPInst();
                    return;
                }
                seedsRDD = null;
                bigrand = LibMatrixDatagen.setupSeedsForRand(lSeed);
                totalSize = OptimizerUtils.estimatePartitionedSizeExactSparsity(lrows, lcols, (long)this.rowsInBlock, (long)this.colsInBlock, this.sparsity);
                hdfsBlkSize = InfrastructureAnalyzer.getHDFSBlockSize();
                MatrixCharacteristics tmp = new MatrixCharacteristics(lrows, lcols, this.rowsInBlock, this.colsInBlock);
                numBlocks = tmp.getNumBlocks();
                numColBlocks = tmp.getNumColBlocks();
                if (numBlocks >= 0x100000L) break block10;
                ArrayList<Tuple2> seeds = new ArrayList<Tuple2>();
                for (long i = 0L; i < numBlocks; ++i) {
                    long r = 1L + i / numColBlocks;
                    long c = 1L + i % numColBlocks;
                    MatrixIndexes indx = new MatrixIndexes(r, c);
                    Long seedForBlock = bigrand.nextLong();
                    seeds.add(new Tuple2((Object)indx, (Object)seedForBlock));
                }
                int numPartitions = (int)Math.max(Math.min(totalSize / hdfsBlkSize, (double)numBlocks), 1.0);
                seedsRDD = sec.getSparkContext().parallelizePairs(seeds, numPartitions);
                break block11;
            }
            Path path = new Path(LibMatrixDatagen.generateUniqueSeedPath(this.dir));
            PrintWriter pw = null;
            try {
                FileSystem fs = IOUtilFunctions.getFileSystem(path);
                pw = new PrintWriter(fs.create(path));
                StringBuilder sb = new StringBuilder();
                for (long i = 0L; i < numBlocks; ++i) {
                    sb.append(1L + i / numColBlocks);
                    sb.append(',');
                    sb.append(1L + i % numColBlocks);
                    sb.append(',');
                    sb.append(bigrand.nextLong());
                    pw.println(sb.toString());
                    sb.setLength(0);
                }
            }
            catch (IOException ex) {
                try {
                    throw new DMLRuntimeException(ex);
                }
                catch (Throwable throwable) {
                    IOUtilFunctions.closeSilently(pw);
                    throw throwable;
                }
            }
            IOUtilFunctions.closeSilently(pw);
            int numPartitions = (int)Math.max(Math.min(totalSize / hdfsBlkSize, (double)numBlocks), 1.0);
            seedsRDD = sec.getSparkContext().textFile(path.toString(), numPartitions).mapToPair((PairFunction)new ExtractSeedTuple());
        }
        JavaPairRDD out = seedsRDD.mapToPair((PairFunction)new GenerateRandomBlock(lrows, lcols, this.rowsInBlock, this.colsInBlock, this.sparsity, this.minValue, this.maxValue, this.pdf, this.pdfParams));
        MatrixCharacteristics mcOut = sec.getMatrixCharacteristics(this.output.getName());
        if (!mcOut.dimsKnown(true)) {
            long lnnz = this.sparsity == 0.0 || this.sparsity == 1.0 ? (long)(this.sparsity * (double)lrows * (double)lcols) : -1L;
            mcOut.set(lrows, lcols, this.rowsInBlock, this.colsInBlock, lnnz);
        }
        sec.setRDDHandleForVariable(this.output.getName(), out);
    }

    private void generateSequence(SparkExecutionContext sec) {
        long nnz;
        JavaRDD offsetsRDD;
        double lincr;
        double lto;
        double lfrom;
        block10: {
            long numBlocks;
            double hdfsBlkSize;
            double totalSize;
            block9: {
                lfrom = sec.getScalarInput(this.seq_from).getDoubleValue();
                lto = sec.getScalarInput(this.seq_to).getDoubleValue();
                lincr = sec.getScalarInput(this.seq_incr).getDoubleValue();
                if (lincr == 0.0) {
                    throw new DMLRuntimeException("ERROR: While performing seq(" + lfrom + "," + lto + "," + lincr + ")");
                }
                lincr = LibMatrixDatagen.updateSeqIncr(lfrom, lto, lincr);
                if (LOG.isTraceEnabled()) {
                    LOG.trace("Process RandSPInstruction seq with seqFrom=" + lfrom + ", seqTo=" + lto + ", seqIncr" + lincr);
                }
                offsetsRDD = null;
                nnz = UtilFunctions.getSeqLength(lfrom, lto, lincr);
                totalSize = OptimizerUtils.estimatePartitionedSizeExactSparsity(nnz, 1L, (long)this.rowsInBlock, (long)this.colsInBlock, nnz);
                hdfsBlkSize = InfrastructureAnalyzer.getHDFSBlockSize();
                numBlocks = (long)Math.ceil((double)nnz / (double)this.rowsInBlock);
                if (numBlocks >= 0x100000L) break block9;
                ArrayList<Double> offsets = new ArrayList<Double>();
                for (long i = 0L; i < numBlocks; ++i) {
                    double off = lfrom + lincr * (double)i * (double)this.rowsInBlock;
                    offsets.add(off);
                }
                int numPartitions = (int)Math.max(Math.min(totalSize / hdfsBlkSize, (double)numBlocks), 1.0);
                offsetsRDD = sec.getSparkContext().parallelize(offsets, numPartitions);
                break block10;
            }
            Path path = new Path(LibMatrixDatagen.generateUniqueSeedPath(this.dir));
            PrintWriter pw = null;
            try {
                FileSystem fs = IOUtilFunctions.getFileSystem(path);
                pw = new PrintWriter(fs.create(path));
                for (long i = 0L; i < numBlocks; ++i) {
                    double off = lfrom + lincr * (double)i * (double)this.rowsInBlock;
                    pw.println(off);
                }
            }
            catch (IOException ex) {
                try {
                    throw new DMLRuntimeException(ex);
                }
                catch (Throwable throwable) {
                    IOUtilFunctions.closeSilently(pw);
                    throw throwable;
                }
            }
            IOUtilFunctions.closeSilently(pw);
            int numPartitions = (int)Math.max(Math.min(totalSize / hdfsBlkSize, (double)numBlocks), 1.0);
            offsetsRDD = sec.getSparkContext().textFile(path.toString(), numPartitions).map((Function)new ExtractOffsetTuple());
        }
        JavaPairRDD out = offsetsRDD.mapToPair((PairFunction)new GenerateSequenceBlock(this.rowsInBlock, lfrom, lto, lincr));
        MatrixCharacteristics mcOut = sec.getMatrixCharacteristics(this.output.getName());
        if (!mcOut.dimsKnown()) {
            mcOut.set(nnz, 1L, this.rowsInBlock, this.colsInBlock, nnz);
        }
        sec.setRDDHandleForVariable(this.output.getName(), out);
    }

    private void generateSample(SparkExecutionContext sec) {
        long lrows = sec.getScalarInput(this.rows).getLongValue();
        if (this.maxValue < (double)lrows && !this.replace) {
            throw new DMLRuntimeException("Sample (size=" + this.rows + ") larger than population (size=" + this.maxValue + ") can only be generated with replacement.");
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace("Process RandSPInstruction sample with range=" + this.maxValue + ", size=" + lrows + ", replace=" + this.replace + ", seed=" + this.seed);
        }
        double fraction = SamplingUtils.computeFractionForSampleSize((int)((int)lrows), (long)UtilFunctions.toLong(this.maxValue), (boolean)this.replace);
        Well1024a bigrand = LibMatrixDatagen.setupSeedsForRand(this.seed);
        double hdfsBlockSize = InfrastructureAnalyzer.getHDFSBlockSize();
        long outputSize = MatrixBlock.estimateSizeDenseInMemory(lrows, 1L);
        int numPartitions = (int)Math.ceil((double)outputSize / hdfsBlockSize);
        long partitionSize = (long)Math.ceil(this.maxValue / (double)numPartitions);
        ArrayList<SampleTask> offsets = new ArrayList<SampleTask>();
        long st = 1L;
        while ((double)st <= this.maxValue) {
            SampleTask s = new SampleTask();
            s.range_start = st;
            s.seed = bigrand.nextLong();
            offsets.add(s);
            st += partitionSize;
        }
        JavaRDD offsetRDD = sec.getSparkContext().parallelize(offsets, numPartitions);
        JavaRDD rdd = offsetRDD.flatMap((FlatMapFunction)new GenerateSampleBlock(this.replace, fraction, (long)this.maxValue, partitionSize));
        JavaRDD randomizedRDD = rdd.mapToPair((PairFunction)new AttachRandom()).sortByKey().values();
        JavaPairRDD miRDD = randomizedRDD.zipWithIndex().filter((Function)new TrimSample(lrows)).mapToPair((PairFunction)new Double2MatrixCell());
        MatrixCharacteristics mcOut = new MatrixCharacteristics(lrows, 1L, this.rowsInBlock, this.colsInBlock, lrows);
        JavaPairRDD<MatrixIndexes, MatrixBlock> mbRDD = RDDConverterUtils.binaryCellToBinaryBlock(sec.getSparkContext(), (JavaPairRDD<MatrixIndexes, MatrixCell>)miRDD, mcOut, true);
        sec.getMatrixCharacteristics(this.output.getName()).setNonZeros(lrows);
        sec.setRDDHandleForVariable(this.output.getName(), mbRDD);
    }

    private static boolean isMemAvail(long lrows, long lcols, double sparsity, double min, double max) {
        double size = min == 0.0 && max == 0.0 ? (double)OptimizerUtils.estimateSizeEmptyBlock(lrows, lcols) : (double)OptimizerUtils.estimateSizeExactSparsity(lrows, lcols, sparsity);
        return OptimizerUtils.isValidCPDimensions(lrows, lcols) && OptimizerUtils.isValidCPMatrixSize(lrows, lcols, sparsity) && size < OptimizerUtils.getLocalMemBudget();
    }

    private static class GenerateSequenceBlock
    implements PairFunction<Double, MatrixIndexes, MatrixBlock> {
        private static final long serialVersionUID = 5779681055705756965L;
        private final double _global_seq_start;
        private final double _global_seq_end;
        private final double _seq_incr;
        private final int _brlen;

        public GenerateSequenceBlock(int brlen, double global_seq_start, double global_seq_end, double seq_incr) {
            this._global_seq_start = global_seq_start;
            this._global_seq_end = global_seq_end;
            this._seq_incr = seq_incr;
            this._brlen = brlen;
        }

        public Tuple2<MatrixIndexes, MatrixBlock> call(Double seq_from) throws Exception {
            double seq_to = this._seq_incr > 0.0 ? Math.min(this._global_seq_end, seq_from + this._seq_incr * (double)(this._brlen - 1)) : Math.max(this._global_seq_end, seq_from + this._seq_incr * (double)(this._brlen + 1));
            long globalRow = Math.round((seq_from - this._global_seq_start) / this._seq_incr) + 1L;
            long rowIndex = UtilFunctions.computeBlockIndex(globalRow, this._brlen);
            MatrixIndexes indx = new MatrixIndexes(rowIndex, 1L);
            MatrixBlock blk = MatrixBlock.seqOperations(seq_from, seq_to, this._seq_incr);
            return new Tuple2((Object)indx, (Object)blk);
        }
    }

    private static class GenerateRandomBlock
    implements PairFunction<Tuple2<MatrixIndexes, Long>, MatrixIndexes, MatrixBlock> {
        private static final long serialVersionUID = 1616346120426470173L;
        private long _rlen;
        private long _clen;
        private int _brlen;
        private int _bclen;
        private double _sparsity;
        private double _min;
        private double _max;
        private String _pdf;
        private String _pdfParams;

        public GenerateRandomBlock(long rlen, long clen, int brlen, int bclen, double sparsity, double min, double max, String pdf, String pdfParams) {
            this._rlen = rlen;
            this._clen = clen;
            this._brlen = brlen;
            this._bclen = bclen;
            this._sparsity = sparsity;
            this._min = min;
            this._max = max;
            this._pdf = pdf;
            this._pdfParams = pdfParams;
        }

        public Tuple2<MatrixIndexes, MatrixBlock> call(Tuple2<MatrixIndexes, Long> kv) throws Exception {
            MatrixIndexes ix = (MatrixIndexes)kv._1();
            long blockRowIndex = ix.getRowIndex();
            long blockColIndex = ix.getColumnIndex();
            int lrlen = UtilFunctions.computeBlockSize(this._rlen, blockRowIndex, this._brlen);
            int lclen = UtilFunctions.computeBlockSize(this._clen, blockColIndex, this._bclen);
            long seed = (Long)kv._2;
            MatrixBlock blk = new MatrixBlock();
            RandomMatrixGenerator rgen = LibMatrixDatagen.createRandomMatrixGenerator(this._pdf, lrlen, lclen, lrlen, lclen, this._sparsity, this._min, this._max, this._pdfParams);
            blk.randOperationsInPlace(rgen, null, seed);
            blk.examSparsity();
            return new Tuple2(kv._1, (Object)blk);
        }
    }

    private static class ExtractOffsetTuple
    implements Function<String, Double> {
        private static final long serialVersionUID = -3980257526545002552L;

        private ExtractOffsetTuple() {
        }

        public Double call(String arg) throws Exception {
            return Double.parseDouble(arg);
        }
    }

    private static class ExtractSeedTuple
    implements PairFunction<String, MatrixIndexes, Long> {
        private static final long serialVersionUID = 3973794676854157101L;

        private ExtractSeedTuple() {
        }

        public Tuple2<MatrixIndexes, Long> call(String arg) throws Exception {
            String[] parts = IOUtilFunctions.split(arg, ",");
            MatrixIndexes ix = new MatrixIndexes(Long.parseLong(parts[0]), Long.parseLong(parts[1]));
            return new Tuple2((Object)ix, (Object)Long.parseLong(parts[2]));
        }
    }

    private static class AttachRandom
    implements PairFunction<Double, Double, Double> {
        private static final long serialVersionUID = -7508858192367406554L;
        Random r = new Random();

        AttachRandom() {
        }

        public Tuple2<Double, Double> call(Double t) throws Exception {
            return new Tuple2((Object)this.r.nextDouble(), (Object)t);
        }
    }

    private static class Double2MatrixCell
    implements PairFunction<Tuple2<Double, Long>, MatrixIndexes, MatrixCell> {
        private static final long serialVersionUID = -2125669746624320536L;

        private Double2MatrixCell() {
        }

        public Tuple2<MatrixIndexes, MatrixCell> call(Tuple2<Double, Long> t) throws Exception {
            long rowID = (Long)t._2() + 1L;
            MatrixIndexes mi = new MatrixIndexes(rowID, 1L);
            MatrixCell mc = new MatrixCell((Double)t._1());
            return new Tuple2((Object)mi, (Object)mc);
        }
    }

    private static class TrimSample
    implements Function<Tuple2<Double, Long>, Boolean> {
        private static final long serialVersionUID = 6773370625013346530L;
        long _max;

        TrimSample(long max) {
            this._max = max;
        }

        public Boolean call(Tuple2<Double, Long> v1) throws Exception {
            return (Long)v1._2 < this._max;
        }
    }

    private static class GenerateSampleBlock
    implements FlatMapFunction<SampleTask, Double> {
        private static final long serialVersionUID = -8211490954143527232L;
        private double _frac;
        private boolean _replace;
        private long _maxValue;
        private long _partitionSize;

        GenerateSampleBlock(boolean replace, double frac, long max, long psize) {
            this._replace = replace;
            this._frac = frac;
            this._maxValue = max;
            this._partitionSize = psize;
        }

        public Iterator<Double> call(SampleTask t) throws Exception {
            long st = t.range_start;
            long end = Math.min(t.range_start + this._partitionSize, this._maxValue);
            ArrayList<Double> retList = new ArrayList<Double>();
            if (this._frac == 1.0) {
                for (long i = st; i <= end; ++i) {
                    retList.add(Double.valueOf(i));
                }
            } else if (this._replace) {
                PoissonDistribution pdist = new PoissonDistribution(this._frac > 0.0 ? this._frac : 1.0);
                for (long i = st; i <= end; ++i) {
                    for (int count = pdist.sample(); count > 0; --count) {
                        retList.add(Double.valueOf(i));
                    }
                }
            } else {
                Random rnd = new Random(t.seed);
                for (long i = st; i <= end; ++i) {
                    if (!(rnd.nextDouble() < this._frac)) continue;
                    retList.add(Double.valueOf(i));
                }
            }
            return retList.iterator();
        }
    }

    private static class SampleTask
    implements Serializable {
        private static final long serialVersionUID = -725284524434342939L;
        long seed;
        long range_start;

        private SampleTask() {
        }

        public String toString() {
            return "(" + this.seed + "," + this.range_start + ")";
        }
    }
}

