/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.matrix;

import java.io.PrintWriter;
import java.util.HashSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.math3.random.Well1024a;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapred.Counters;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RunningJob;
import org.apache.sysml.conf.ConfigurationManager;
import org.apache.sysml.conf.DMLConfig;
import org.apache.sysml.runtime.DMLRuntimeException;
import org.apache.sysml.runtime.controlprogram.parfor.stat.InfrastructureAnalyzer;
import org.apache.sysml.runtime.instructions.MRInstructionParser;
import org.apache.sysml.runtime.instructions.MRJobInstruction;
import org.apache.sysml.runtime.instructions.mr.DataGenMRInstruction;
import org.apache.sysml.runtime.instructions.mr.MRInstruction;
import org.apache.sysml.runtime.instructions.mr.RandInstruction;
import org.apache.sysml.runtime.instructions.mr.SeqInstruction;
import org.apache.sysml.runtime.io.IOUtilFunctions;
import org.apache.sysml.runtime.matrix.JobReturn;
import org.apache.sysml.runtime.matrix.MatrixCharacteristics;
import org.apache.sysml.runtime.matrix.data.InputInfo;
import org.apache.sysml.runtime.matrix.data.LibMatrixDatagen;
import org.apache.sysml.runtime.matrix.data.MatrixIndexes;
import org.apache.sysml.runtime.matrix.data.OutputInfo;
import org.apache.sysml.runtime.matrix.data.TaggedMatrixBlock;
import org.apache.sysml.runtime.matrix.mapred.DataGenMapper;
import org.apache.sysml.runtime.matrix.mapred.GMRCombiner;
import org.apache.sysml.runtime.matrix.mapred.GMRReducer;
import org.apache.sysml.runtime.matrix.mapred.MRJobConfiguration;
import org.apache.sysml.runtime.util.MapReduceTool;
import org.apache.sysml.runtime.util.UtilFunctions;
import org.apache.sysml.yarn.DMLAppMasterUtils;
import org.apache.sysml.yarn.ropt.YarnClusterAnalyzer;

public class DataGenMR {
    private static final Log LOG = LogFactory.getLog(DataGenMR.class.getName());

    private DataGenMR() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JobReturn runJob(MRJobInstruction inst, String[] dataGenInstructions, String instructionsInMapper, String aggInstructionsInReducer, String otherInstructionsInReducer, int numReducers, int replication, byte[] resultIndexes, String dimsUnknownFilePrefix, String[] outputs, OutputInfo[] outputInfos) throws Exception {
        RunningJob runjob;
        MatrixCharacteristics[] stats;
        JobConf job = new JobConf(DataGenMR.class);
        job.setJobName("DataGen-MR");
        MRJobConfiguration.setMatrixValueClass(job, true);
        byte[] realIndexes = new byte[dataGenInstructions.length];
        for (int b = 0; b < realIndexes.length; b = (int)((byte)(b + 1))) {
            realIndexes[b] = b;
        }
        String[] inputs = new String[dataGenInstructions.length];
        InputInfo[] inputInfos = new InputInfo[dataGenInstructions.length];
        long[] rlens = new long[dataGenInstructions.length];
        long[] clens = new long[dataGenInstructions.length];
        int[] brlens = new int[dataGenInstructions.length];
        int[] bclens = new int[dataGenInstructions.length];
        FileSystem fs = FileSystem.get(job);
        String dataGenInsStr = "";
        int numblocks = 0;
        int maxbrlen = -1;
        int maxbclen = -1;
        double maxsparsity = -1.0;
        for (int i = 0; i < dataGenInstructions.length; ++i) {
            MRInstruction.MRType mrtype;
            block29: {
                boolean neg;
                DataGenMRInstruction genInst;
                MRInstruction mrins;
                block28: {
                    dataGenInsStr = dataGenInsStr + "\u2021" + dataGenInstructions[i];
                    mrins = MRInstructionParser.parseSingleInstruction(dataGenInstructions[i]);
                    mrtype = mrins.getMRInstructionType();
                    genInst = (DataGenMRInstruction)mrins;
                    rlens[i] = genInst.getRows();
                    clens[i] = genInst.getCols();
                    brlens[i] = genInst.getRowsInBlock();
                    bclens[i] = genInst.getColsInBlock();
                    maxbrlen = Math.max(maxbrlen, brlens[i]);
                    maxbclen = Math.max(maxbclen, bclens[i]);
                    if (mrtype != MRInstruction.MRType.Rand) break block28;
                    RandInstruction randInst = (RandInstruction)mrins;
                    inputs[i] = LibMatrixDatagen.generateUniqueSeedPath(genInst.getBaseDir());
                    maxsparsity = Math.max(maxsparsity, randInst.getSparsity());
                    PrintWriter pw = null;
                    try {
                        pw = new PrintWriter(fs.create(new Path(inputs[i])));
                        StringBuilder sb = new StringBuilder();
                        Well1024a bigrand = LibMatrixDatagen.setupSeedsForRand(randInst.getSeed());
                        for (long r = 0L; r < Math.max(rlens[i], 1L); r += (long)brlens[i]) {
                            long curBlockRowSize = Math.min((long)brlens[i], rlens[i] - r);
                            for (long c = 0L; c < Math.max(clens[i], 1L); c += (long)bclens[i]) {
                                long curBlockColSize = Math.min((long)bclens[i], clens[i] - c);
                                sb.append(r / (long)brlens[i] + 1L);
                                sb.append(',');
                                sb.append(c / (long)bclens[i] + 1L);
                                sb.append(',');
                                sb.append(curBlockRowSize);
                                sb.append(',');
                                sb.append(curBlockColSize);
                                sb.append(',');
                                sb.append(bigrand.nextLong());
                                pw.println(sb.toString());
                                sb.setLength(0);
                                ++numblocks;
                            }
                        }
                    }
                    catch (Throwable throwable) {
                        IOUtilFunctions.closeSilently(pw);
                        throw throwable;
                    }
                    IOUtilFunctions.closeSilently(pw);
                    inputInfos[i] = InputInfo.TextCellInputInfo;
                    continue;
                }
                if (mrtype != MRInstruction.MRType.Seq) break block29;
                SeqInstruction seqInst = (SeqInstruction)mrins;
                inputs[i] = genInst.getBaseDir() + System.currentTimeMillis() + ".seqinput";
                maxsparsity = 1.0;
                double from = seqInst.fromValue;
                double to = seqInst.toValue;
                double incr = seqInst.incrValue;
                incr = LibMatrixDatagen.updateSeqIncr(from, to, incr);
                boolean bl = neg = from > to;
                if (incr == 0.0) {
                    throw new DMLRuntimeException("Invalid value for \"increment\" in seq().");
                }
                if (neg != incr < 0.0) {
                    throw new DMLRuntimeException("Wrong sign for the increment in a call to seq()");
                }
                long numrows = UtilFunctions.getSeqLength(from, to, incr);
                if (rlens[i] > 0L) {
                    if (numrows != rlens[i]) {
                        throw new DMLRuntimeException("Unexpected error while processing sequence instruction. Expected number of rows does not match given number: " + rlens[i] + " != " + numrows);
                    }
                } else {
                    rlens[i] = numrows;
                }
                if (clens[i] > 0L && clens[i] != 1L) {
                    throw new DMLRuntimeException("Unexpected error while processing sequence instruction. Number of columns (" + clens[i] + ") must be equal to 1.");
                }
                clens[i] = 1L;
                PrintWriter pw = null;
                try {
                    pw = new PrintWriter(fs.create(new Path(inputs[i])));
                    StringBuilder sb = new StringBuilder();
                    double temp = from;
                    for (long r = 0L; r < rlens[i]; r += (long)brlens[i]) {
                        long curBlockRowSize = Math.min((long)brlens[i], rlens[i] - r);
                        long bid_i = r / (long)brlens[i] + 1L;
                        long bid_j = 1L;
                        double block_from = temp;
                        double block_to = temp + (double)(curBlockRowSize - 1L) * incr;
                        temp = block_to + incr;
                        sb.append(bid_i);
                        sb.append(',');
                        sb.append(bid_j);
                        sb.append(',');
                        sb.append(block_from);
                        sb.append(',');
                        sb.append(block_to);
                        sb.append(',');
                        sb.append(incr);
                        pw.println(sb.toString());
                        sb.setLength(0);
                        ++numblocks;
                    }
                }
                catch (Throwable throwable) {
                    IOUtilFunctions.closeSilently(pw);
                    throw throwable;
                }
                IOUtilFunctions.closeSilently(pw);
                inputInfos[i] = InputInfo.TextCellInputInfo;
                continue;
            }
            throw new DMLRuntimeException("Unexpected Data Generation Instruction Type: " + (Object)((Object)mrtype));
        }
        dataGenInsStr = dataGenInsStr.substring(1);
        try {
            MRJobConfiguration.setBlocksSizes(job, realIndexes, brlens, bclens);
            MRJobConfiguration.setUpMultipleInputs(job, realIndexes, inputs, inputInfos, brlens, bclens, false, MRJobConfiguration.ConvertTarget.BLOCK);
            MRJobConfiguration.setMatricesDimensions(job, realIndexes, rlens, clens);
            MRJobConfiguration.setDimsUnknownFilePrefix(job, dimsUnknownFilePrefix);
            MRJobConfiguration.setBlocksSizes(job, realIndexes, brlens, bclens);
            MRJobConfiguration.setRandInstructions(job, dataGenInsStr);
            MRJobConfiguration.setInstructionsInMapper(job, instructionsInMapper);
            MRJobConfiguration.setAggregateInstructions(job, aggInstructionsInReducer);
            MRJobConfiguration.setInstructionsInReducer(job, otherInstructionsInReducer);
            job.setInt("dfs.replication", replication);
            DMLConfig config = ConfigurationManager.getDMLConfig();
            DMLAppMasterUtils.setupMRJobRemoteMaxMemory(job, config);
            MRJobConfiguration.setupCustomMRConfigurations(job, config);
            int capacity = InfrastructureAnalyzer.getRemoteParallelMapTasks();
            long dfsblocksize = InfrastructureAnalyzer.getHDFSBlockSize();
            if (InfrastructureAnalyzer.isYarnEnabled()) {
                capacity = (int)Math.max((long)capacity, YarnClusterAnalyzer.getNumCores());
            }
            int nmapers = Math.max(Math.min((int)((long)(8 * maxbrlen * maxbclen) * (long)numblocks / dfsblocksize), capacity), 1);
            job.setNumMapTasks(nmapers);
            HashSet<Byte> mapoutputIndexes = MRJobConfiguration.setUpOutputIndexesForMapper(job, realIndexes, dataGenInsStr, instructionsInMapper, null, aggInstructionsInReducer, otherInstructionsInReducer, resultIndexes);
            MRJobConfiguration.MatrixChar_N_ReducerGroups ret = MRJobConfiguration.computeMatrixCharacteristics(job, realIndexes, dataGenInsStr, instructionsInMapper, null, aggInstructionsInReducer, null, otherInstructionsInReducer, resultIndexes, mapoutputIndexes, false);
            stats = ret.stats;
            MRJobConfiguration.setNumReducers(job, ret.numReducerGroups, numReducers);
            if (LOG.isTraceEnabled()) {
                inst.printCompleteMRJobInstruction(stats);
            }
            byte[] resultDimsUnknown = new byte[resultIndexes.length];
            for (int i = 0; i < resultIndexes.length; ++i) {
                resultDimsUnknown[i] = stats[i].getRows() == -1L || stats[i].getCols() == -1L ? (byte)1 : 0;
            }
            boolean mayContainCtable = instructionsInMapper.contains("ctabletransform") || instructionsInMapper.contains("groupedagg");
            MRJobConfiguration.setUpMultipleOutputs(job, resultIndexes, resultDimsUnknown, outputs, outputInfos, true, mayContainCtable);
            job.setMapperClass(DataGenMapper.class);
            if (numReducers == 0) {
                job.setMapOutputKeyClass(Writable.class);
                job.setMapOutputValueClass(Writable.class);
            } else {
                job.setMapOutputKeyClass(MatrixIndexes.class);
                job.setMapOutputValueClass(TaggedMatrixBlock.class);
            }
            if (numReducers != 0 && aggInstructionsInReducer != null && !aggInstructionsInReducer.isEmpty()) {
                job.setCombinerClass(GMRCombiner.class);
            }
            job.setReducerClass(GMRReducer.class);
            MatrixCharacteristics[] inputStats = new MatrixCharacteristics[inputs.length];
            for (int i = 0; i < inputs.length; ++i) {
                inputStats[i] = new MatrixCharacteristics(rlens[i], clens[i], brlens[i], bclens[i]);
            }
            MRJobConfiguration.setUniqueWorkingDir(job);
            runjob = JobClient.runJob(job);
            Counters.Group group = runjob.getCounters().getGroup("nonzeros");
            for (int i = 0; i < resultIndexes.length; ++i) {
                stats[i].setNonZeros(group.getCounter(Integer.toString(i)));
            }
            String dir = dimsUnknownFilePrefix + "/" + runjob.getID().toString() + "_dimsFile";
            stats = MapReduceTool.processDimsFiles(dir, stats);
            MapReduceTool.deleteFileIfExistOnHDFS(dir);
        }
        finally {
            for (String input : inputs) {
                MapReduceTool.deleteFileIfExistOnHDFS(new Path(input), job);
            }
        }
        return new JobReturn(stats, outputInfos, runjob.isSuccessful());
    }
}

