/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.transform.encode;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.ArrayUtils;
import org.apache.sysml.parser.Expression;
import org.apache.sysml.runtime.DMLRuntimeException;
import org.apache.sysml.runtime.matrix.data.FrameBlock;
import org.apache.sysml.runtime.transform.encode.Encoder;
import org.apache.sysml.runtime.transform.encode.EncoderBin;
import org.apache.sysml.runtime.transform.encode.EncoderComposite;
import org.apache.sysml.runtime.transform.encode.EncoderDummycode;
import org.apache.sysml.runtime.transform.encode.EncoderMVImpute;
import org.apache.sysml.runtime.transform.encode.EncoderOmit;
import org.apache.sysml.runtime.transform.encode.EncoderPassThrough;
import org.apache.sysml.runtime.transform.encode.EncoderRecode;
import org.apache.sysml.runtime.transform.meta.TfMetaUtils;
import org.apache.sysml.runtime.util.UtilFunctions;
import org.apache.wink.json4j.JSONObject;

public class EncoderFactory {
    public static Encoder createEncoder(String spec, String[] colnames, int clen, FrameBlock meta) {
        return EncoderFactory.createEncoder(spec, colnames, UtilFunctions.nCopies(clen, Expression.ValueType.STRING), meta);
    }

    public static Encoder createEncoder(String spec, String[] colnames, Expression.ValueType[] schema, int clen, FrameBlock meta) {
        Expression.ValueType[] lschema = schema == null ? UtilFunctions.nCopies(clen, Expression.ValueType.STRING) : schema;
        return EncoderFactory.createEncoder(spec, colnames, lschema, meta);
    }

    public static Encoder createEncoder(String spec, String[] colnames, Expression.ValueType[] schema, FrameBlock meta) {
        EncoderComposite encoder = null;
        int clen = schema.length;
        try {
            JSONObject jSpec = new JSONObject(spec);
            ArrayList<Encoder> lencoders = new ArrayList<Encoder>();
            List<Integer> rcIDs = Arrays.asList(ArrayUtils.toObject(TfMetaUtils.parseJsonIDList(jSpec, colnames, "recode")));
            List<Integer> dcIDs = Arrays.asList(ArrayUtils.toObject(TfMetaUtils.parseJsonIDList(jSpec, colnames, "dummycode")));
            rcIDs = new ArrayList<Integer>(CollectionUtils.union(rcIDs, dcIDs));
            List<Integer> binIDs = TfMetaUtils.parseBinningColIDs(jSpec, colnames);
            ArrayList ptIDs = new ArrayList(CollectionUtils.subtract(CollectionUtils.subtract(UtilFunctions.getSeqList(1, clen, 1), rcIDs), binIDs));
            List<Integer> oIDs = Arrays.asList(ArrayUtils.toObject(TfMetaUtils.parseJsonIDList(jSpec, colnames, "omit")));
            List<Integer> mvIDs = Arrays.asList(ArrayUtils.toObject(TfMetaUtils.parseJsonObjectIDList(jSpec, colnames, "impute")));
            if (!rcIDs.isEmpty()) {
                EncoderRecode ra = new EncoderRecode(jSpec, colnames, clen);
                ra.setColList(ArrayUtils.toPrimitive(rcIDs.toArray(new Integer[0])));
                lencoders.add(ra);
            }
            if (!ptIDs.isEmpty()) {
                lencoders.add(new EncoderPassThrough(ArrayUtils.toPrimitive(ptIDs.toArray(new Integer[0])), clen));
            }
            if (!dcIDs.isEmpty()) {
                lencoders.add(new EncoderDummycode(jSpec, colnames, schema.length));
            }
            if (!binIDs.isEmpty()) {
                lencoders.add(new EncoderBin(jSpec, colnames, schema.length, true));
            }
            if (!oIDs.isEmpty()) {
                lencoders.add(new EncoderOmit(jSpec, colnames, schema.length));
            }
            if (!mvIDs.isEmpty()) {
                EncoderMVImpute ma = new EncoderMVImpute(jSpec, colnames, schema.length);
                ma.initRecodeIDList(rcIDs);
                lencoders.add(ma);
            }
            encoder = new EncoderComposite(lencoders);
            if (meta != null) {
                Object[] colnames2 = meta.getColumnNames();
                if (!TfMetaUtils.isIDSpec(jSpec) && colnames != null && colnames2 != null && !ArrayUtils.isEquals(colnames, colnames2)) {
                    HashMap<String, Integer> colPos = EncoderFactory.getColumnPositions((String[])colnames2);
                    FrameBlock meta2 = new FrameBlock(meta.getSchema(), (String[])colnames2);
                    meta2.setNumRows(meta.getNumRows());
                    for (int i = 0; i < colnames.length; ++i) {
                        if (!colPos.containsKey(colnames[i])) {
                            throw new DMLRuntimeException("Column name not found in meta data: " + colnames[i] + " (meta: " + Arrays.toString(colnames2) + ")");
                        }
                        int pos = colPos.get(colnames[i]);
                        meta2.setColumn(i, meta.getColumn(pos));
                        meta2.setColumnMetadata(i, meta.getColumnMetadata(pos));
                    }
                    meta = meta2;
                }
                ((Encoder)encoder).initMetaData(meta);
            }
        }
        catch (Exception ex) {
            throw new DMLRuntimeException(ex);
        }
        return encoder;
    }

    private static HashMap<String, Integer> getColumnPositions(String[] colnames) {
        HashMap<String, Integer> ret = new HashMap<String, Integer>();
        for (int i = 0; i < colnames.length; ++i) {
            ret.put(colnames[i], i);
        }
        return ret;
    }
}

