/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.process.traversal.traverser.util;

import java.io.Serializable;

public class LabelledCounter
implements Serializable,
Cloneable {
    private final String label;
    private short count = 0;

    protected LabelledCounter() {
        this.label = "";
    }

    public LabelledCounter(String label, short initialCount) {
        if (label == null) {
            throw new NullPointerException("Label is null");
        }
        this.label = label;
        this.count = initialCount;
    }

    public boolean hasLabel(String label) {
        return this.label.equals(label);
    }

    public int count() {
        return this.count;
    }

    public void increment() {
        this.count = (short)(this.count + 1);
    }

    public Object clone() {
        return new LabelledCounter(this.label, this.count);
    }

    public String toString() {
        return "Step Label: " + this.label + " Counter: " + Short.toString(this.count);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof LabelledCounter)) {
            return false;
        }
        LabelledCounter that = (LabelledCounter)o;
        if (this.count != that.count) {
            return false;
        }
        return this.label != null ? this.label.equals(that.label) : that.label == null;
    }

    public int hashCode() {
        int result = this.label != null ? this.label.hashCode() : 0;
        result = 31 * result + this.count;
        return result;
    }
}

