/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.jakartaee.bcel.util;

import java.io.IOException;
import java.io.InputStream;
import org.apache.tomcat.jakartaee.bcel.classfile.ClassParser;
import org.apache.tomcat.jakartaee.bcel.classfile.JavaClass;
import org.apache.tomcat.jakartaee.bcel.classfile.Utility;
import org.apache.tomcat.jakartaee.bcel.util.ClassPath;
import org.apache.tomcat.jakartaee.bcel.util.Repository;

abstract class AbstractClassPathRepository
implements Repository {
    private final ClassPath classPath;

    AbstractClassPathRepository(ClassPath classPath) {
        this.classPath = classPath;
    }

    @Override
    public abstract void clear();

    @Override
    public abstract JavaClass findClass(String var1);

    @Override
    public ClassPath getClassPath() {
        return this.classPath;
    }

    @Override
    public JavaClass loadClass(Class<?> clazz) throws ClassNotFoundException {
        JavaClass javaClass;
        block10: {
            String className = clazz.getName();
            JavaClass repositoryClass = this.findClass(className);
            if (repositoryClass != null) {
                return repositoryClass;
            }
            String name = className;
            int i = name.lastIndexOf(46);
            if (i > 0) {
                name = name.substring(i + 1);
            }
            InputStream clsStream = clazz.getResourceAsStream(name + ".class");
            try {
                javaClass = this.loadClass(clsStream, className);
                if (clsStream == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (clsStream != null) {
                        try {
                            clsStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    return null;
                }
            }
            clsStream.close();
        }
        return javaClass;
    }

    private JavaClass loadClass(InputStream inputStream, String className) throws ClassNotFoundException {
        try {
            if (inputStream != null) {
                ClassParser parser = new ClassParser(inputStream, className);
                JavaClass clazz = parser.parse();
                this.storeClass(clazz);
                return clazz;
            }
        }
        catch (IOException e) {
            throw new ClassNotFoundException("Exception while looking for class " + className + ": " + e, e);
        }
        throw new ClassNotFoundException("ClassRepository could not load " + className);
    }

    @Override
    public JavaClass loadClass(String className) throws ClassNotFoundException {
        JavaClass javaClass;
        block10: {
            if (className == null || className.isEmpty()) {
                throw new IllegalArgumentException("Invalid class name " + className);
            }
            JavaClass clazz = this.findClass(className = Utility.pathToPackage(className));
            if (clazz != null) {
                return clazz;
            }
            InputStream inputStream = this.classPath.getInputStream(className);
            try {
                javaClass = this.loadClass(inputStream, className);
                if (inputStream == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new ClassNotFoundException("Exception while looking for class " + className + ": " + e, e);
                }
            }
            inputStream.close();
        }
        return javaClass;
    }

    @Override
    public abstract void removeClass(JavaClass var1);

    @Override
    public abstract void storeClass(JavaClass var1);
}

