package org.apache.fulcrum.intake;

/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

/**
 * Base runtime exception thrown by the Intake service.
 *
 * @author <a href="mailto:epugh@upstate.com">Eric Pugh</a>
 * @version $Id$
 */
public class IntakeRuntimeException extends RuntimeException
{
    /**
     * Serial version id
     */
    private static final long serialVersionUID = -6874511109052092373L;

    /**
     * Constructs a new <code>IntakeRuntimeException</code> without specified
     * detail message.
     */
    public IntakeRuntimeException()
    {
        super();
    }

    /**
     * Constructs a new <code>IntakeRuntimeException</code> with specified
     * detail message.
     *
     * @param msg The error message.
     */
    public IntakeRuntimeException(String msg)
    {
        super(msg);
    }

    /**
     * Constructs a new <code>IntakeRuntimeException</code> with specified
     * nested <code>Throwable</code>.
     *
     * @param nested The exception or error that caused this exception
     *               to be thrown.
     */
    public IntakeRuntimeException(Throwable nested)
    {
        super(nested);
    }

    /**
     * Constructs a new <code>IntakeRuntimeException</code> with specified
     * detail message and nested <code>Throwable</code>.
     *
     * @param msg    The error message.
     * @param nested The exception or error that caused this exception
     *               to be thrown.
     */
    public IntakeRuntimeException(String msg, Throwable nested)
    {
        super(msg, nested);
    }

}
