package org.apache.stratum.component;

/*
 * Copyright 2001-2005 The Apache Software Foundation or its licensors,
 * as applicable.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

import junit.framework.TestCase;

import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.log4j.Category;

/**
 * TODO: DOCUMENT ME!
 *
 * @author $author$
 * @version $Id: TestComponentLoader.java 264191 2005-08-29 18:07:52Z henning $
 */
public class TestComponentLoader
        extends TestCase
{
    /** TODO: DOCUMENT ME! */
    private static Category log = Category.getInstance(TestComponentLoader.class);

    /** TODO: DOCUMENT ME! */
    private static String CONFIG = "src/test-conf/ComponentLoader.properties";

    /** TODO: DOCUMENT ME! */
    private static Configuration config;

    static
    {
        try
        {
            config = new PropertiesConfiguration(CONFIG);
        }
        catch (ConfigurationException ce)
        {
            log.error("unable to configure ComponentLoader from '" + CONFIG + "'.");
        }
    }

    /** TODO: DOCUMENT ME! */
    private ComponentLoader cl = new ComponentLoader(config);

    /**
     * Creates a new TestComponentLoader object.
     *
     * @param name TODO: DOCUMENT ME!
     */
    public TestComponentLoader(String name)
    {
        super(name);
    }

    /**
     * TODO: DOCUMENT ME!
     */
    public void testConstructor()
    {
        ComponentLoader loader = new ComponentLoader(config);
        Configuration loaderConfig = loader.getConfiguration();
        assertNotNull(loaderConfig);
        assertEquals("org.apache.stratum.component.MockComponent", loaderConfig.getString("component.testing.classname"));
    }

    /**
     * TODO: DOCUMENT ME!
     */
    public void testLoadComponent()
    {
        String goodClassName = "org.apache.stratum.component.MockComponent";
        String goodConfigFile = "src/test-conf/TestComponentLoader.properties";
        String badClassName = "org.apache.stratum.component.MissingMockComponent";
        String badConfigFile = "src/test-conf/MissingTestComponentLoader.properties";

        // test loading with a mock component
        MockComponent comp = (MockComponent) cl.loadComponent(goodClassName, goodConfigFile, null);

        // test that loadComponent() catches the IOException
        cl.loadComponent(badClassName, goodConfigFile, null);

        // test that loadComponent() catches the ClassNotFoundException
        cl.loadComponent(goodClassName, badConfigFile, null);
    }

    /**
     * TODO: DOCUMENT ME!
     */
    public void testLoad()
    {
        assertNotNull(cl);

        Object [] comps = cl.load();

        int key1FinderCount = 0;

        for (int i = 0; i < comps.length; i++)
        {
            if (comps[i] instanceof MockComponent)
            {
                MockComponent mc = (MockComponent) comps[i];
                Configuration config = mc.getConfiguration();

                if (config.getProperty("key1") != null)
                {
                    assertEquals("ensure key2 is present and correct", "value2", config.getProperty("key2"));
                    key1FinderCount++;
                }
            }
        }

        assertEquals("should only find key1 once", key1FinderCount, 1);
    }
}
