/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.om.security.peer;

import com.workingdogs.village.Column;
import com.workingdogs.village.Record;
import com.workingdogs.village.Schema;
import com.workingdogs.village.Value;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import org.apache.torque.Torque;
import org.apache.torque.TorqueException;
import org.apache.torque.map.TableMap;
import org.apache.torque.om.NumberKey;
import org.apache.torque.om.ObjectKey;
import org.apache.torque.om.Persistent;
import org.apache.torque.util.BasePeer;
import org.apache.torque.util.Criteria;
import org.apache.turbine.om.security.User;
import org.apache.turbine.om.security.peer.UserPeer;
import org.apache.turbine.services.security.TurbineSecurity;
import org.apache.turbine.util.ObjectUtils;
import org.apache.turbine.util.db.map.TurbineMapBuilder;
import org.apache.turbine.util.security.DataBackendException;

public class TurbineUserPeer
extends BasePeer
implements UserPeer {
    private static final long serialVersionUID = -5981268145973167352L;
    private static final TurbineMapBuilder MAP_BUILDER;
    private static final String USER_ID_COLUMN;
    public static final String CONFIRM_DATA;
    private static final String OBJECT_DATA_COLUMN;
    private static final String TABLE_NAME;
    public static final String USER_ID;
    public static final String USERNAME;
    public static final String PASSWORD;
    public static final String FIRST_NAME;
    public static final String LAST_NAME;
    public static final String MODIFIED;
    public static final String CREATED;
    public static final String EMAIL;
    public static final String LAST_LOGIN;
    public static final String CONFIRM_VALUE;
    public static final String OBJECT_DATA;
    private static Schema schema;
    private static Column[] columns;
    public static String[] columnNames;
    public static String[] criteriaKeys;

    public static String getTableName() {
        return TABLE_NAME;
    }

    public static String getColumnName(String name) {
        StringBuffer sb = new StringBuffer();
        sb.append(TABLE_NAME);
        sb.append(".");
        sb.append(name);
        return sb.toString();
    }

    public String getFullColumnName(String name) {
        StringBuffer sb = new StringBuffer();
        sb.append(TABLE_NAME);
        sb.append(".");
        sb.append(name);
        return sb.toString();
    }

    public static Criteria buildCriteria(User user) {
        Hashtable permData = (Hashtable)user.getPermStorage().clone();
        Criteria criteria = new Criteria();
        if (!((Persistent)user).isNew()) {
            criteria.add(USER_ID, (Object)((Persistent)user).getPrimaryKey());
        }
        for (int i = 1; i < columnNames.length; ++i) {
            if (!permData.containsKey(columnNames[i])) continue;
            criteria.add(criteriaKeys[i], permData.remove(columnNames[i]));
        }
        criteria.add(OBJECT_DATA, (Object)permData);
        return criteria;
    }

    public static void addSelectColumns(Criteria criteria) throws TorqueException {
        for (int i = 0; i < columnNames.length; ++i) {
            criteria.addSelectColumn(TABLE_NAME + "." + columnNames[i]);
        }
    }

    public static void populateObject(Record row, int offset, User obj) throws TorqueException {
        try {
            int idPosition = 1;
            int objectDataPosition = columnNames.length;
            for (int i = 0; i < columnNames.length; ++i) {
                if (columnNames[i].equals(USER_ID_COLUMN)) {
                    idPosition = i + 1;
                }
                if (!columnNames[i].equals(OBJECT_DATA_COLUMN)) continue;
                objectDataPosition = i + 1;
            }
            ((Persistent)obj).setPrimaryKey((ObjectKey)new NumberKey(row.getValue(idPosition).asBigDecimal()));
            byte[] objectData = row.getValue(objectDataPosition).asBytes();
            Hashtable<String, Object> tempHash = (Hashtable<String, Object>)ObjectUtils.deserialize(objectData);
            if (tempHash == null) {
                tempHash = new Hashtable<String, Object>(10);
            }
            for (int j = 0; j < columnNames.length; ++j) {
                if (columnNames[j].equalsIgnoreCase(USER_ID_COLUMN) || columnNames[j].equalsIgnoreCase(OBJECT_DATA_COLUMN)) continue;
                Object obj2 = null;
                Value value = row.getValue(j + 1);
                if (value.isByte()) {
                    obj2 = new Byte(value.asByte());
                }
                if (value.isBigDecimal()) {
                    obj2 = value.asBigDecimal();
                }
                if (value.isBytes()) {
                    obj2 = value.asBytes();
                }
                if (value.isDate()) {
                    obj2 = value.asDate();
                }
                if (value.isShort()) {
                    obj2 = new Short(value.asShort());
                }
                if (value.isInt()) {
                    obj2 = new Integer(value.asInt());
                }
                if (value.isLong()) {
                    obj2 = new Long(value.asLong());
                }
                if (value.isDouble()) {
                    obj2 = new Double(value.asDouble());
                }
                if (value.isFloat()) {
                    obj2 = new Float(value.asFloat());
                }
                if (value.isBoolean()) {
                    obj2 = new Boolean(value.asBoolean());
                }
                if (value.isString()) {
                    obj2 = value.asString();
                }
                if (value.isTime()) {
                    obj2 = value.asTime();
                }
                if (value.isTimestamp()) {
                    obj2 = value.asTimestamp();
                }
                if (value.isUtilDate()) {
                    obj2 = value.asUtilDate();
                }
                if (obj2 == null) continue;
                tempHash.put(columnNames[j], obj2);
            }
            obj.setPermStorage(tempHash);
        }
        catch (Exception ex) {
            throw new TorqueException((Throwable)ex);
        }
    }

    public static List doSelect(Criteria criteria) throws TorqueException {
        return TurbineUserPeer.doSelect(criteria, (User)null);
    }

    public static List doSelect(Criteria criteria, User current) throws TorqueException {
        TurbineUserPeer.addSelectColumns(criteria);
        if (criteria.getOrderByColumns() == null) {
            criteria.addAscendingOrderByColumn(LAST_NAME);
        }
        List rows = BasePeer.doSelect((Criteria)criteria);
        ArrayList<User> results = new ArrayList<User>();
        for (int i = 0; i < rows.size(); ++i) {
            Record row = (Record)rows.get(i);
            if (current == null) {
                results.add(TurbineUserPeer.row2Object(row, 1, null));
                continue;
            }
            TurbineUserPeer.populateObject(row, 1, current);
            ((Persistent)current).setNew(false);
        }
        return results;
    }

    public static List doSelect(Criteria criteria, Connection dbConn) throws TorqueException {
        TurbineUserPeer.addSelectColumns(criteria);
        if (criteria.getOrderByColumns() == null) {
            criteria.addAscendingOrderByColumn(LAST_NAME);
        }
        List rows = BasePeer.doSelect((Criteria)criteria, (Connection)dbConn);
        ArrayList<User> results = new ArrayList<User>();
        for (int i = 0; i < rows.size(); ++i) {
            Record row = (Record)rows.get(i);
            results.add(TurbineUserPeer.row2Object(row, 1, null));
        }
        return results;
    }

    public static User row2Object(Record row, int offset, Class cls) throws TorqueException {
        try {
            User obj = TurbineSecurity.getUserInstance();
            TurbineUserPeer.populateObject(row, offset, obj);
            ((Persistent)obj).setNew(false);
            ((Persistent)obj).setModified(false);
            return obj;
        }
        catch (Exception ex) {
            throw new TorqueException((Throwable)ex);
        }
    }

    public static Class getOMClass() throws Exception {
        return TurbineSecurity.getUserClass();
    }

    public static void doUpdate(Criteria criteria) throws TorqueException {
        Criteria selectCriteria = new Criteria(2);
        selectCriteria.put((Object)USER_ID, criteria.remove(USER_ID));
        BasePeer.doUpdate((Criteria)selectCriteria, (Criteria)criteria);
    }

    public static boolean checkExists(User user) throws DataBackendException, Exception {
        Criteria criteria = new Criteria();
        criteria.addSelectColumn(USER_ID);
        criteria.add(USERNAME, (Object)user.getName());
        List results = BasePeer.doSelect((Criteria)criteria);
        if (results.size() > 1) {
            throw new DataBackendException("Multiple users named '" + user.getName() + "' exist!");
        }
        return results.size() == 1;
    }

    public static List selectAllUsers() throws Exception {
        Criteria criteria = new Criteria();
        criteria.addAscendingOrderByColumn(LAST_NAME);
        criteria.addAscendingOrderByColumn(FIRST_NAME);
        criteria.setIgnoreCase(true);
        return TurbineUserPeer.doSelect(criteria);
    }

    public static List selectAllConfirmedUsers() throws Exception {
        Criteria criteria = new Criteria();
        criteria.add("CONFIRM_VALUE", (Object)"CONFIRMED");
        criteria.addAscendingOrderByColumn(LAST_NAME);
        criteria.addAscendingOrderByColumn(FIRST_NAME);
        criteria.setIgnoreCase(true);
        return TurbineUserPeer.doSelect(criteria);
    }

    protected static TableMap getTableMap() {
        return MAP_BUILDER.getDatabaseMap().getTable(TABLE_NAME);
    }

    static {
        try {
            MAP_BUILDER = (TurbineMapBuilder)Torque.getMapBuilder((String)TurbineMapBuilder.class.getName());
        }
        catch (TorqueException e) {
            log.error((Object)"Could not initialize Peer", (Throwable)e);
            throw new RuntimeException(e);
        }
        USER_ID_COLUMN = MAP_BUILDER.getUserId();
        CONFIRM_DATA = "CONFIRMED";
        OBJECT_DATA_COLUMN = MAP_BUILDER.getObjectData();
        TABLE_NAME = MAP_BUILDER.getTableUser();
        USER_ID = MAP_BUILDER.getUser_UserId();
        USERNAME = MAP_BUILDER.getUser_Username();
        PASSWORD = MAP_BUILDER.getUser_Password();
        FIRST_NAME = MAP_BUILDER.getUser_FirstName();
        LAST_NAME = MAP_BUILDER.getUser_LastName();
        MODIFIED = MAP_BUILDER.getUser_Modified();
        CREATED = MAP_BUILDER.getUser_Created();
        EMAIL = MAP_BUILDER.getUser_Email();
        LAST_LOGIN = MAP_BUILDER.getUser_LastLogin();
        CONFIRM_VALUE = MAP_BUILDER.getUser_ConfirmValue();
        OBJECT_DATA = MAP_BUILDER.getUser_ObjectData();
        schema = TurbineUserPeer.initTableSchema((String)TABLE_NAME);
        columns = TurbineUserPeer.initTableColumns((Schema)schema);
        columnNames = TurbineUserPeer.initColumnNames((Column[])columns);
        criteriaKeys = TurbineUserPeer.initCriteriaKeys((String)TABLE_NAME, (String[])columnNames);
    }
}

