/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.services.intake.model;

import org.apache.commons.fileupload.FileItem;
import org.apache.turbine.services.intake.IntakeException;
import org.apache.turbine.services.intake.model.Field;
import org.apache.turbine.services.intake.model.Group;
import org.apache.turbine.services.intake.validator.FileValidator;
import org.apache.turbine.services.intake.validator.ValidationException;
import org.apache.turbine.services.intake.xmlmodel.XmlField;
import org.apache.turbine.util.TurbineRuntimeException;
import org.apache.turbine.util.parser.ParameterParser;
import org.apache.turbine.util.parser.ValueParser;

public class FileItemField
extends Field {
    public FileItemField(XmlField field, Group group) throws IntakeException {
        super(field, group);
    }

    public void setDefaultValue(String prop) {
        if (prop != null) {
            throw new TurbineRuntimeException("Default values are not valid for " + this.getClass().getName());
        }
        this.defaultValue = null;
    }

    public void setEmptyValue(String prop) {
        if (prop != null) {
            throw new TurbineRuntimeException("Empty values are not valid for " + this.getClass().getName());
        }
        this.emptyValue = null;
    }

    protected String getDefaultValidator() {
        return FileValidator.class.getName();
    }

    public Field init(ValueParser vp) throws IntakeException {
        try {
            this.parser = (ParameterParser)vp;
        }
        catch (ClassCastException e) {
            throw new IntakeException("FileItemFields can only be used with ParameterParser");
        }
        this.validFlag = true;
        FileItem[] fileItems = ((ParameterParser)this.parser).getFileItems(this.getKey());
        if (fileItems != null) {
            this.setFlag = true;
            this.validate();
        }
        this.initialized = true;
        return this;
    }

    public boolean validate() {
        ParameterParser pp = (ParameterParser)this.parser;
        if (this.isMultiValued) {
            FileItem[] ss = pp.getFileItems(this.getKey());
            if (ss.length == 0) {
                this.setFlag = false;
            }
            if (this.validator != null) {
                for (int i = 0; i < ss.length; ++i) {
                    try {
                        ((FileValidator)this.validator).assertValidity(ss[i]);
                        continue;
                    }
                    catch (ValidationException ve) {
                        this.setMessage(ve.getMessage());
                    }
                }
            }
            if (this.setFlag && this.validFlag) {
                this.doSetValue();
            }
        } else {
            FileItem s = pp.getFileItem(this.getKey());
            if (s == null || s.getSize() == 0L) {
                this.setFlag = false;
            }
            if (this.validator != null) {
                try {
                    ((FileValidator)this.validator).assertValidity(s);
                    if (this.setFlag) {
                        this.doSetValue();
                    }
                }
                catch (ValidationException ve) {
                    this.setMessage(ve.getMessage());
                }
            } else if (this.setFlag) {
                this.doSetValue();
            }
        }
        return this.validFlag;
    }

    protected void doSetValue() {
        ParameterParser pp = (ParameterParser)this.parser;
        if (this.isMultiValued) {
            this.setTestValue(pp.getFileItems(this.getKey()));
        } else {
            this.setTestValue(pp.getFileItem(this.getKey()));
        }
    }
}

