/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.services.intake.validator;

import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.turbine.services.intake.validator.Constraint;
import org.apache.turbine.services.intake.validator.InvalidMaskException;
import org.apache.turbine.services.intake.validator.NumberValidator;
import org.apache.turbine.services.intake.validator.ValidationException;

public class ShortValidator
extends NumberValidator {
    private short minValue = Short.MIN_VALUE;
    private short maxValue = Short.MAX_VALUE;

    public ShortValidator(Map paramMap) throws InvalidMaskException {
        this.invalidNumberMessage = "Entry was not a valid Short";
        this.init(paramMap);
    }

    public ShortValidator() {
    }

    public void init(Map paramMap) throws InvalidMaskException {
        String param;
        super.init(paramMap);
        Constraint constraint = (Constraint)paramMap.get("minValue");
        if (constraint != null) {
            param = constraint.getValue();
            this.minValue = Short.parseShort(param);
            this.minValueMessage = constraint.getMessage();
        }
        if ((constraint = (Constraint)paramMap.get("maxValue")) != null) {
            param = constraint.getValue();
            this.maxValue = Short.parseShort(param);
            this.maxValueMessage = constraint.getMessage();
        }
    }

    public void assertValidity(String testValue) throws ValidationException {
        super.assertValidity(testValue);
        if (this.required || StringUtils.isNotEmpty((String)testValue)) {
            short s = 0;
            try {
                s = Short.parseShort(testValue);
            }
            catch (RuntimeException e) {
                this.errorMessage = this.invalidNumberMessage;
                throw new ValidationException(this.invalidNumberMessage);
            }
            if (s < this.minValue) {
                this.errorMessage = this.minValueMessage;
                throw new ValidationException(this.minValueMessage);
            }
            if (s > this.maxValue) {
                this.errorMessage = this.maxValueMessage;
                throw new ValidationException(this.maxValueMessage);
            }
        }
    }

    public short getMinValue() {
        return this.minValue;
    }

    public void setMinValue(short minValue) {
        this.minValue = minValue;
    }

    public short getMaxValue() {
        return this.maxValue;
    }

    public void setMaxValue(short maxValue) {
        this.maxValue = maxValue;
    }
}

