/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.services.pull.util;

import java.io.InputStream;
import java.util.Properties;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.turbine.Turbine;
import org.apache.turbine.om.security.User;
import org.apache.turbine.services.pull.ApplicationTool;
import org.apache.turbine.services.pull.TurbinePull;
import org.apache.turbine.services.servlet.TurbineServlet;
import org.apache.turbine.util.RunData;
import org.apache.turbine.util.ServerData;
import org.apache.turbine.util.uri.DataURI;

public class UIManager
implements ApplicationTool {
    private static Log log = LogFactory.getLog((Class)UIManager.class);
    private static final String SKINS_DIRECTORY = "/ui/skins";
    private static final String IMAGES_DIRECTORY = "/images";
    private static final String SKIN_PROPERTY = "tool.ui.skin";
    private static final String IMAGEDIR_PROPERTY = "tool.ui.dir.image";
    private static final String SKINDIR_PROPERTY = "tool.ui.dir.skin";
    private static final String CSS_PROPERTY = "tool.ui.css";
    private static final String RELATIVE_PROPERTY = "tool.ui.want.relative";
    private static final String SKIN_PROPERTY_DEFAULT = "default";
    private static final String SKIN_ATTRIBUTE = UIManager.class.getName() + ".skin";
    private String skinName;
    private String skinsDirectory;
    private static final String SKIN_PROPS_FILE = "skin.props";
    private static final String DEFAULT_SKIN_CSS_FILE = "skin.css";
    private String resourcesDirectory;
    private String imagesDirectory;
    private String cssFile;
    private boolean wantRelative = false;
    private Properties skinProperties;

    public void init(Object data) {
        Configuration cfg = Turbine.getConfiguration();
        this.resourcesDirectory = this.stripSlashes(TurbinePull.getResourcesDirectory());
        if (data == null) {
            log.debug((Object)"UI Manager scope is global");
            this.setSkin();
        } else if (data instanceof RunData) {
            log.debug((Object)"UI Manager scope is request");
            this.setSkin((RunData)data);
        } else if (data instanceof User) {
            log.debug((Object)"UI Manager scope is session");
            this.setSkin((User)data);
        }
        this.skinsDirectory = this.stripSlashes(cfg.getString(SKINDIR_PROPERTY, SKINS_DIRECTORY));
        this.imagesDirectory = this.stripSlashes(cfg.getString(IMAGEDIR_PROPERTY, IMAGES_DIRECTORY));
        this.cssFile = cfg.getString(CSS_PROPERTY, DEFAULT_SKIN_CSS_FILE);
        this.wantRelative = cfg.getBoolean(RELATIVE_PROPERTY, false);
        this.loadSkin();
    }

    private String stripSlashes(String path) {
        if (StringUtils.isEmpty((String)path)) {
            return "";
        }
        String ret = path;
        int len = ret.length() - 1;
        if (ret.charAt(len) == '/') {
            ret = ret.substring(0, len);
        }
        if (len > 0 && ret.charAt(0) == '/') {
            ret = ret.substring(1);
        }
        return ret;
    }

    public void refresh() {
        log.debug((Object)"Refreshing UI manager");
        this.loadSkin();
    }

    public String get(String key) {
        return this.skinProperties.getProperty(key);
    }

    public String getSkin() {
        return this.skinName;
    }

    public String image(String imageId, RunData data) {
        DataURI du = new DataURI(data);
        StringBuffer sb = new StringBuffer();
        sb.append(this.resourcesDirectory).append('/').append(this.skinsDirectory).append('/').append(this.getSkin()).append('/').append(this.imagesDirectory).append('/').append(this.stripSlashes(imageId));
        du.setScriptName(sb.toString());
        return this.wantRelative ? du.getRelativeLink() : du.getAbsoluteLink();
    }

    public String image(String imageId) {
        ServerData sd = Turbine.getDefaultServerData();
        DataURI du = new DataURI(sd);
        StringBuffer sb = new StringBuffer();
        sb.append(this.resourcesDirectory).append('/').append(this.skinsDirectory).append('/').append(this.getSkin()).append('/').append(this.imagesDirectory).append('/').append(this.stripSlashes(imageId));
        du.setScriptName(sb.toString());
        return this.wantRelative ? du.getRelativeLink() : du.getAbsoluteLink();
    }

    public String getStylecss(RunData data) {
        return this.getScript(this.cssFile, data);
    }

    public String getStylecss() {
        return this.getScript(this.cssFile);
    }

    public String getScript(String filename, RunData data) {
        DataURI du = new DataURI(data);
        StringBuffer sb = new StringBuffer();
        sb.append(this.resourcesDirectory).append('/').append(this.skinsDirectory).append('/').append(this.getSkin()).append('/').append(this.stripSlashes(filename));
        du.setScriptName(sb.toString());
        return this.wantRelative ? du.getRelativeLink() : du.getAbsoluteLink();
    }

    public String getScript(String filename) {
        ServerData sd = Turbine.getDefaultServerData();
        DataURI du = new DataURI(sd);
        StringBuffer sb = new StringBuffer();
        sb.append(this.resourcesDirectory).append('/').append(this.skinsDirectory).append('/').append(this.getSkin()).append('/').append(this.stripSlashes(filename));
        du.setScriptName(sb.toString());
        return this.wantRelative ? du.getRelativeLink() : du.getAbsoluteLink();
    }

    private void loadSkin() {
        this.skinProperties = new Properties();
        try {
            StringBuffer sb = new StringBuffer();
            sb.append(this.resourcesDirectory).append('/').append(this.skinsDirectory).append('/').append(this.getSkin()).append('/').append(SKIN_PROPS_FILE);
            InputStream is = TurbineServlet.getResourceAsStream(sb.toString());
            this.skinProperties.load(is);
        }
        catch (Exception e) {
            log.error((Object)("Cannot load skin: " + this.skinName));
        }
    }

    public void setSkin() {
        this.skinName = Turbine.getConfiguration().getString(SKIN_PROPERTY, SKIN_PROPERTY_DEFAULT);
    }

    public void setSkin(String skinName) {
        this.skinName = skinName;
    }

    protected void setSkin(RunData data) {
        this.setSkin();
    }

    protected void setSkin(User user) {
        if (user.getTemp(SKIN_ATTRIBUTE) == null) {
            this.setSkin();
        } else {
            this.setSkin((String)user.getTemp(SKIN_ATTRIBUTE));
        }
    }

    public static void setSkin(User user, String skin) {
        user.setTemp(SKIN_ATTRIBUTE, skin);
    }
}

