/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.services.template.mapper;

import java.util.ArrayList;
import java.util.Arrays;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.turbine.services.template.TemplateEngineService;
import org.apache.turbine.services.template.TurbineTemplate;
import org.apache.turbine.services.template.mapper.BaseTemplateMapper;
import org.apache.turbine.services.template.mapper.Mapper;

public class LayoutTemplateMapper
extends BaseTemplateMapper
implements Mapper {
    private static Log log = LogFactory.getLog((Class)LayoutTemplateMapper.class);

    public String doMapping(String template) {
        log.debug((Object)("doMapping(" + template + ")"));
        ArrayList<String> components = new ArrayList<String>(Arrays.asList(StringUtils.split((String)template, (String)String.valueOf(','))));
        int componentSize = components.size() - 1;
        String templateName = (String)components.get(componentSize);
        components.remove(componentSize--);
        log.debug((Object)("templateName is " + templateName));
        TemplateEngineService tes = TurbineTemplate.getTemplateEngineService(templateName);
        if (tes == null) {
            return null;
        }
        String defaultName = TurbineTemplate.getDefaultLayoutTemplateName(templateName);
        boolean firstRun = !templateName.equals(defaultName);
        while (true) {
            String templatePackage = StringUtils.join(components.iterator(), (String)String.valueOf(this.separator));
            log.debug((Object)("templatePackage is now: " + templatePackage));
            StringBuffer testName = new StringBuffer();
            if (!components.isEmpty()) {
                testName.append(templatePackage);
                testName.append(this.separator);
            }
            testName.append(firstRun ? templateName : defaultName);
            StringBuffer templatePath = new StringBuffer();
            if (StringUtils.isNotEmpty((String)this.prefix)) {
                templatePath.append(this.prefix);
                templatePath.append(this.separator);
            }
            templatePath.append(testName);
            log.debug((Object)("Looking for " + templatePath));
            if (tes.templateExists(templatePath.toString())) {
                log.debug((Object)("Found it, returning " + testName));
                return testName.toString();
            }
            if (firstRun) {
                firstRun = false;
                continue;
            }
            if (components.isEmpty()) break;
            components.remove(componentSize--);
        }
        log.debug((Object)"Returning default");
        return this.getDefaultName(template);
    }
}

