/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.services.xmlrpc.util;

import java.net.URL;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.turbine.services.xmlrpc.TurbineXmlRpc;
import org.apache.turbine.services.xmlrpc.util.FileHandler;
import org.apache.turbine.util.TurbineException;

public class FileTransfer {
    private static Log log = LogFactory.getLog((Class)FileTransfer.class);

    public static void send(String serverURL, String sourceLocationProperty, String sourceFileName, String destinationLocationProperty, String destinationFileName) throws TurbineException {
        try {
            Vector<String> params = new Vector<String>();
            params.add(FileHandler.readFileContents(sourceLocationProperty, sourceFileName));
            params.add(destinationLocationProperty);
            params.add(destinationFileName);
            Boolean b = (Boolean)TurbineXmlRpc.executeRpc(new URL(serverURL), "file.send", params);
        }
        catch (Exception e) {
            log.error((Object)"Error sending file to server:", (Throwable)e);
            throw new TurbineException(e);
        }
    }

    public static void send(String serverURL, String username, String password, String sourceLocationProperty, String sourceFileName, String destinationLocationProperty, String destinationFileName) throws TurbineException {
        try {
            Vector<String> params = new Vector<String>();
            params.add(FileHandler.readFileContents(sourceLocationProperty, sourceFileName));
            params.add(destinationLocationProperty);
            params.add(destinationFileName);
            Boolean b = (Boolean)TurbineXmlRpc.executeAuthenticatedRpc(new URL(serverURL), username, password, "file.send", params);
        }
        catch (Exception e) {
            log.error((Object)"Error sending file to server:", (Throwable)e);
            throw new TurbineException(e);
        }
    }

    public static void get(String serverURL, String sourceLocationProperty, String sourceFileName, String destinationLocationProperty, String destinationFileName) throws TurbineException {
        try {
            Vector<String> params = new Vector<String>();
            params.add(sourceLocationProperty);
            params.add(sourceFileName);
            String fileContents = (String)TurbineXmlRpc.executeRpc(new URL(serverURL), "file.get", params);
            FileHandler.writeFileContents(fileContents, destinationLocationProperty, destinationFileName);
        }
        catch (Exception e) {
            log.error((Object)"Error getting file from server:", (Throwable)e);
            throw new TurbineException(e);
        }
    }

    public static void get(String serverURL, String username, String password, String sourceLocationProperty, String sourceFileName, String destinationLocationProperty, String destinationFileName) throws TurbineException {
        try {
            Vector<String> params = new Vector<String>();
            params.add(sourceLocationProperty);
            params.add(sourceFileName);
            String fileContents = (String)TurbineXmlRpc.executeAuthenticatedRpc(new URL(serverURL), username, password, "file.get", params);
            FileHandler.writeFileContents(fileContents, destinationLocationProperty, destinationFileName);
        }
        catch (Exception e) {
            log.error((Object)"Error getting file from server:", (Throwable)e);
            throw new TurbineException(e);
        }
    }

    public static void remove(String serverURL, String sourceLocationProperty, String sourceFileName) throws TurbineException {
        try {
            Vector<String> params = new Vector<String>();
            params.add(sourceLocationProperty);
            params.add(sourceFileName);
            TurbineXmlRpc.executeRpc(new URL(serverURL), "file.remove", params);
        }
        catch (Exception e) {
            log.error((Object)"Error removing file from server:", (Throwable)e);
            throw new TurbineException(e);
        }
    }

    public static void remove(String serverURL, String username, String password, String sourceLocationProperty, String sourceFileName) throws TurbineException {
        try {
            Vector<String> params = new Vector<String>();
            params.add(sourceLocationProperty);
            params.add(sourceFileName);
            TurbineXmlRpc.executeAuthenticatedRpc(new URL(serverURL), username, password, "file.remove", params);
        }
        catch (Exception e) {
            log.error((Object)"Error removing file from server:", (Throwable)e);
            throw new TurbineException(e);
        }
    }
}

