/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.modules.pages;

import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ecs.Doctype;
import org.apache.turbine.Turbine;
import org.apache.turbine.modules.ActionLoader;
import org.apache.turbine.modules.LayoutLoader;
import org.apache.turbine.modules.Page;
import org.apache.turbine.modules.Screen;
import org.apache.turbine.modules.ScreenLoader;
import org.apache.turbine.util.RunData;
import org.apache.turbine.util.TurbineException;

public class DefaultPage
extends Page {
    protected Log log = LogFactory.getLog(this.getClass());

    public void doBuild(RunData data) throws Exception {
        this.doBuildBeforeAction(data);
        if (data.hasAction()) {
            ActionLoader.getInstance().exec(data, data.getAction());
        }
        if (StringUtils.isNotEmpty((String)data.getRedirectURI())) {
            return;
        }
        this.setDefaultDoctype(data);
        this.doBuildAfterAction(data);
        String screenName = data.getScreen();
        this.log.debug((Object)("Building " + screenName));
        ScreenLoader sl = ScreenLoader.getInstance();
        Screen aScreen = sl.getInstance(screenName);
        String layout = aScreen.getLayout(data);
        if (layout != null) {
            LayoutLoader.getInstance().exec(data, layout);
        } else {
            ScreenLoader.getInstance().exec(data, screenName);
        }
        this.doPostBuild(data);
    }

    protected void doBuildBeforeAction(RunData data) throws Exception {
    }

    protected void doBuildAfterAction(RunData data) throws Exception {
    }

    protected void doPostBuild(RunData data) throws Exception {
    }

    private void setDefaultDoctype(RunData data) throws Exception {
        String errMsg = "default.doctype property not set properly in TurbineResources.properties!";
        List doctypeProperty = Turbine.getConfiguration().getList("default.doctype");
        if (doctypeProperty != null) {
            switch (doctypeProperty.size()) {
                case 0: {
                    break;
                }
                case 1: {
                    String doc = (String)doctypeProperty.get(0);
                    if (doc.equalsIgnoreCase("Html40Transitional")) {
                        data.getPage().setDoctype((Doctype)new Doctype.Html40Transitional());
                        break;
                    }
                    if (doc.equalsIgnoreCase("Html40Strict")) {
                        data.getPage().setDoctype((Doctype)new Doctype.Html40Strict());
                        break;
                    }
                    if (doc.equalsIgnoreCase("Html40Frameset")) {
                        data.getPage().setDoctype((Doctype)new Doctype.Html40Frameset());
                        break;
                    }
                    throw new TurbineException(errMsg);
                }
                case 2: {
                    data.getPage().setDoctype(new Doctype().setIdentifier((String)doctypeProperty.get(0)).setUri((String)doctypeProperty.get(1)));
                    break;
                }
                default: {
                    throw new TurbineException(errMsg);
                }
            }
        }
    }
}

