/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.modules.screens;

import java.io.OutputStream;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.ecs.ConcreteElement;
import org.apache.ecs.StringElement;
import org.apache.turbine.Turbine;
import org.apache.turbine.modules.screens.TemplateScreen;
import org.apache.turbine.services.template.TurbineTemplate;
import org.apache.turbine.services.velocity.TurbineVelocity;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

public class VelocityScreen
extends TemplateScreen {
    private String prefix = "screens/";

    protected void doBuildTemplate(RunData data, Context context) throws Exception {
    }

    protected void doBuildTemplate(RunData data) throws Exception {
        this.doBuildTemplate(data, TurbineVelocity.getContext(data));
    }

    public ConcreteElement buildTemplate(RunData data) throws Exception {
        String screenData = null;
        Context context = TurbineVelocity.getContext(data);
        String screenTemplate = data.getTemplateInfo().getScreenTemplate();
        String templateName = TurbineTemplate.getScreenTemplateName(screenTemplate);
        if (StringUtils.isEmpty((String)templateName)) {
            this.log.error((Object)("Screen " + screenTemplate + " not found!"));
            throw new Exception("Could not find screen for " + screenTemplate);
        }
        try {
            if (this.getLayout(data) == null) {
                TurbineVelocity.handleRequest(context, this.prefix + templateName, (OutputStream)data.getResponse().getOutputStream());
            } else {
                screenData = TurbineVelocity.handleRequest(context, this.prefix + templateName);
            }
        }
        catch (Exception e) {
            context.put("processingException", (Object)e.toString());
            context.put("stackTrace", (Object)ExceptionUtils.getStackTrace((Throwable)e));
            templateName = Turbine.getConfiguration().getString("template.error", "error.vm");
            screenData = TurbineVelocity.handleRequest(context, this.prefix + templateName);
        }
        StringElement output = new StringElement();
        output.setFilterState(false);
        if (screenData != null) {
            output.addElement(screenData);
        }
        return output;
    }

    public static Context getContext(RunData data) {
        return TurbineVelocity.getContext(data);
    }
}

