/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.services.intake.validator;

import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.turbine.services.intake.validator.Constraint;
import org.apache.turbine.services.intake.validator.InvalidMaskException;
import org.apache.turbine.services.intake.validator.NumberValidator;
import org.apache.turbine.services.intake.validator.ValidationException;

public class IntegerValidator
extends NumberValidator {
    private int minValue = Integer.MIN_VALUE;
    private int maxValue = Integer.MAX_VALUE;

    public IntegerValidator(Map paramMap) throws InvalidMaskException {
        this.invalidNumberMessage = "Entry was not a valid Integer";
        this.init(paramMap);
    }

    public IntegerValidator() {
    }

    public void init(Map paramMap) throws InvalidMaskException {
        String param;
        super.init(paramMap);
        Constraint constraint = (Constraint)paramMap.get("minValue");
        if (constraint != null) {
            param = constraint.getValue();
            this.minValue = Integer.parseInt(param);
            this.minValueMessage = constraint.getMessage();
        }
        if ((constraint = (Constraint)paramMap.get("maxValue")) != null) {
            param = constraint.getValue();
            this.maxValue = Integer.parseInt(param);
            this.maxValueMessage = constraint.getMessage();
        }
    }

    public void assertValidity(String testValue) throws ValidationException {
        super.assertValidity(testValue);
        if (this.required || StringUtils.isNotEmpty((String)testValue)) {
            int i = 0;
            try {
                i = Integer.parseInt(testValue);
            }
            catch (RuntimeException e) {
                this.errorMessage = this.invalidNumberMessage;
                throw new ValidationException(this.invalidNumberMessage);
            }
            if (i < this.minValue) {
                this.errorMessage = this.minValueMessage;
                throw new ValidationException(this.minValueMessage);
            }
            if (i > this.maxValue) {
                this.errorMessage = this.maxValueMessage;
                throw new ValidationException(this.maxValueMessage);
            }
        }
    }

    public int getMinValue() {
        return this.minValue;
    }

    public void setMinValue(int minValue) {
        this.minValue = minValue;
    }

    public int getMaxValue() {
        return this.maxValue;
    }

    public void setMaxValue(int maxValue) {
        this.maxValue = maxValue;
    }
}

