/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.services.intake.xmlmodel;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.turbine.services.intake.xmlmodel.Rule;
import org.apache.turbine.services.intake.xmlmodel.XmlGroup;
import org.xml.sax.Attributes;

public class XmlField
implements Serializable {
    private static final long serialVersionUID = 6403078189106766569L;
    private String name;
    private String key;
    private String type;
    private String displayName;
    private String multiValued;
    private XmlGroup parent;
    private List rules;
    private Map ruleMap;
    private String ifRequiredMessage;
    private String mapToObject;
    private String mapToProperty;
    private String validator;
    private String defaultValue;
    private String emptyValue;
    private String displaySize;
    private String fieldClass;

    public XmlField() {
        this.rules = new ArrayList();
        this.ruleMap = new HashMap();
    }

    public XmlField(String name) {
        this.name = name;
        this.rules = new ArrayList();
        this.ruleMap = new HashMap();
    }

    public void loadFromXML(Attributes attrib) {
        this.setName(attrib.getValue("name"));
        this.setKey(attrib.getValue("key"));
        this.setType(attrib.getValue("type"));
        this.setDisplayName(attrib.getValue("displayName"));
        this.setDisplaySize(attrib.getValue("displaySize"));
        this.setMultiValued(attrib.getValue("multiValued"));
        String mapObj = attrib.getValue("mapToObject");
        if (mapObj != null && mapObj.length() != 0) {
            this.setMapToObject(mapObj);
        }
        this.setMapToProperty(attrib.getValue("mapToProperty"));
        this.setFieldClass(attrib.getValue("fieldClass"));
        this.setValidator(attrib.getValue("validator"));
        this.setDefaultValue(attrib.getValue("defaultValue"));
        this.setEmptyValue(attrib.getValue("emptyValue"));
    }

    public String getRawName() {
        return this.name;
    }

    public String getName() {
        return StringUtils.replace((String)this.name, (String)"_", (String)"");
    }

    public void setName(String newName) {
        this.name = newName;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String newDisplayName) {
        this.displayName = newDisplayName;
    }

    private void setDisplaySize(String size) {
        this.displaySize = size;
    }

    public String getDisplaySize() {
        return this.displaySize;
    }

    public void setKey(String newKey) {
        this.key = newKey;
    }

    public String getKey() {
        return this.key;
    }

    public void setType(String newType) {
        this.type = newType;
    }

    public String getType() {
        return this.type;
    }

    public void setMultiValued(String newMultiValued) {
        this.multiValued = newMultiValued;
    }

    public boolean isMultiValued() {
        return this.multiValued != null && this.multiValued.equals("true");
    }

    public void setMapToObject(String objectName) {
        this.mapToObject = objectName;
    }

    public String getMapToObject() {
        return this.mapToObject;
    }

    public void setMapToProperty(String prop) {
        this.mapToProperty = prop;
    }

    public String getMapToProperty() {
        if (this.mapToProperty == null) {
            return this.getName();
        }
        return this.mapToProperty;
    }

    public void setValidator(String prop) {
        this.validator = prop;
    }

    public String getValidator() {
        return this.validator;
    }

    public void setDefaultValue(String prop) {
        this.defaultValue = prop;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public void setEmptyValue(String prop) {
        this.emptyValue = prop;
    }

    public String getEmptyValue() {
        return this.emptyValue;
    }

    public String getVariable() {
        String firstChar = this.getName().substring(0, 1).toLowerCase();
        return firstChar + this.getName().substring(1);
    }

    public void setGroup(XmlGroup parent) {
        this.parent = parent;
        if (this.mapToObject != null && this.mapToObject.length() != 0) {
            this.mapToObject = parent.getAppData().getBasePackage() + this.mapToObject;
        }
    }

    public XmlGroup getGroup() {
        return this.parent;
    }

    public String getIfRequiredMessage() {
        return this.ifRequiredMessage;
    }

    public void setIfRequiredMessage(String v) {
        this.ifRequiredMessage = v;
    }

    public String getFieldClass() {
        return this.fieldClass;
    }

    public void setFieldClass(String v) {
        this.fieldClass = v;
    }

    public Rule addRule(Attributes attrib) {
        Rule rule = new Rule();
        rule.loadFromXML(attrib);
        this.addRule(rule);
        return rule;
    }

    public void addRule(Rule rule) {
        rule.setField(this);
        this.rules.add(rule);
        this.ruleMap.put(rule.getName(), rule);
    }

    public List getRules() {
        return this.rules;
    }

    public Map getRuleMap() {
        return this.ruleMap;
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        result.append(" <field name=\"" + this.name + "\"");
        result.append(" key=\"" + this.key + "\"");
        result.append(" type=\"" + this.type + "\"");
        if (this.displayName != null) {
            result.append(" displayName=\"" + this.displayName + "\"");
        }
        if (this.mapToObject != null) {
            result.append(" mapToObject=\"" + this.mapToObject + "\"");
        }
        if (this.mapToProperty != null) {
            result.append(" mapToProperty=\"" + this.mapToProperty + "\"");
        }
        if (this.validator != null) {
            result.append(" validator=\"" + this.validator + "\"");
        }
        if (this.defaultValue != null) {
            result.append(" defaultValue=\"" + this.defaultValue + "\"");
        }
        if (this.emptyValue != null) {
            result.append(" emptyValue=\"" + this.emptyValue + "\"");
        }
        if (this.rules.size() == 0) {
            result.append(" />\n");
        } else {
            result.append(">\n");
            Iterator i = this.rules.iterator();
            while (i.hasNext()) {
                result.append(i.next());
            }
            result.append("</field>\n");
        }
        return result.toString();
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.defaultWriteObject();
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
    }
}

