/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.services.security.torque;

import java.io.ByteArrayOutputStream;
import java.io.PrintWriter;
import java.sql.Connection;
import java.util.Date;
import java.util.Hashtable;
import javax.servlet.http.HttpSessionBindingEvent;
import org.apache.torque.om.Persistent;
import org.apache.turbine.om.security.User;
import org.apache.turbine.services.security.TurbineSecurity;
import org.apache.turbine.services.security.torque.TorqueObject;
import org.apache.turbine.services.security.torque.UserPeerManager;
import org.apache.turbine.util.ObjectUtils;
import org.apache.turbine.util.security.TurbineSecurityException;

public class TorqueUser
extends TorqueObject
implements User {
    private static final long serialVersionUID = 6623129207135917717L;
    private Date lastAccessDate = null;
    private Hashtable permStorage = null;
    private Hashtable tempStorage = null;

    public TorqueUser() {
        this.setCreateDate(new Date());
        this.tempStorage = new Hashtable(10);
        this.setHasLoggedIn(Boolean.FALSE);
    }

    public TorqueUser(Persistent obj) {
        super(obj);
        this.tempStorage = new Hashtable(10);
        this.setHasLoggedIn(Boolean.FALSE);
    }

    public Persistent getPersistentObj() {
        if (this.obj == null) {
            this.obj = UserPeerManager.newPersistentInstance();
        }
        return this.obj;
    }

    public void save(String torqueName) throws Exception {
        this.setObjectdata(ObjectUtils.serializeHashtable(this.getPermStorage()));
        super.save(torqueName);
    }

    public void save(Connection con) throws Exception {
        this.setObjectdata(ObjectUtils.serializeHashtable(this.getPermStorage()));
        super.save(con);
    }

    public void save() throws TurbineSecurityException {
        try {
            this.setObjectdata(ObjectUtils.serializeHashtable(this.getPermStorage()));
            this.getPersistentObj().save();
        }
        catch (Exception e) {
            throw new TurbineSecurityException("User object said " + e.getMessage(), e);
        }
    }

    public String getName() {
        return UserPeerManager.getName(this.getPersistentObj());
    }

    public void setName(String name) {
        this.setUserName(name);
    }

    public int getId() {
        return UserPeerManager.getIdAsObj(this.getPersistentObj());
    }

    public Integer getIdAsObj() {
        return UserPeerManager.getIdAsObj(this.getPersistentObj());
    }

    public void setId(int id) {
        UserPeerManager.setId(this.getPersistentObj(), id);
    }

    public String getUserName() {
        return this.getName();
    }

    public void setUserName(String name) {
        UserPeerManager.setUserName(this.getPersistentObj(), name);
    }

    public String getPassword() {
        return UserPeerManager.getUserPassword(this.getPersistentObj());
    }

    public void setPassword(String password) {
        UserPeerManager.setUserPassword(this.getPersistentObj(), password);
    }

    public String getFirstName() {
        return UserPeerManager.getUserFirstName(this.getPersistentObj());
    }

    public void setFirstName(String firstName) {
        UserPeerManager.setUserFirstName(this.getPersistentObj(), firstName);
    }

    public String getLastName() {
        return UserPeerManager.getUserLastName(this.getPersistentObj());
    }

    public void setLastName(String lastName) {
        UserPeerManager.setUserLastName(this.getPersistentObj(), lastName);
    }

    public String getEmail() {
        return UserPeerManager.getUserEmail(this.getPersistentObj());
    }

    public void setEmail(String email) {
        UserPeerManager.setUserEmail(this.getPersistentObj(), email);
    }

    public String getConfirmed() {
        return UserPeerManager.getUserConfirmed(this.getPersistentObj());
    }

    public void setConfirmed(String confirm) {
        UserPeerManager.setUserConfirmed(this.getPersistentObj(), confirm);
    }

    public Date getCreateDate() {
        return UserPeerManager.getUserCreateDate(this.getPersistentObj());
    }

    public void setCreateDate(Date createDate) {
        UserPeerManager.setUserCreateDate(this.getPersistentObj(), createDate);
    }

    public Date getLastLogin() {
        return UserPeerManager.getUserLastLogin(this.getPersistentObj());
    }

    public void setLastLogin(Date lastLogin) {
        UserPeerManager.setUserLastLogin(this.getPersistentObj(), lastLogin);
    }

    public byte[] getObjectdata() {
        return UserPeerManager.getUserObjectdata(this.getPersistentObj());
    }

    public void setObjectdata(byte[] objectdata) {
        UserPeerManager.setUserObjectdata(this.getPersistentObj(), objectdata);
    }

    public int getAccessCounter() {
        try {
            return (Integer)this.getPerm("_access_counter");
        }
        catch (Exception e) {
            return 0;
        }
    }

    public int getAccessCounterForSession() {
        try {
            return (Integer)this.getTemp("_session_access_counter");
        }
        catch (Exception e) {
            return 0;
        }
    }

    public void incrementAccessCounter() {
        this.setAccessCounter(this.getAccessCounter() + 1);
    }

    public void incrementAccessCounterForSession() {
        this.setAccessCounterForSession(this.getAccessCounterForSession() + 1);
    }

    public void setAccessCounter(int cnt) {
        this.setPerm("_access_counter", new Integer(cnt));
    }

    public void setAccessCounterForSession(int cnt) {
        this.setTemp("_session_access_counter", new Integer(cnt));
    }

    public boolean isConfirmed() {
        String value = this.getConfirmed();
        return value != null && value.equals("CONFIRMED");
    }

    public boolean hasLoggedIn() {
        Boolean loggedIn = this.getHasLoggedIn();
        return loggedIn != null && loggedIn != false;
    }

    public void setHasLoggedIn(Boolean value) {
        this.setTemp("_has_logged_in", value);
    }

    public Date getLastAccessDate() {
        if (this.lastAccessDate == null) {
            this.setLastAccessDate();
        }
        return this.lastAccessDate;
    }

    public void setLastAccessDate() {
        this.lastAccessDate = new Date();
    }

    public Hashtable getPermStorage() {
        if (this.permStorage == null) {
            byte[] objectdata = this.getObjectdata();
            if (objectdata != null) {
                this.permStorage = (Hashtable)ObjectUtils.deserialize(objectdata);
            }
            if (this.permStorage == null) {
                this.permStorage = new Hashtable();
            }
        }
        return this.permStorage;
    }

    public void setPermStorage(Hashtable permStorage) {
        if (permStorage != null) {
            this.permStorage = permStorage;
        }
    }

    public Hashtable getTempStorage() {
        if (this.tempStorage == null) {
            this.tempStorage = new Hashtable();
        }
        return this.tempStorage;
    }

    public void setTempStorage(Hashtable tempStorage) {
        if (tempStorage != null) {
            this.tempStorage = tempStorage;
        }
    }

    public Object getPerm(String name) {
        return this.getPermStorage().get(name);
    }

    public Object getPerm(String name, Object def) {
        try {
            Object val = this.getPermStorage().get(name);
            return val == null ? def : val;
        }
        catch (Exception e) {
            return def;
        }
    }

    public void setPerm(String name, Object value) {
        this.getPermStorage().put(name, value == null ? "" : value);
    }

    public Object getTemp(String name) {
        return this.getTempStorage().get(name);
    }

    public Object getTemp(String name, Object def) {
        Object val;
        try {
            val = this.getTempStorage().get(name);
            if (val == null) {
                val = def;
            }
        }
        catch (Exception e) {
            val = def;
        }
        return val;
    }

    public void setTemp(String name, Object value) {
        this.getTempStorage().put(name, value == null ? "" : value);
    }

    public Object removeTemp(String name) {
        return this.getTempStorage().remove(name);
    }

    public void updateLastLogin() throws Exception {
        this.setLastLogin(new Date());
    }

    public void valueBound(HttpSessionBindingEvent hsbe) {
    }

    public void valueUnbound(HttpSessionBindingEvent hsbe) {
        try {
            if (this.hasLoggedIn()) {
                TurbineSecurity.saveOnSessionUnbind(this);
            }
        }
        catch (Exception e) {
            ByteArrayOutputStream ostr = new ByteArrayOutputStream();
            e.printStackTrace(new PrintWriter(ostr, true));
            String stackTrace = ostr.toString();
            System.out.println(stackTrace);
        }
    }

    private Boolean getHasLoggedIn() {
        return (Boolean)this.getTemp("_has_logged_in");
    }
}

