/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.services.upload;

import javax.servlet.ServletConfig;
import javax.servlet.http.HttpServletRequest;
import org.apache.turbine.Turbine;
import org.apache.turbine.services.TurbineBaseService;
import org.apache.turbine.services.servlet.TurbineServlet;
import org.apache.turbine.services.upload.UploadService;
import org.apache.turbine.util.ServletUtils;
import org.apache.turbine.util.TurbineException;
import org.apache.turbine.util.parser.ParameterParser;

public abstract class BaseUploadService
extends TurbineBaseService
implements UploadService {
    public static final int MAX_HEADER_SIZE = 1024;

    public void init() {
        String realPath;
        String path = this.getProperties().getProperty("repository", ".".toString());
        if (!path.startsWith("/") && (realPath = TurbineServlet.getRealPath(path)) != null) {
            path = realPath;
        }
        this.getProperties().setProperty("repository", path);
        this.setInit(true);
    }

    public abstract void parseRequest(HttpServletRequest var1, ParameterParser var2, String var3) throws TurbineException;

    public long getSizeMax() {
        return this.getConfiguration().getLong("size.max", 0x100000L);
    }

    public int getSizeThreshold() {
        return this.getConfiguration().getInt("size.threshold", 10240);
    }

    public String getRepository() {
        String tmpPath = this.getConfiguration().getString("repository", ".");
        ServletConfig config = Turbine.getTurbineServletConfig();
        return ServletUtils.expandRelative(config, tmpPath);
    }

    public boolean getAutomatic() {
        return this.getConfiguration().getBoolean("automatic", false);
    }
}

