/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.services.xmlrpc.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import javax.mail.internet.MimeUtility;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.turbine.Turbine;
import org.apache.turbine.services.servlet.TurbineServlet;

public class FileHandler {
    private static Log log = LogFactory.getLog((Class)FileHandler.class);

    public boolean send(String fileContents, String targetLocationProperty, String fileName) {
        return FileHandler.writeFileContents(fileContents, targetLocationProperty, fileName);
    }

    public String get(String targetLocationProperty, String fileName) {
        return FileHandler.readFileContents(targetLocationProperty, fileName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String readFileContents(String targetLocationProperty, String fileName) {
        String string;
        String location = Turbine.getConfiguration().getString(targetLocationProperty);
        if (StringUtils.isEmpty((String)location)) {
            log.error((Object)("Could not load Property for location " + targetLocationProperty));
            return null;
        }
        File tmpF = new File(".");
        StringBuffer sb = new StringBuffer();
        sb.append(location);
        sb.append(File.separator);
        sb.append(fileName);
        String file = TurbineServlet.getRealPath(sb.toString());
        StringWriter sw = null;
        BufferedReader reader = null;
        try {
            try {
                sw = new StringWriter();
                reader = new BufferedReader(new InputStreamReader(new FileInputStream(file)));
                char[] buf = new char[1024];
                int len = 0;
                while ((len = reader.read(buf, 0, 1024)) != -1) {
                    sw.write(buf, 0, len);
                }
                string = MimeUtility.encodeText((String)sw.toString(), (String)"UTF-8", (String)"B");
                Object var12_13 = null;
            }
            catch (IOException ioe) {
                log.error((Object)"[FileHandler] Unable to encode the contents of the request file.", (Throwable)ioe);
                String string2 = null;
                Object var12_14 = null;
                try {
                    if (sw != null) {
                        sw.close();
                    }
                    if (reader == null) return string2;
                    reader.close();
                    return string2;
                }
                catch (Exception e) {
                    // empty catch block
                }
                return string2;
            }
        }
        catch (Throwable throwable) {
            Object var12_15 = null;
            try {}
            catch (Exception e) {
                throw throwable;
            }
            if (sw != null) {
                sw.close();
            }
            if (reader == null) throw throwable;
            reader.close();
            throw throwable;
        }
        try {}
        catch (Exception e) {
            // empty catch block
            return string;
        }
        if (sw != null) {
            sw.close();
        }
        if (reader == null) return string;
        reader.close();
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean writeFileContents(String fileContents, String targetLocationProperty, String fileName) {
        boolean bl;
        String location = Turbine.getConfiguration().getString(targetLocationProperty);
        if (StringUtils.isEmpty((String)location)) {
            log.error((Object)("Could not load Property for location " + targetLocationProperty));
            return false;
        }
        File targetLocation = new File(TurbineServlet.getRealPath(location));
        if (!targetLocation.exists()) {
            if (!targetLocation.mkdirs()) {
                log.error((Object)("[FileHandler] Could not create target location: " + targetLocation + ". Cannot transfer file from client."));
                return false;
            }
            log.info((Object)("[FileHandler] Creating target location:" + targetLocation + " in order to complete file transfer from client."));
        }
        OutputStreamWriter fileWriter = null;
        try {
            try {
                fileWriter = new FileWriter(targetLocation + "/" + fileName);
                fileWriter.write(MimeUtility.decodeText((String)fileContents));
                bl = true;
                Object var9_8 = null;
            }
            catch (IOException ioe) {
                log.error((Object)"[FileHandler] Could not write the decoded file contents to disk for the following reason.", (Throwable)ioe);
                boolean bl2 = false;
                Object var9_9 = null;
                try {
                    if (fileWriter == null) return bl2;
                    fileWriter.close();
                    return bl2;
                }
                catch (Exception e) {
                    // empty catch block
                }
                return bl2;
            }
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            try {}
            catch (Exception e) {
                throw throwable;
            }
            if (fileWriter == null) throw throwable;
            fileWriter.close();
            throw throwable;
        }
        try {}
        catch (Exception e) {
            // empty catch block
            return bl;
        }
        if (fileWriter == null) return bl;
        fileWriter.close();
        return bl;
    }

    public static void remove(String sourceLocationProperty, String sourceFileName) {
        String location = Turbine.getConfiguration().getString(sourceLocationProperty);
        if (StringUtils.isEmpty((String)location)) {
            log.error((Object)("Could not load Property for location " + sourceLocationProperty));
            return;
        }
        File sourceFile = new File(TurbineServlet.getRealPath(sourceLocationProperty + "/" + sourceFileName));
        if (sourceFile.exists()) {
            sourceFile.delete();
        }
    }
}

