/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.util;

import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ecs.html.A;
import org.apache.turbine.Turbine;
import org.apache.turbine.util.RunData;
import org.apache.turbine.util.ServerData;
import org.apache.turbine.util.parser.ParameterParser;
import org.apache.turbine.util.parser.ParserUtils;
import org.apache.turbine.util.uri.URI;

public class DynamicURI
implements URI {
    public static final String HTTP = "http";
    public static final String HTTPS = "https";
    private static Log log = LogFactory.getLog((Class)DynamicURI.class);
    protected ServerData sd = null;
    protected RunData data = null;
    protected String reference = null;
    public HttpServletResponse res = null;
    protected List pathInfo = null;
    protected List queryData = null;
    protected boolean hasPathInfo = false;
    protected boolean hasQueryData = false;
    protected boolean redirect = false;
    protected static final int PATH_INFO = 0;
    protected static final int QUERY_DATA = 1;
    private boolean initialized = false;

    public DynamicURI(RunData data) {
        this.init(data);
    }

    public DynamicURI() {
    }

    public DynamicURI(RunData data, String screen) {
        this(data);
        this.setScreen(screen);
    }

    public DynamicURI(RunData data, String screen, String action) {
        this(data, screen);
        this.setAction(action);
    }

    public DynamicURI(RunData data, String screen, String action, boolean redirect) {
        this(data, screen, action);
        this.redirect = redirect;
    }

    public DynamicURI(RunData data, String screen, boolean redirect) {
        this(data, screen);
        this.redirect = redirect;
    }

    public DynamicURI(RunData data, boolean redirect) {
        this(data);
        this.redirect = redirect;
    }

    public DynamicURI(ServerData sd) {
        this.init(sd);
    }

    public DynamicURI(ServerData sd, String screen) {
        this(sd);
        this.setScreen(screen);
    }

    public DynamicURI(ServerData sd, String screen, String action) {
        this(sd, screen);
        this.setAction(action);
    }

    public DynamicURI(ServerData sd, String screen, String action, boolean redirect) {
        this(sd, screen, action);
        this.redirect = redirect;
    }

    public DynamicURI(ServerData serverData, String screen, boolean redirect) {
        this(serverData, screen);
        this.redirect = redirect;
    }

    public DynamicURI(ServerData serverData, boolean redirect) {
        this(serverData);
        this.redirect = redirect;
        this.initialized = true;
    }

    public void init(RunData data) {
        this.init(data.getServerData());
        this.data = data;
        this.res = data.getResponse();
    }

    public void init(ServerData serverData) {
        this.sd = (ServerData)serverData.clone();
        this.pathInfo = new ArrayList();
        this.queryData = new ArrayList();
        this.reference = null;
        this.initialized = true;
    }

    protected void add(int type, String name, String value) {
        this.assertInitialized();
        Object[] tmp = new Object[]{ParserUtils.convertAndTrim(name), value};
        switch (type) {
            case 0: {
                this.pathInfo.add(tmp);
                this.hasPathInfo = true;
                break;
            }
            case 1: {
                this.queryData.add(tmp);
                this.hasQueryData = true;
            }
        }
    }

    protected void add(int type, ParameterParser pp) {
        Iterator iter = pp.keySet().iterator();
        while (iter.hasNext()) {
            String key = (String)iter.next();
            if (key.equalsIgnoreCase("action") || key.equalsIgnoreCase("screen") || key.equalsIgnoreCase("template")) continue;
            String[] values = pp.getStrings(key);
            for (int i = 0; i < values.length; ++i) {
                this.add(type, key, values[i]);
            }
        }
    }

    public DynamicURI addPathInfo(String name, Object value) {
        this.add(0, name, value.toString());
        return this;
    }

    public DynamicURI addPathInfo(String name, String value) {
        this.add(0, name, value);
        return this;
    }

    public DynamicURI addPathInfo(String name, double value) {
        this.add(0, name, Double.toString(value));
        return this;
    }

    public DynamicURI addPathInfo(String name, int value) {
        this.add(0, name, String.valueOf(value));
        return this;
    }

    public DynamicURI addPathInfo(String name, long value) {
        this.add(0, name, String.valueOf(value));
        return this;
    }

    public DynamicURI addPathInfo(ParameterParser pp) {
        this.add(0, pp);
        return this;
    }

    public DynamicURI addQueryData(String name, Object value) {
        this.add(1, name, value.toString());
        return this;
    }

    public DynamicURI addQueryData(String name, String value) {
        this.add(1, name, value);
        return this;
    }

    public DynamicURI addQueryData(String name, double value) {
        this.add(1, name, Double.toString(value));
        return this;
    }

    public DynamicURI addQueryData(String name, int value) {
        this.add(1, name, String.valueOf(value));
        return this;
    }

    public DynamicURI addQueryData(String name, long value) {
        this.add(1, name, String.valueOf(value));
        return this;
    }

    public DynamicURI addQueryData(ParameterParser pp) {
        this.add(1, pp);
        return this;
    }

    public String getA(String name) {
        return new A(this.toString(), name).toString();
    }

    public String getScriptName() {
        String result = this.getServerData().getScriptName();
        return StringUtils.isEmpty((String)result) ? "" : result;
    }

    public String getContextPath() {
        String result = this.getServerData().getContextPath();
        return StringUtils.isEmpty((String)result) ? "" : result;
    }

    public String getReference() {
        this.assertInitialized();
        return StringUtils.isEmpty((String)this.reference) ? "" : this.reference;
    }

    public String getServerName() {
        String result = this.getServerData().getServerName();
        return StringUtils.isEmpty((String)result) ? "" : result;
    }

    public int getServerPort() {
        int result = this.getServerData().getServerPort();
        return result == 0 ? 80 : result;
    }

    public String getServerScheme() {
        String result = this.getServerData().getServerScheme();
        return StringUtils.isEmpty((String)result) ? "" : result;
    }

    protected void remove(int type, String name) {
        this.assertInitialized();
        try {
            switch (type) {
                case 0: {
                    Iterator iter = this.pathInfo.iterator();
                    while (iter.hasNext()) {
                        Object[] tmp = (Object[])iter.next();
                        if (!ParserUtils.convertAndTrim(name).equals((String)tmp[0])) continue;
                        iter.remove();
                    }
                    if (!this.hasPathInfo || this.pathInfo.size() != 0) break;
                    this.hasPathInfo = false;
                    break;
                }
                case 1: {
                    Iterator iter = this.pathInfo.iterator();
                    while (iter.hasNext()) {
                        Object[] tmp = (Object[])iter.next();
                        if (!ParserUtils.convertAndTrim(name).equals((String)tmp[0])) continue;
                        iter.remove();
                    }
                    if (!this.hasQueryData || this.queryData.size() != 0) break;
                    this.hasQueryData = false;
                }
            }
        }
        catch (Exception e) {
            log.error((Object)("Could not remove " + name), (Throwable)e);
        }
    }

    public void removePathInfo() {
        this.assertInitialized();
        this.pathInfo.clear();
        this.hasPathInfo = false;
    }

    public void removePathInfo(String name) {
        this.remove(0, name);
    }

    public void removeQueryData() {
        this.assertInitialized();
        this.queryData.clear();
        this.hasQueryData = false;
    }

    public void removeQueryData(String name) {
        this.remove(1, name);
    }

    protected String renderPathInfo(List data) {
        String key = null;
        String value = null;
        String tmp = null;
        StringBuffer out = new StringBuffer();
        Iterator iter = data.iterator();
        while (iter.hasNext()) {
            Object[] stuff = (Object[])iter.next();
            key = URLEncoder.encode((String)stuff[0]);
            tmp = (String)stuff[1];
            value = tmp == null || tmp.length() == 0 ? "null" : URLEncoder.encode(tmp);
            if (out.length() > 0) {
                out.append("/");
            }
            out.append(key);
            out.append("/");
            out.append(value);
        }
        return out.toString();
    }

    protected String renderQueryString(List data) {
        String key = null;
        String value = null;
        String tmp = null;
        StringBuffer out = new StringBuffer();
        Iterator iter = data.iterator();
        while (iter.hasNext()) {
            Object[] stuff = (Object[])iter.next();
            key = URLEncoder.encode((String)stuff[0]);
            tmp = (String)stuff[1];
            value = tmp == null || tmp.length() == 0 ? "null" : URLEncoder.encode(tmp);
            if (out.length() > 0) {
                out.append("&");
            }
            out.append(key);
            out.append("=");
            out.append(value);
        }
        return out.toString();
    }

    public DynamicURI setAction(String action) {
        this.add(0, "action", action);
        return this;
    }

    public DynamicURI setActionEvent(String actionName, String eventName) {
        this.setAction(actionName).addPathInfo("eventSubmit_" + eventName, eventName);
        return this;
    }

    public DynamicURI setScreen(String screen) {
        this.add(0, "screen", screen);
        return this;
    }

    public DynamicURI setScriptName(String name) {
        this.getServerData().setScriptName(name);
        return this;
    }

    public DynamicURI setContextPath(String contextPath) {
        this.getServerData().setContextPath(contextPath);
        return this;
    }

    public DynamicURI setReference(String reference) {
        this.reference = reference;
        return this;
    }

    public DynamicURI setServerName(String name) {
        this.getServerData().setServerName(name);
        return this;
    }

    public DynamicURI setServerPort(int port) {
        this.getServerData().setServerPort(port);
        return this;
    }

    public DynamicURI setSecure() {
        return this.setSecure(443);
    }

    public DynamicURI setSecure(int port) {
        boolean useSSL = Turbine.getConfiguration().getBoolean("use.ssl", true);
        this.setServerScheme(useSSL ? HTTPS : HTTP);
        this.setServerPort(port);
        return this;
    }

    public DynamicURI setServerScheme(String scheme) {
        this.getServerData().setServerScheme(scheme);
        return this;
    }

    public String toString() {
        this.assertInitialized();
        StringBuffer output = new StringBuffer();
        output.append(this.getServerScheme());
        output.append("://");
        output.append(this.getServerName());
        if (this.getServerScheme().equals(HTTP) && this.getServerPort() != 80 || this.getServerScheme().equals(HTTPS) && this.getServerPort() != 443) {
            output.append(":");
            output.append(this.getServerPort());
        }
        output.append(this.getContextPath());
        output.append(this.getScriptName());
        if (this.hasPathInfo) {
            output.append("/");
            output.append(this.renderPathInfo(this.pathInfo));
        }
        if (this.hasQueryData) {
            output.append("?");
            output.append(this.renderQueryString(this.queryData));
        }
        if (this.reference != null) {
            output.append("#");
            output.append(this.getReference());
        }
        if (this.res != null) {
            if (this.redirect) {
                return this.res.encodeRedirectURL(output.toString());
            }
            return this.res.encodeURL(output.toString());
        }
        return output.toString();
    }

    public static String toString(RunData data) {
        StringBuffer output = new StringBuffer();
        HttpServletRequest request = data.getRequest();
        output.append(data.getServerScheme());
        output.append("://");
        output.append(data.getServerName());
        if (data.getServerScheme().equals(HTTP) && data.getServerPort() != 80 || data.getServerScheme().equals(HTTPS) && data.getServerPort() != 443) {
            output.append(":");
            output.append(data.getServerPort());
        }
        output.append(data.getServerData().getContextPath());
        output.append(data.getServerData().getScriptName());
        if (request.getPathInfo() != null) {
            output.append(request.getPathInfo());
        }
        if (request.getQueryString() != null) {
            output.append("?");
            output.append(request.getQueryString());
        }
        return output.toString();
    }

    public ServerData getServerData() {
        this.assertInitialized();
        return this.sd;
    }

    public void setServerData(ServerData serverData) {
        this.sd = serverData;
    }

    protected void assertInitialized() {
        if (!this.initialized) {
            throw new IllegalStateException("Not initialized");
        }
    }
}

