/*
 * Decompiled with CFR 0.152.
 */
package org.apache.torque;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.LinkedList;
import java.util.StringTokenizer;
import org.apache.torque.TorqueException;

public class TorqueRuntimeException
extends RuntimeException {
    private static final long serialVersionUID = -2997617341459640541L;
    private Throwable nested = null;

    public TorqueRuntimeException() {
    }

    public TorqueRuntimeException(String msg) {
        super(msg);
    }

    public TorqueRuntimeException(Throwable nested) {
        this.nested = nested;
    }

    public TorqueRuntimeException(String msg, Throwable nested) {
        super(msg);
        this.nested = nested;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printStackTrace() {
        PrintStream printStream = System.err;
        synchronized (printStream) {
            this.printStackTrace(System.err);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printStackTrace(PrintStream out) {
        PrintStream printStream = out;
        synchronized (printStream) {
            PrintWriter pw = new PrintWriter(out, false);
            this.printStackTrace(pw);
            pw.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printStackTrace(PrintWriter out) {
        PrintWriter printWriter = out;
        synchronized (printWriter) {
            this.printStackTrace(out, 0);
        }
    }

    public void printStackTrace(PrintWriter out, int skip) {
        String[] st = this.captureStackTrace();
        if (this.nested != null) {
            if (this.nested instanceof TorqueRuntimeException) {
                ((TorqueRuntimeException)this.nested).printStackTrace(out, st.length - 2);
            } else if (this.nested instanceof TorqueException) {
                ((TorqueException)((Object)this.nested)).printStackTrace(out);
            } else {
                String[] nst = this.captureStackTrace(this.nested);
                for (int i = 0; i < nst.length - st.length + 2; ++i) {
                    out.println(nst[i]);
                }
            }
            out.print("rethrown as ");
        }
        for (int i = 0; i < st.length - skip; ++i) {
            out.println(st[i]);
        }
    }

    private String[] captureStackTrace() {
        StringWriter sw = new StringWriter();
        super.printStackTrace(new PrintWriter((Writer)sw, true));
        return this.splitStackTrace(sw.getBuffer().toString());
    }

    private String[] captureStackTrace(Throwable t) {
        StringWriter sw = new StringWriter();
        t.printStackTrace(new PrintWriter((Writer)sw, true));
        return this.splitStackTrace(sw.getBuffer().toString());
    }

    private String[] splitStackTrace(String stackTrace) {
        String linebreak = System.getProperty("line.separator");
        StringTokenizer st = new StringTokenizer(stackTrace, linebreak);
        LinkedList<String> list = new LinkedList<String>();
        while (st.hasMoreTokens()) {
            list.add(st.nextToken());
        }
        return list.toArray(new String[list.size()]);
    }
}

