/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.annotation;

import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.turbine.Turbine;
import org.apache.turbine.annotation.TurbineConfiguration;
import org.apache.turbine.annotation.TurbineLoader;
import org.apache.turbine.annotation.TurbineService;
import org.apache.turbine.modules.Assembler;
import org.apache.turbine.modules.Loader;
import org.apache.turbine.services.ServiceManager;
import org.apache.turbine.services.TurbineServices;
import org.apache.turbine.services.assemblerbroker.AssemblerBrokerService;
import org.apache.turbine.util.TurbineException;

public class AnnotationProcessor {
    private static Log log = LogFactory.getLog(AnnotationProcessor.class);
    private static ConcurrentMap<String, Annotation[]> annotationCache = new ConcurrentHashMap<String, Annotation[]>();

    public static Annotation[] getAnnotations(AccessibleObject object) {
        Annotation[] newAnnotations;
        String key = object.getClass() + object.toString();
        Annotation[] annotations = (Annotation[])annotationCache.get(key);
        if (annotations == null && (annotations = annotationCache.putIfAbsent(key, newAnnotations = object.getDeclaredAnnotations())) == null) {
            annotations = newAnnotations;
        }
        return annotations;
    }

    public static void process(Object object) throws TurbineException {
        ServiceManager manager = null;
        Configuration config = null;
        AssemblerBrokerService assembler = null;
        for (Class<?> clazz = object.getClass(); clazz != null; clazz = clazz.getSuperclass()) {
            Field[] fields;
            for (Field field : fields = clazz.getDeclaredFields()) {
                Annotation[] annotations;
                for (Annotation a : annotations = AnnotationProcessor.getAnnotations(field)) {
                    if (a instanceof TurbineService) {
                        if (manager == null) {
                            manager = TurbineServices.getInstance();
                        }
                        AnnotationProcessor.injectTurbineService(object, manager, field, (TurbineService)a);
                        continue;
                    }
                    if (a instanceof TurbineConfiguration) {
                        if (config == null) {
                            config = Turbine.getConfiguration();
                        }
                        AnnotationProcessor.injectTurbineConfiguration(object, config, field, (TurbineConfiguration)a);
                        continue;
                    }
                    if (!(a instanceof TurbineLoader)) continue;
                    if (assembler == null) {
                        assembler = (AssemblerBrokerService)TurbineServices.getInstance().getService("AssemblerBrokerService");
                    }
                    AnnotationProcessor.injectTurbineLoader(object, assembler, field, (TurbineLoader)a);
                }
            }
        }
    }

    private static void injectTurbineLoader(Object object, AssemblerBrokerService assembler, Field field, TurbineLoader annotation) throws TurbineException {
        Loader<? extends Assembler> loader = assembler.getLoader(annotation.value());
        field.setAccessible(true);
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Injection of " + loader + " into object " + object));
            }
            field.set(object, loader);
        }
        catch (IllegalArgumentException e) {
            throw new TurbineException("Could not inject loader " + loader + " into object " + object, e);
        }
        catch (IllegalAccessException e) {
            throw new TurbineException("Could not inject loader " + loader + " into object " + object, e);
        }
    }

    private static void injectTurbineConfiguration(Object object, Configuration conf, Field field, TurbineConfiguration annotation) throws TurbineException {
        Class<?> type = field.getType();
        String key = annotation.value();
        try {
            if (Configuration.class.isAssignableFrom(type)) {
                if (StringUtils.isNotEmpty((String)key)) {
                    conf = conf.subset(key);
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Injection of " + conf + " into object " + object));
                }
                field.setAccessible(true);
                field.set(object, conf);
            } else if (conf.containsKey(key)) {
                if (String.class.isAssignableFrom(type)) {
                    String value = conf.getString(key);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Injection of " + value + " into object " + object));
                    }
                    field.setAccessible(true);
                    field.set(object, value);
                } else if (Boolean.TYPE.isAssignableFrom(type)) {
                    boolean value = conf.getBoolean(key);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Injection of " + value + " into object " + object));
                    }
                    field.setAccessible(true);
                    field.setBoolean(object, value);
                } else if (Integer.TYPE.isAssignableFrom(type)) {
                    int value = conf.getInt(key);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Injection of " + value + " into object " + object));
                    }
                    field.setAccessible(true);
                    field.setInt(object, value);
                } else if (Long.TYPE.isAssignableFrom(type)) {
                    long value = conf.getLong(key);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Injection of " + value + " into object " + object));
                    }
                    field.setAccessible(true);
                    field.setLong(object, value);
                } else if (Short.TYPE.isAssignableFrom(type)) {
                    short value = conf.getShort(key);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Injection of " + value + " into object " + object));
                    }
                    field.setAccessible(true);
                    field.setShort(object, value);
                } else if (Long.TYPE.isAssignableFrom(type)) {
                    long value = conf.getLong(key);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Injection of " + value + " into object " + object));
                    }
                    field.setAccessible(true);
                    field.setLong(object, value);
                } else if (Float.TYPE.isAssignableFrom(type)) {
                    float value = conf.getFloat(key);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Injection of " + value + " into object " + object));
                    }
                    field.setAccessible(true);
                    field.setFloat(object, value);
                } else if (Double.TYPE.isAssignableFrom(type)) {
                    double value = conf.getDouble(key);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Injection of " + value + " into object " + object));
                    }
                    field.setAccessible(true);
                    field.setDouble(object, value);
                } else if (Byte.TYPE.isAssignableFrom(type)) {
                    byte value = conf.getByte(key);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Injection of " + value + " into object " + object));
                    }
                    field.setAccessible(true);
                    field.setByte(object, value);
                } else if (List.class.isAssignableFrom(type)) {
                    List values = conf.getList(key);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Injection of " + values + " into object " + object));
                    }
                    field.setAccessible(true);
                    field.set(object, values);
                }
            }
        }
        catch (IllegalArgumentException e) {
            throw new TurbineException("Could not inject configuration " + conf + " into object " + object, e);
        }
        catch (IllegalAccessException e) {
            throw new TurbineException("Could not inject configuration " + conf + " into object " + object, e);
        }
    }

    private static void injectTurbineService(Object object, ServiceManager manager, Field field, TurbineService annotation) throws TurbineException {
        String serviceName = null;
        if (StringUtils.isNotEmpty((String)annotation.value())) {
            serviceName = annotation.value();
        } else {
            Field[] typeFields;
            for (Field f : typeFields = field.getType().getFields()) {
                if ("SERVICE_NAME".equals(f.getName())) {
                    try {
                        serviceName = (String)f.get(null);
                        break;
                    }
                    catch (Exception e) {
                        continue;
                    }
                }
                if (!"ROLE".equals(f.getName())) continue;
                try {
                    serviceName = (String)f.get(null);
                    break;
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }
        if (StringUtils.isEmpty((String)serviceName)) {
            serviceName = field.getType().getName();
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Looking up service for injection: " + serviceName + " for object " + object));
        }
        Object service = manager.getService(serviceName);
        field.setAccessible(true);
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Injection of " + serviceName + " into object " + object));
            }
            field.set(object, service);
        }
        catch (IllegalArgumentException e) {
            throw new TurbineException("Could not inject service " + serviceName + " into object " + object, e);
        }
        catch (IllegalAccessException e) {
            throw new TurbineException("Could not inject service " + serviceName + " into object " + object, e);
        }
    }
}

