/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.services.assemblerbroker.util.java;

import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.turbine.modules.Assembler;
import org.apache.turbine.modules.GenericLoader;
import org.apache.turbine.modules.Loader;
import org.apache.turbine.services.assemblerbroker.util.AssemblerFactory;

public abstract class JavaBaseFactory<T extends Assembler>
implements AssemblerFactory<T> {
    private static List<String> packages = GenericLoader.getPackages();
    protected Log log = LogFactory.getLog(this.getClass());
    private final ConcurrentHashMap<String, Class<T>> classCache = new ConcurrentHashMap();

    public T getAssembler(String packageName, String name) {
        Assembler assembler = null;
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Class Fragment is " + name));
        }
        if (StringUtils.isNotEmpty((String)name)) {
            for (String p : packages) {
                StringBuilder sb = new StringBuilder();
                sb.append(p).append('.').append(packageName).append('.').append(name);
                String className = sb.toString();
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("Trying " + className));
                }
                try {
                    Class<T> _servClass;
                    Class<Object> servClass = this.classCache.get(className);
                    if (servClass == null && (_servClass = this.classCache.putIfAbsent(className, servClass = Class.forName(className))) != null) {
                        servClass = _servClass;
                    }
                    assembler = (Assembler)servClass.newInstance();
                    break;
                }
                catch (ClassNotFoundException cnfe) {
                    this.log.debug((Object)(className + ": Not found"));
                }
                catch (NoClassDefFoundError ncdfe) {
                    this.log.debug((Object)(className + ": No Class Definition found"));
                }
                catch (ClassCastException cce) {
                    this.log.error((Object)("Could not load " + className), (Throwable)cce);
                    break;
                }
                catch (InstantiationException ine) {
                    this.log.error((Object)("Could not load " + className), (Throwable)ine);
                    break;
                }
                catch (IllegalAccessException ilae) {
                    this.log.error((Object)("Could not load " + className), (Throwable)ilae);
                    break;
                }
            }
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Returning: " + assembler));
        }
        return (T)assembler;
    }

    @Override
    public abstract Loader<T> getLoader();

    @Override
    public int getCacheSize() {
        return this.getLoader().getCacheSize();
    }
}

