/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.services.naming;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.turbine.Turbine;
import org.apache.turbine.services.InitializationException;
import org.apache.turbine.services.TurbineBaseService;
import org.apache.turbine.services.naming.NamingService;

public class TurbineNamingService
extends TurbineBaseService
implements NamingService {
    private static Log log = LogFactory.getLog(TurbineNamingService.class);
    private static Map<String, Properties> contextPropsList = null;
    private final Map<String, InitialContext> initialContexts = new HashMap<String, InitialContext>();

    @Override
    public void init() throws InitializationException {
        Configuration conf = Turbine.getConfiguration();
        try {
            contextPropsList = new HashMap<String, Properties>();
            Iterator contextKeys = conf.subset("context").getKeys();
            while (contextKeys.hasNext()) {
                String key = (String)contextKeys.next();
                int end = key.indexOf(".");
                if (end == -1) continue;
                String contextName = key.substring(0, end);
                Properties contextProps = null;
                contextProps = contextPropsList.containsKey(contextName) ? contextPropsList.get(contextName) : new Properties();
                contextProps.put(key.substring(end + 1), conf.getString(key));
                contextPropsList.put(contextName, contextProps);
            }
            for (Map.Entry<String, Properties> entry : contextPropsList.entrySet()) {
                String key = entry.getKey();
                Properties contextProps = entry.getValue();
                InitialContext context = new InitialContext(contextProps);
                this.initialContexts.put(key, context);
            }
            this.setInit(true);
        }
        catch (NamingException e) {
            log.error((Object)"Failed to initialize JDNI contexts!", (Throwable)e);
            throw new InitializationException("Failed to initialize JDNI contexts!");
        }
    }

    @Override
    public Context getContext(String contextName) {
        Properties contextProps = null;
        contextProps = contextPropsList.containsKey(contextName) ? contextPropsList.get(contextName) : new Properties();
        try {
            return new InitialContext(contextProps);
        }
        catch (Exception e) {
            return null;
        }
    }
}

