/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.services.pull.tools;

import org.apache.commons.configuration.Configuration;
import org.apache.turbine.Turbine;
import org.apache.turbine.pipeline.PipelineData;
import org.apache.turbine.services.pull.ApplicationTool;
import org.apache.turbine.util.RunData;
import org.apache.turbine.util.uri.DataURI;

public class ContentTool
implements ApplicationTool {
    public static final String CONTENT_TOOL_PREFIX = "tool.content";
    public static final String CONTENT_TOOL_ENCODING_KEY = "want.encoding";
    public static final boolean CONTENT_TOOL_ENCODING_DEFAULT = false;
    public static final String CONTENT_TOOL_RELATIVE_KEY = "want.relative";
    public static final boolean CONTENT_TOOL_RELATIVE_DEFAULT = false;
    boolean wantEncoding = false;
    boolean wantRelative = false;
    private DataURI dataURI = null;

    @Override
    public void init(Object data) {
        if (data instanceof PipelineData) {
            PipelineData pipelineData = (PipelineData)data;
            RunData runData = (RunData)pipelineData;
            this.dataURI = new DataURI(runData);
        } else {
            this.dataURI = new DataURI((RunData)data);
        }
        Configuration conf = Turbine.getConfiguration().subset(CONTENT_TOOL_PREFIX);
        if (conf != null) {
            this.wantRelative = conf.getBoolean(CONTENT_TOOL_RELATIVE_KEY, false);
            this.wantEncoding = conf.getBoolean(CONTENT_TOOL_ENCODING_KEY, false);
        }
        if (!this.wantEncoding) {
            this.dataURI.clearResponse();
        }
    }

    @Override
    public void refresh() {
    }

    public String getURI(String path) {
        this.dataURI.setScriptName(path);
        return this.wantRelative ? this.dataURI.getRelativeLink() : this.dataURI.getAbsoluteLink();
    }

    public String getAbsoluteURI(String path) {
        this.dataURI.setScriptName(path);
        return this.dataURI.getAbsoluteLink();
    }

    public String getRelativeURI(String path) {
        this.dataURI.setScriptName(path);
        return this.dataURI.getRelativeLink();
    }
}

