/*
 * Decompiled with CFR 0.152.
 */
package net.sf.uadetector.internal.data.domain;

import java.io.Serializable;
import java.util.Collections;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import net.sf.qualitycheck.Check;
import net.sf.uadetector.UserAgent;
import net.sf.uadetector.UserAgentFamily;
import net.sf.uadetector.internal.data.domain.BrowserPattern;
import net.sf.uadetector.internal.data.domain.BrowserType;
import net.sf.uadetector.internal.data.domain.Identifiable;
import net.sf.uadetector.internal.data.domain.OperatingSystem;

@Immutable
public final class Browser
implements Identifiable,
Serializable {
    private static final long serialVersionUID = 6741143419664475577L;
    @Nonnull
    private final UserAgentFamily family;
    @Nonnull
    private final String familyName;
    private final int hash;
    @Nonnull
    private final String icon;
    @Nonnegative
    private final int id;
    @Nonnull
    private final String infoUrl;
    @Nullable
    private final OperatingSystem operatingSystem;
    @Nonnull
    private final SortedSet<BrowserPattern> patterns;
    @Nonnull
    private final String producer;
    @Nonnull
    private final String producerUrl;
    @Nonnull
    private final BrowserType type;
    @Nonnull
    private final String url;

    private static int buildHashCode(@Nonnegative int id, @Nonnull UserAgentFamily family, @Nonnull String familyName, @Nonnull SortedSet<BrowserPattern> patterns, @Nonnull BrowserType type, @Nullable OperatingSystem operatingSystem, @Nonnull String icon, @Nonnull String infoUrl, @Nonnull String producer, @Nonnull String producerUrl, @Nonnull String url) {
        int prime = 31;
        int result = 1;
        result = 31 * result + id;
        result = 31 * result + family.hashCode();
        result = 31 * result + familyName.hashCode();
        result = 31 * result + patterns.hashCode();
        result = 31 * result + type.hashCode();
        result = 31 * result + (operatingSystem == null ? 0 : operatingSystem.hashCode());
        result = 31 * result + icon.hashCode();
        result = 31 * result + infoUrl.hashCode();
        result = 31 * result + producer.hashCode();
        result = 31 * result + producerUrl.hashCode();
        result = 31 * result + url.hashCode();
        return result;
    }

    public Browser(@Nonnegative int id, @Nonnull UserAgentFamily family, @Nonnull String familyName, @Nonnull SortedSet<BrowserPattern> patterns, @Nonnull BrowserType type, @Nonnull OperatingSystem operatingSystem, @Nonnull String icon, @Nonnull String infoUrl, @Nonnull String producer, @Nonnull String producerUrl, @Nonnull String url) {
        this.id = Check.notNegative((int)id, (String)"id");
        this.family = (UserAgentFamily)((Object)Check.notNull((Object)((Object)family), (String)"family"));
        this.familyName = (String)Check.notNull((Object)familyName, (String)"familyName");
        this.patterns = Collections.unmodifiableSortedSet(new TreeSet((SortedSet)Check.notNull(patterns, (String)"patterns")));
        this.type = (BrowserType)Check.notNull((Object)type, (String)"type");
        this.operatingSystem = operatingSystem;
        this.icon = (String)Check.notNull((Object)icon, (String)"icon");
        this.infoUrl = (String)Check.notNull((Object)infoUrl, (String)"infoUrl");
        this.producer = (String)Check.notNull((Object)producer, (String)"producer");
        this.producerUrl = (String)Check.notNull((Object)producerUrl, (String)"producerUrl");
        this.url = (String)Check.notNull((Object)url, (String)"url");
        this.hash = Browser.buildHashCode(id, family, familyName, patterns, type, operatingSystem, icon, infoUrl, producer, producerUrl, url);
    }

    public void copyTo(@Nonnull UserAgent.Builder builder) {
        builder.setFamily(this.family);
        builder.setIcon(this.icon);
        builder.setName(this.familyName);
        builder.setProducer(this.producer);
        builder.setProducerUrl(this.producerUrl);
        builder.setTypeName(this.type.getName());
        builder.setUrl(this.url);
        if (this.operatingSystem != null) {
            this.operatingSystem.copyTo(builder);
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Browser other = (Browser)obj;
        if (this.id != other.id) {
            return false;
        }
        if (!this.family.equals((Object)other.family)) {
            return false;
        }
        if (!this.familyName.equals(other.familyName)) {
            return false;
        }
        if (!this.patterns.equals(other.patterns)) {
            return false;
        }
        if (!this.type.equals(other.type)) {
            return false;
        }
        if (this.operatingSystem == null ? other.operatingSystem != null : !this.operatingSystem.equals(other.operatingSystem)) {
            return false;
        }
        if (!this.icon.equals(other.icon)) {
            return false;
        }
        if (!this.infoUrl.equals(other.infoUrl)) {
            return false;
        }
        if (!this.producer.equals(other.producer)) {
            return false;
        }
        if (!this.producerUrl.equals(other.producerUrl)) {
            return false;
        }
        return this.url.equals(other.url);
    }

    @Nonnull
    public UserAgentFamily getFamily() {
        return this.family;
    }

    @Nonnull
    public String getFamilyName() {
        return this.familyName;
    }

    @Nonnull
    public String getIcon() {
        return this.icon;
    }

    @Override
    @Nonnegative
    public int getId() {
        return this.id;
    }

    @Nonnull
    public String getInfoUrl() {
        return this.infoUrl;
    }

    @Nullable
    public OperatingSystem getOperatingSystem() {
        return this.operatingSystem;
    }

    @Nonnull
    public SortedSet<BrowserPattern> getPatterns() {
        return this.patterns;
    }

    @Nonnull
    public String getProducer() {
        return this.producer;
    }

    @Nonnull
    public String getProducerUrl() {
        return this.producerUrl;
    }

    @Nonnull
    public BrowserType getType() {
        return this.type;
    }

    @Nonnull
    public String getUrl() {
        return this.url;
    }

    public int hashCode() {
        return this.hash;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Browser [id=");
        builder.append(this.id);
        builder.append(", family=");
        builder.append((Object)this.family);
        builder.append(", familyName=");
        builder.append(this.familyName);
        builder.append(", patterns=");
        builder.append(this.patterns);
        builder.append(", type=");
        builder.append(this.type);
        builder.append(", operatingSystem=");
        builder.append(this.operatingSystem);
        builder.append(", icon=");
        builder.append(this.icon);
        builder.append(", infoUrl=");
        builder.append(this.infoUrl);
        builder.append(", producer=");
        builder.append(this.producer);
        builder.append(", producerUrl=");
        builder.append(this.producerUrl);
        builder.append(", url=");
        builder.append(this.url);
        builder.append("]");
        return builder.toString();
    }

    @NotThreadSafe
    public static final class Builder {
        private static final String EMPTY = "";
        @Nonnull
        private UserAgentFamily family = UserAgentFamily.UNKNOWN;
        @Nonnull
        private String familyName = "";
        @Nonnull
        private String icon = "";
        private int id = Integer.MIN_VALUE;
        @Nonnull
        private String infoUrl = "";
        @Nullable
        private OperatingSystem operatingSystem;
        @Nonnull
        private SortedSet<BrowserPattern> patterns = new TreeSet<BrowserPattern>();
        @Nonnull
        private String producer = "";
        @Nonnull
        private String producerUrl = "";
        @Nullable
        private BrowserType type;
        private transient int typeId = Integer.MIN_VALUE;
        @Nonnull
        private String url = "";

        public Builder() {
        }

        public Builder(@Nonnull Browser browser) {
            Check.notNull((Object)browser, (String)"browser");
            this.id = Check.notNegative((int)browser.getId(), (String)"browser.getId()");
            this.family = (UserAgentFamily)((Object)Check.notNull((Object)((Object)browser.getFamily()), (String)"browser.getFamily()"));
            this.familyName = (String)Check.notNull((Object)browser.getFamilyName(), (String)"browser.getFamilyName()");
            this.patterns = new TreeSet<BrowserPattern>((SortedSet)Check.notNull(browser.getPatterns(), (String)"browser.getPatterns()"));
            this.type = (BrowserType)Check.notNull((Object)browser.getType(), (String)"browser.getType()");
            this.operatingSystem = (OperatingSystem)Check.notNull((Object)browser.getOperatingSystem(), (String)"browser.getOperatingSystem()");
            this.icon = (String)Check.notNull((Object)browser.getIcon(), (String)"browser.getIcon()");
            this.infoUrl = (String)Check.notNull((Object)browser.getInfoUrl(), (String)"browser.getInfoUrl()");
            this.producer = (String)Check.notNull((Object)browser.getProducer(), (String)"browser.getProducer()");
            this.producerUrl = (String)Check.notNull((Object)browser.getProducerUrl(), (String)"browser.getProducerUrl()");
            this.url = (String)Check.notNull((Object)browser.getUrl(), (String)"browser.getUrl()");
        }

        protected Builder(@Nonnull Builder builder) {
            Check.notNull((Object)builder, (String)"builder");
            this.family = builder.family;
            this.familyName = builder.familyName;
            this.icon = builder.icon;
            this.id = builder.id;
            this.infoUrl = builder.infoUrl;
            this.operatingSystem = builder.operatingSystem;
            this.patterns = builder.patterns;
            this.producer = builder.producer;
            this.producerUrl = builder.producerUrl;
            this.type = builder.type;
            this.typeId = builder.typeId;
            this.url = builder.url;
        }

        @Nonnull
        public Browser build() {
            return new Browser(this.id, this.family, this.familyName, this.patterns, this.type, this.operatingSystem, this.icon, this.infoUrl, this.producer, this.producerUrl, this.url);
        }

        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Nonnull
        public UserAgentFamily getFamily() {
            return this.family;
        }

        @Nonnull
        public String getFamilyName() {
            return this.familyName;
        }

        @Nonnull
        public String getIcon() {
            return this.icon;
        }

        public int getId() {
            return this.id;
        }

        @Nonnull
        public String getInfoUrl() {
            return this.infoUrl;
        }

        @Nullable
        public OperatingSystem getOperatingSystem() {
            return this.operatingSystem;
        }

        @Nonnull
        public SortedSet<BrowserPattern> getPatterns() {
            return this.patterns;
        }

        @Nonnull
        public String getProducer() {
            return this.producer;
        }

        @Nonnull
        public String getProducerUrl() {
            return this.producerUrl;
        }

        @Nullable
        public BrowserType getType() {
            return this.type;
        }

        public int getTypeId() {
            return this.typeId;
        }

        @Nonnull
        public String getUrl() {
            return this.url;
        }

        @Nonnull
        private Builder setFamily(@Nonnull UserAgentFamily family) {
            this.family = (UserAgentFamily)((Object)Check.notNull((Object)((Object)family), (String)"family"));
            return this;
        }

        @Nonnull
        public Builder setFamilyName(@Nonnull String familyName) {
            this.familyName = (String)Check.notNull((Object)familyName, (String)"familyName");
            return this.setFamily(UserAgentFamily.evaluate(familyName));
        }

        @Nonnull
        public Builder setIcon(@Nonnull String icon) {
            this.icon = (String)Check.notNull((Object)icon, (String)"icon");
            return this;
        }

        @Nonnull
        public Builder setId(@Nonnegative int id) {
            this.id = Check.notNegative((int)id, (String)"id");
            return this;
        }

        @Nonnull
        public Builder setId(@Nonnull String id) {
            this.setId(Integer.parseInt((String)Check.notEmpty((CharSequence)id, (String)"id")));
            return this;
        }

        @Nonnull
        public Builder setInfoUrl(@Nonnull String infoUrl) {
            this.infoUrl = (String)Check.notNull((Object)infoUrl, (String)"infoUrl");
            return this;
        }

        @Nonnull
        public Builder setOperatingSystem(@Nonnull OperatingSystem operatingSystem) {
            this.operatingSystem = (OperatingSystem)Check.notNull((Object)operatingSystem, (String)"operatingSystem");
            return this;
        }

        @Nonnull
        public Builder setPatterns(@Nonnull SortedSet<BrowserPattern> patterns) {
            this.patterns = new TreeSet<BrowserPattern>((SortedSet)Check.notNull(patterns, (String)"patterns"));
            return this;
        }

        @Nonnull
        public Builder setProducer(@Nonnull String producer) {
            this.producer = (String)Check.notNull((Object)producer, (String)"producer");
            return this;
        }

        @Nonnull
        public Builder setProducerUrl(@Nonnull String producerUrl) {
            this.producerUrl = (String)Check.notNull((Object)producerUrl, (String)"producerUrl");
            return this;
        }

        @Nonnull
        public Builder setType(@Nonnull BrowserType type) {
            this.type = (BrowserType)Check.notNull((Object)type, (String)"type");
            this.setTypeId(type.getId());
            return this;
        }

        @Nonnull
        public Builder setTypeId(@Nonnegative int typeId) {
            this.typeId = Check.notNegative((int)typeId, (String)"typeId");
            return this;
        }

        @Nonnull
        public Builder setTypeId(@Nonnull String typeId) {
            this.setTypeId(Integer.parseInt((String)Check.notEmpty((CharSequence)typeId, (String)"typeId")));
            return this;
        }

        @Nonnull
        public Builder setUrl(@Nonnull String url) {
            this.url = (String)Check.notNull((Object)url, (String)"url");
            return this;
        }
    }
}

