/*
 * Decompiled with CFR 0.152.
 */
package net.sf.uadetector.internal.data.domain;

import java.io.Serializable;
import java.util.regex.Pattern;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import net.sf.qualitycheck.Check;
import net.sf.uadetector.internal.data.domain.Identifiable;
import net.sf.uadetector.internal.data.domain.OrderedPattern;
import net.sf.uadetector.internal.util.RegularExpressionConverter;

@Immutable
public final class DevicePattern
implements Identifiable,
OrderedPattern<DevicePattern>,
Serializable {
    private static final long serialVersionUID = 2845531314485836348L;
    @Nonnegative
    private final int id;
    @Nonnull
    private final Pattern pattern;
    @Nonnegative
    private final int position;

    private static int compareInt(int a, int b) {
        int result = 0;
        if (a > b) {
            result = 1;
        } else if (a < b) {
            result = -1;
        }
        return result;
    }

    public DevicePattern(@Nonnegative int id, @Nonnull Pattern pattern, @Nonnegative int position) {
        Check.notNegative((int)id, (String)"id");
        Check.notNull((Object)pattern, (String)"pattern");
        Check.notNegative((int)position, (String)"position");
        this.id = id;
        this.pattern = pattern;
        this.position = position;
    }

    @Override
    public int compareTo(DevicePattern other) {
        int result;
        int n = result = other == null ? -1 : 0;
        if (result == 0) {
            result = DevicePattern.compareInt(this.getPosition(), other.getPosition());
            if (result == 0) {
                result = DevicePattern.compareInt(this.getId(), other.getId());
            }
            if (result == 0) {
                result = this.getPattern().pattern().compareTo(other.getPattern().pattern());
            }
            if (result == 0) {
                result = DevicePattern.compareInt(this.getPattern().flags(), other.getPattern().flags());
            }
        }
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DevicePattern other = (DevicePattern)obj;
        if (this.id != other.id) {
            return false;
        }
        if (this.position != other.position) {
            return false;
        }
        if (!this.pattern.pattern().equals(other.pattern.pattern())) {
            return false;
        }
        return this.pattern.flags() == other.pattern.flags();
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    public Pattern getPattern() {
        return this.pattern;
    }

    @Override
    public int getPosition() {
        return this.position;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.id;
        result = 31 * result + this.position;
        result = 31 * result + this.pattern.pattern().hashCode();
        result = 31 * result + this.pattern.flags();
        return result;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("DevicePattern [id=");
        builder.append(this.id);
        builder.append(", pattern=");
        builder.append(this.pattern);
        builder.append(", position=");
        builder.append(this.position);
        builder.append("]");
        return builder.toString();
    }

    @NotThreadSafe
    public static final class Builder {
        private int id = Integer.MIN_VALUE;
        private Pattern pattern;
        private int position = Integer.MIN_VALUE;

        @Nonnull
        public DevicePattern build() {
            return new DevicePattern(this.id, this.pattern, this.position);
        }

        @Nonnull
        public Builder setId(@Nonnegative int id) {
            Check.notNegative((int)id, (String)"id");
            this.id = id;
            return this;
        }

        @Nonnull
        public Builder setId(@Nonnull String id) {
            Check.notEmpty((CharSequence)id, (String)"id");
            this.setId(Integer.parseInt(id.trim()));
            return this;
        }

        @Nonnull
        public Builder setPattern(@Nonnull Pattern pattern) {
            Check.notNull((Object)pattern, (String)"pattern");
            this.pattern = pattern;
            return this;
        }

        @Nonnull
        public Builder setPerlRegularExpression(@Nonnull String regex) {
            Check.notEmpty((CharSequence)regex, (String)"regex");
            this.setPattern(RegularExpressionConverter.convertPerlRegexToPattern(regex));
            return this;
        }

        @Nonnull
        public Builder setPosition(@Nonnegative int position) {
            Check.notNegative((int)position, (String)"position");
            this.position = position;
            return this;
        }

        @Nonnull
        public Builder setPosition(@Nonnull String position) {
            Check.notEmpty((CharSequence)position, (String)"position");
            this.setPosition(Integer.parseInt(position.trim()));
            return this;
        }
    }
}

