/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jcs.auxiliary.disk.jdbc.mysql.util;

import java.util.Calendar;
import java.util.Date;
import java.util.StringTokenizer;
import org.apache.jcs.auxiliary.disk.jdbc.mysql.util.ScheduleFormatException;

public class ScheduleParser {
    public static Date[] createDatesForSchedule(String schedule) throws ScheduleFormatException {
        if (schedule == null) {
            throw new ScheduleFormatException("Cannot create schedules for a null String.");
        }
        StringTokenizer toker = new StringTokenizer(schedule, ",");
        Date[] dates = new Date[toker.countTokens()];
        int cnt = 0;
        while (toker.hasMoreTokens()) {
            String time = toker.nextToken();
            dates[cnt] = ScheduleParser.getDateForSchedule(time);
            ++cnt;
        }
        return dates;
    }

    public static Date getDateForSchedule(String startTime) throws ScheduleFormatException {
        if (startTime == null) {
            throw new ScheduleFormatException("Cannot create date for a null String.");
        }
        int firstColon = startTime.indexOf(":");
        int lastColon = startTime.lastIndexOf(":");
        int len = startTime.length();
        if (firstColon == -1 || lastColon == -1 || firstColon == lastColon || lastColon == len) {
            String message = "StartTime [" + startTime + "] is deformed.  Unable to schedule optimizaiton.";
            throw new ScheduleFormatException(message);
        }
        Calendar cal = Calendar.getInstance();
        try {
            int hour = Integer.parseInt(startTime.substring(0, firstColon));
            cal.set(11, hour);
            int minute = Integer.parseInt(startTime.substring(firstColon + 1, lastColon));
            cal.set(12, minute);
            int second = Integer.parseInt(startTime.substring(lastColon + 1, len));
            cal.set(13, second);
        }
        catch (NumberFormatException e) {
            String message = "Problem parsing start time [" + startTime + "].  It should be in HH:MM:SS format.";
            throw new ScheduleFormatException(message);
        }
        Date now = new Date();
        if (cal.getTime().before(now)) {
            cal.add(5, 1);
        }
        return cal.getTime();
    }
}

