package org.apache.turbine.services.schedule;

import java.io.Serializable;
import java.sql.Connection;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;

import org.apache.torque.TorqueException;
import org.apache.torque.map.TableMap;
import org.apache.torque.om.ComboKey;
import org.apache.torque.om.DateKey;
import org.apache.torque.om.NumberKey;
import org.apache.torque.om.ObjectKey;
import org.apache.torque.om.SimpleKey;
import org.apache.torque.om.StringKey;
import org.apache.torque.om.BooleanKey;
import org.apache.torque.om.Persistent;
import org.apache.torque.criteria.Criteria;
import org.apache.torque.util.Transaction;
import org.apache.commons.lang.ObjectUtils;


/**
 * This class was autogenerated by Torque on:
 *
 * [Tue May 28 10:27:12 CEST 2019]
 *
 * You should not use this class directly.  It should not even be
 * extended; all references should be to JobEntryTorque
 */
public abstract class BaseJobEntryTorque extends org.apache.turbine.services.schedule.AbstractJobEntry
    implements Persistent, Serializable
{
    /** Serial version */
    private static final long serialVersionUID = 1559032032927L;



    /** Defines the jobId field. */
    private int jobId = 0;

    /** Defines the second field. */
    private int second = -1;

    /** Defines the minute field. */
    private int minute = -1;

    /** Defines the hour field. */
    private int hour = -1;

    /** Defines the weekDay field. */
    private int weekDay = -1;

    /** Defines the dayOfMonth field. */
    private int dayOfMonth = -1;

    /** Defines the task field. */
    private String task = null;

    /** Defines the email field. */
    private String email = null;

    /** Defines the property field. */
    private byte[] property = null;

    /** Whether this object was modified after loading or after last save. */
    private boolean modified = true;

    /** 
     * Whether this object was loaded from the database or already saved 
     * (false) or whether it is not yet in the database(true).
     */
    private boolean isNew = true;

    /** Flag which indicates whether this object is currently saving. */
    private boolean saving = false;

    /** 
     * Flag which indicates whether this object is currently loaded
     * from the database. 
     */
    private boolean loading = false;

    /** 
     * Flag which indicates whether this object was deleted from the database.
     * Note that this flags does not always display the current database state,
     * there is no magical connection between this flag and the database.
     */
    private boolean deleted = false;





    /**
     * Get the value of jobId.
     *
     * @return int
     */
    public int getJobId() 
    {
        
        return jobId;
    }

    /**
     * Set the value of jobId.
     *
     * @param v new value
     */
    public void setJobId(int v)
    {
        if (this.jobId != v)
        {
            setModified(true);
        }

        this.jobId = v;


    }
    
    /**
     * Get the value of second.
     *
     * @return int
     */
    public int getSecond() 
    {
        
        return second;
    }

    /**
     * Set the value of second.
     *
     * @param v new value
     */
    public void setSecond(int v)
    {
        if (this.second != v)
        {
            setModified(true);
        }

        this.second = v;


    }
    
    /**
     * Get the value of minute.
     *
     * @return int
     */
    public int getMinute() 
    {
        
        return minute;
    }

    /**
     * Set the value of minute.
     *
     * @param v new value
     */
    public void setMinute(int v)
    {
        if (this.minute != v)
        {
            setModified(true);
        }

        this.minute = v;


    }
    
    /**
     * Get the value of hour.
     *
     * @return int
     */
    public int getHour() 
    {
        
        return hour;
    }

    /**
     * Set the value of hour.
     *
     * @param v new value
     */
    public void setHour(int v)
    {
        if (this.hour != v)
        {
            setModified(true);
        }

        this.hour = v;


    }
    
    /**
     * Get the value of weekDay.
     *
     * @return int
     */
    public int getWeekDay() 
    {
        
        return weekDay;
    }

    /**
     * Set the value of weekDay.
     *
     * @param v new value
     */
    public void setWeekDay(int v)
    {
        if (this.weekDay != v)
        {
            setModified(true);
        }

        this.weekDay = v;


    }
    
    /**
     * Get the value of dayOfMonth.
     *
     * @return int
     */
    public int getDayOfMonth() 
    {
        
        return dayOfMonth;
    }

    /**
     * Set the value of dayOfMonth.
     *
     * @param v new value
     */
    public void setDayOfMonth(int v)
    {
        if (this.dayOfMonth != v)
        {
            setModified(true);
        }

        this.dayOfMonth = v;


    }
    
    /**
     * Get the value of task.
     *
     * @return String
     */
    public String getTask() 
    {
        
        return task;
    }

    /**
     * Set the value of task.
     *
     * @param v new value
     */
    public void setTask(String v)
    {
        if (!ObjectUtils.equals(this.task, v))
        {
            setModified(true);
        }

        this.task = v;


    }
    
    /**
     * Get the value of email.
     *
     * @return String
     */
    public String getEmail() 
    {
        
        return email;
    }

    /**
     * Set the value of email.
     *
     * @param v new value
     */
    public void setEmail(String v)
    {
        if (!ObjectUtils.equals(this.email, v))
        {
            setModified(true);
        }

        this.email = v;


    }
    
    /**
     * Get the value of property.
     *
     * @return byte[]
     */
    public byte[] getProperty() 
    {
        
        return property;
    }

    /**
     * Set the value of property.
     *
     * @param v new value
     */
    public void setProperty(byte[] v)
    {
        if (!ObjectUtils.equals(this.property, v))
        {
            setModified(true);
        }

        this.property = v;


    }
    

    /**
     * Returns whether the object has ever been saved.  This will
     * be false, if the object was retrieved from storage or was created
     * and then saved.
     *
     * @return true, if the object has never been persisted.
     */
    public boolean isNew()
    {
        return isNew;
    }

    /**
     * Sets whether the object has ever been saved.
     *
     * @param isNew true if the object has never been saved, false otherwise.
     */
    public void setNew(boolean isNew)
    {
        this.isNew = isNew;
    }

    /**
     * Returns whether the object has been modified.
     *
     * @return True if the object has been modified.
     */
    public boolean isModified()
    {
        return modified;
    }

    /**
     * Sets whether the object has been modified.
     *
     * @param modified true if the object has been modified, false otherwise.
     */
    public void setModified(boolean modified)
    {
        this.modified = modified;
    }

    /**
     * Sets the modified state for the object to be false.
     */
    public void resetModified()
    {
        modified = false;
    }


    /**
     * Returns whether this object is currently saving.
     *
     * @return true if this object is currently saving, false otherwise.
     */
    public boolean isSaving()
    {
        return saving;
    }

    /**
     * Sets whether this object is currently saving.
     *
     * @param saving true if this object is currently saving, false otherwise.
     */
    public void setSaving(boolean saving)
    {
        this.saving = saving;
    }


    /**
     * Returns whether this object is currently being loaded from the database.
     *
     * @return true if this object is currently loading, false otherwise.
     */
    public boolean isLoading()
    {
        return loading;
    }

    /**
     * Sets whether this object is currently being loaded from the database.
     *
     * @param loading true if this object is currently loading, false otherwise.
     */
    public void setLoading(boolean loading)
    {
        this.loading = loading;
    }


    /**
     * Returns whether this object was deleted from the database.
     * Note that this getter does not automatically reflect database state,
     * it will be set to true by Torque if doDelete() was called with this 
     * object. Bulk deletes and deletes via primary key do not change
     * this flag. Also, if doDelete() was called on an object which does
     * not exist in the database, the deleted flag is set to true even if
     * it was not deleted.
     *
     * @return true if this object was deleted, false otherwise.
     */
    public boolean isDeleted()
    {
        return deleted;
    }

    /**
     * Sets whether this object was deleted from the database.
     *
     * @param deleted true if this object was deleted, false otherwise.
     */
    public void setDeleted(boolean deleted)
    {
        this.deleted = deleted;
    }








    /**
     * Stores an object in the database.  If the object is new,
     * it is inserted; otherwise an update is performed.
     *
     * @param toSave the object to be saved, not null.
     *
     * @throws TorqueException if an error occurs during saving.
     */
    public void save() throws TorqueException
    {
        save(JobEntryTorquePeer.DATABASE_NAME);
    }

    /**
     * Stores an object in the database.  If the object is new,
     * it is inserted; otherwise an update is performed.
     *
     * @param toSave the object to be saved, not null.
     * @param dbName the name of the database to which the object
     *        should be saved.
     *
     * @throws TorqueException if an error occurs during saving.
     */
    public void save(String dbName) 
            throws TorqueException
    {
        Connection con = null;
        try
        {
            con = Transaction.begin(dbName);
            save(con);
            Transaction.commit(con);
        }
        catch(TorqueException e)
        {
            Transaction.safeRollback(con);
            throw e;
        }
    }

    /**
     * Stores an object in the database.  If the object is new,
     * it is inserted; otherwise an update is performed.  This method
     * is meant to be used as part of a transaction, otherwise use
     * the save() method and the connection details will be handled
     * internally.
     *
     * @param toSave the object to be saved, not null.
     * @param con the connection to use for saving the object, not null.
     *
     * @throws TorqueException if an error occurs during saving.
     */
    public void save(Connection con) 
            throws TorqueException
    {
        if (isSaving())
        {
            return;
        }
        try
        {
            setSaving(true);
            // If this object has been modified, then save it to the database.
            if (isModified())
            {
                if (isNew())
                {
                    JobEntryTorquePeer.doInsert((JobEntryTorque) this, con);
                    setNew(false);
                }
                else
                {
                    JobEntryTorquePeer.doUpdate((JobEntryTorque) this, con);
                }
            }

        }
        finally
        {
            setSaving(false);
        }
    }




    /**
     * Set the PrimaryKey using ObjectKey.
     *
     * @param key jobId ObjectKey
     */
    public void setPrimaryKey(ObjectKey key)
        
    {
        setJobId(((NumberKey) key).intValue());
    }

    /**
     * Set the PrimaryKey using a String.
     *
     * @param key
     */
    public void setPrimaryKey(String key) 
    {
        setJobId(Integer.parseInt(key));
    }


    /**
     * returns an id that differentiates this object from others
     * of its class.
     */
    public ObjectKey getPrimaryKey()
    {
        return SimpleKey.keyFor(getJobId());
    }



    /**
     * Makes a copy of this object.
     * It creates a new object filling in the simple attributes.
     * It then fills all the association collections and sets the
     * related objects to isNew=true.
     */
    public JobEntryTorque copy() throws TorqueException
    {
        return copy(true);
    }

    /**
     * Makes a copy of this object using a connection.
     * It creates a new object filling in the simple attributes.
     * It then fills all the association collections and sets the
     * related objects to isNew=true.
     *
     * @param con the database connection to read associated objects.
     */
    public JobEntryTorque copy(Connection con) throws TorqueException
    {
        return copy(true, con);
    }

    /**
     * Makes a copy of this object.
     * It creates a new object filling in the simple attributes.
     * If the parameter deepcopy is true, it then fills all the
     * association collections and sets the related objects to
     * isNew=true.
     *
     * @param deepcopy whether to copy the associated objects.
     */
    public JobEntryTorque copy(boolean deepcopy) throws TorqueException
    {
        JobEntryTorque jobEntryTorque = new JobEntryTorque();

        return copyInto(jobEntryTorque, deepcopy);
    }

    /**
     * Makes a copy of this object using connection.
     * It creates a new object filling in the simple attributes.
     * If the parameter deepcopy is true, it then fills all the
     * association collections and sets the related objects to
     * isNew=true.
     *
     * @param deepcopy whether to copy the associated objects.
     * @param con the database connection to read associated objects.
     */
    public JobEntryTorque copy(boolean deepcopy, Connection con) throws TorqueException
    {
        JobEntryTorque jobEntryTorque = new JobEntryTorque();

        return copyInto(jobEntryTorque, deepcopy, con);
    }
  
    /**
     * Fills the copyObj with the contents of this object.
     * The associated objects are also copied and treated as new objects.
     *
     * @param copyObj the object to fill.
     */
    public JobEntryTorque copyInto(JobEntryTorque copyObj) throws TorqueException
    {
        return copyInto(copyObj, true);
    }

    /**
     * Fills the copyObj with the contents of this object using connection.
     * The associated objects are also copied and treated as new objects.
     *
     * @param copyObj the object to fill.
     * @param con the database connection to read associated objects.
     */
    public JobEntryTorque copyInto(JobEntryTorque copyObj, Connection con) throws TorqueException
    {
        return copyInto(copyObj, true, con);
    }
  
    /**
     * Fills the copyObj with the contents of this object.
     * If deepcopy is true, The associated objects are also copied
     * and treated as new objects.
     *
     * @param copyObj the object to fill.
     * @param deepcopy whether the associated objects should be copied.
     */
    protected JobEntryTorque copyInto(JobEntryTorque copyObj, boolean deepcopy) throws TorqueException
    {
        copyObj.setJobId(0);
        copyObj.setSecond(second);
        copyObj.setMinute(minute);
        copyObj.setHour(hour);
        copyObj.setWeekDay(weekDay);
        copyObj.setDayOfMonth(dayOfMonth);
        copyObj.setTask(task);
        copyObj.setEmail(email);
        copyObj.setProperty(property);

        if (deepcopy)
        {
        }
        return copyObj;
    }
        
    
    /**
     * Fills the copyObj with the contents of this object using connection.
     * If deepcopy is true, The associated objects are also copied
     * and treated as new objects.
     *
     * @param copyObj the object to fill.
     * @param deepcopy whether the associated objects should be copied.
     * @param con the database connection to read associated objects.
     */
    public JobEntryTorque copyInto(JobEntryTorque copyObj, boolean deepcopy, Connection con) throws TorqueException
    {
        copyObj.setJobId(0);
        copyObj.setSecond(second);
        copyObj.setMinute(minute);
        copyObj.setHour(hour);
        copyObj.setWeekDay(weekDay);
        copyObj.setDayOfMonth(dayOfMonth);
        copyObj.setTask(task);
        copyObj.setEmail(email);
        copyObj.setProperty(property);

        if (deepcopy)
        {
        }
        return copyObj;
    }

    /** The Peer class */
    private static final org.apache.turbine.services.schedule.JobEntryTorquePeer peer
            = new org.apache.turbine.services.schedule.JobEntryTorquePeer();

    /**
     * returns a peer instance associated with this om.  Since Peer classes
     * are not to have any instance attributes, this method returns the
     * same instance for all member of this class. The method could therefore
     * be static, but this would prevent one from overriding the behavior.
     */
    public org.apache.turbine.services.schedule.JobEntryTorquePeer getPeer()
    {
        return peer;
    }

    /**
     * Retrieves the TableMap object related to this Table data without
     * compiler warnings of using getPeer().getTableMap().
     *
     * @return The associated TableMap object.
     */
    public TableMap getTableMap() throws TorqueException
    {
        return org.apache.turbine.services.schedule.JobEntryTorquePeer.getTableMap();
    }



    public String toString()
    {
        StringBuffer str = new StringBuffer();
        str.append("JobEntryTorque:\n");
        str.append("jobId = ")
           .append(getJobId())
           .append("\n");
        str.append("second = ")
           .append(getSecond())
           .append("\n");
        str.append("minute = ")
           .append(getMinute())
           .append("\n");
        str.append("hour = ")
           .append(getHour())
           .append("\n");
        str.append("weekDay = ")
           .append(getWeekDay())
           .append("\n");
        str.append("dayOfMonth = ")
           .append(getDayOfMonth())
           .append("\n");
        str.append("task = ")
           .append(getTask())
           .append("\n");
        str.append("email = ")
           .append(getEmail())
           .append("\n");
        str.append("property = ")
           .append("<binary>")
           .append("\n");
        return(str.toString());
    }

    /**
     * Compares the primary key of this instance with the key of another.
     *
     * @param toCompare The object to compare to.
     * @return Whether the primary keys are equal and the object have the
     *         same class.
     */
    public boolean equals(Object toCompare)
    {
        if (toCompare == null)
        {
            return false;
        }
        if (this == toCompare)
        {
            return true;
        }
        if (!getClass().equals(toCompare.getClass()))
        {
            return false;
        }
        JobEntryTorque other = (JobEntryTorque) toCompare;
        if (getPrimaryKey() == null || other.getPrimaryKey() == null)
        {
            return false;
        }
        return getPrimaryKey().equals(other.getPrimaryKey());
    }

    /**
     * If the primary key is not <code>null</code>, return the hashcode of the
     * primary key.  Otherwise calls <code>Object.hashCode()</code>.
     *
     * @return an <code>int</code> value
     */
    public int hashCode()
    {
        ObjectKey ok = getPrimaryKey();
        if (ok == null)
        {
            return super.hashCode();
        }

        return ok.hashCode();
    }



    /**
     * Compares the content of this object to another object
     *
     * @param toCompare The object to compare to.
     * @return true if all of the columns in the other object have 
     *         the same value as the objects in this class.
     */
    public boolean valueEquals(JobEntryTorque toCompare)
    {
        if (toCompare == null)
        {
            return false;
        }
        if (this == toCompare)
        {
            return true;
        }
        if (this.jobId != toCompare.getJobId())
        {
            return false;
        }
        if (this.second != toCompare.getSecond())
        {
            return false;
        }
        if (this.minute != toCompare.getMinute())
        {
            return false;
        }
        if (this.hour != toCompare.getHour())
        {
            return false;
        }
        if (this.weekDay != toCompare.getWeekDay())
        {
            return false;
        }
        if (this.dayOfMonth != toCompare.getDayOfMonth())
        {
            return false;
        }
        if (!ObjectUtils.equals(this.task, toCompare.getTask()))
        {
            return false;
        }
        if (!ObjectUtils.equals(this.email, toCompare.getEmail()))
        {
            return false;
        }
        if (!ObjectUtils.equals(this.property, toCompare.getProperty()))
        {
            return false;
        }
        return true;
    }



}
