/*
 * Decompiled with CFR 0.152.
 */
package org.jabsorb.serializer.impl;

import org.jabsorb.JSONSerializer;
import org.jabsorb.serializer.AbstractSerializer;
import org.jabsorb.serializer.MarshallException;
import org.jabsorb.serializer.ObjectMatch;
import org.jabsorb.serializer.SerializerState;
import org.jabsorb.serializer.UnmarshallException;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class RawJSONArraySerializer
extends AbstractSerializer {
    private static final long serialVersionUID = 2L;
    private static Class[] _serializableClasses = new Class[]{JSONArray.class};
    private static Class[] _JSONClasses = new Class[]{JSONArray.class};

    public Class[] getJSONClasses() {
        return _JSONClasses;
    }

    public Class[] getSerializableClasses() {
        return _serializableClasses;
    }

    public Object marshall(SerializerState state, Object p, Object o) throws MarshallException {
        JSONArray jsonIn = (JSONArray)o;
        JSONArray jsonOut = new JSONArray();
        int i = 0;
        try {
            int j = jsonIn.length();
            for (i = 0; i < j; ++i) {
                Object json = this.ser.marshall(state, o, jsonIn.opt(i), new Integer(i));
                if (JSONSerializer.CIRC_REF_OR_DUPLICATE != json) {
                    jsonOut.put(i, json);
                    continue;
                }
                jsonOut.put(i, JSONObject.NULL);
            }
        }
        catch (MarshallException e) {
            throw new MarshallException("element " + i, e);
        }
        catch (JSONException e) {
            throw new MarshallException("element " + i, e);
        }
        return jsonOut;
    }

    public ObjectMatch tryUnmarshall(SerializerState state, Class clazz, Object jso) throws UnmarshallException {
        state.setSerialized(jso, ObjectMatch.OKAY);
        return ObjectMatch.OKAY;
    }

    public Object unmarshall(SerializerState state, Class clazz, Object jso) throws UnmarshallException {
        state.setSerialized(jso, jso);
        return jso;
    }
}

