/*
 * Decompiled with CFR 0.152.
 */
package org.jabsorb.serializer.impl;

import java.util.Iterator;
import org.jabsorb.JSONSerializer;
import org.jabsorb.serializer.AbstractSerializer;
import org.jabsorb.serializer.MarshallException;
import org.jabsorb.serializer.ObjectMatch;
import org.jabsorb.serializer.SerializerState;
import org.jabsorb.serializer.UnmarshallException;
import org.json.JSONException;
import org.json.JSONObject;

public class RawJSONObjectSerializer
extends AbstractSerializer {
    private static final long serialVersionUID = 2L;
    private static Class[] _serializableClasses = new Class[]{JSONObject.class};
    private static Class[] _JSONClasses = new Class[]{JSONObject.class};

    public Class[] getJSONClasses() {
        return _JSONClasses;
    }

    public Class[] getSerializableClasses() {
        return _serializableClasses;
    }

    public Object marshall(SerializerState state, Object p, Object o) throws MarshallException {
        JSONObject jsonIn = (JSONObject)o;
        JSONObject jsonOut = new JSONObject();
        String key = null;
        try {
            Iterator i = jsonIn.keys();
            while (i.hasNext()) {
                key = (String)i.next();
                Object j = this.ser.marshall(state, o, jsonIn.opt(key), key);
                if (JSONSerializer.CIRC_REF_OR_DUPLICATE == j) continue;
                jsonOut.put(key, j);
            }
        }
        catch (MarshallException e) {
            throw new MarshallException("JSONObject key " + key + " " + e.getMessage(), e);
        }
        catch (JSONException e) {
            throw new MarshallException("JSONObject key " + key + " " + e.getMessage(), e);
        }
        return jsonOut;
    }

    public ObjectMatch tryUnmarshall(SerializerState state, Class clazz, Object jso) throws UnmarshallException {
        state.setSerialized(jso, ObjectMatch.OKAY);
        return ObjectMatch.OKAY;
    }

    public Object unmarshall(SerializerState state, Class clazz, Object jso) throws UnmarshallException {
        state.setSerialized(jso, jso);
        return jso;
    }
}

