/*
 * Decompiled with CFR 0.152.
 */
package org.jabsorb.client;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.net.URL;
import java.net.URLConnection;
import org.jabsorb.client.ClientError;
import org.jabsorb.client.Session;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONTokener;

public class URLConnectionSession
implements Session {
    URL url;

    URLConnectionSession(URL url) {
        this.url = url;
    }

    public void close() {
    }

    public JSONObject sendAndReceive(JSONObject message) {
        try {
            int bytesRead;
            URLConnection connection = this.url.openConnection();
            connection.setDoOutput(true);
            OutputStreamWriter request = new OutputStreamWriter(connection.getOutputStream());
            request.write(message.toString());
            ((Writer)request).close();
            StringBuffer builder = new StringBuffer(1024);
            char[] buffer = new char[1024];
            InputStreamReader reader = new InputStreamReader(connection.getInputStream());
            while ((bytesRead = reader.read(buffer)) >= 0) {
                builder.append(buffer, 0, bytesRead);
            }
            ((Reader)reader).close();
            JSONTokener tokener = new JSONTokener(builder.toString());
            Object rawResponseMessage = tokener.nextValue();
            JSONObject responseMessage = (JSONObject)rawResponseMessage;
            if (responseMessage == null) {
                throw new ClientError("Invalid response type - " + rawResponseMessage.getClass());
            }
            return responseMessage;
        }
        catch (IOException ex) {
            throw new ClientError(ex);
        }
        catch (JSONException ex) {
            throw new ClientError(ex);
        }
    }
}

