/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.textruler.core;

import org.apache.uima.ruta.textruler.core.TextRulerBasicLearner;
import org.apache.uima.ruta.textruler.core.TextRulerRule;
import org.apache.uima.ruta.textruler.core.TextRulerRuleItem;
import org.apache.uima.ruta.textruler.core.TextRulerRulePattern;
import org.apache.uima.ruta.textruler.core.TextRulerSlotPattern;
import org.apache.uima.ruta.textruler.core.TextRulerTarget;
import org.apache.uima.ruta.textruler.core.TextRulerToolkit;

public class TextRulerSingleSlotRule
extends TextRulerRule {
    protected TextRulerSlotPattern slotPattern = new TextRulerSlotPattern();

    public TextRulerSingleSlotRule(TextRulerBasicLearner parentAlgorithm, TextRulerTarget target) {
        super(parentAlgorithm, target);
    }

    public TextRulerSingleSlotRule(TextRulerSingleSlotRule copyFrom) {
        super(copyFrom);
        this.slotPattern = copyFrom.slotPattern.copy();
    }

    public TextRulerRulePattern getPreFillerPattern() {
        return this.slotPattern.preFillerPattern;
    }

    public TextRulerRulePattern getFillerPattern() {
        return this.slotPattern.fillerPattern;
    }

    public TextRulerRulePattern getPostFillerPattern() {
        return this.slotPattern.postFillerPattern;
    }

    public String getMarkName() {
        return TextRulerToolkit.getTypeShortName(this.target.getSingleSlotTypeName());
    }

    @Override
    public void compileRuleString() {
        String ruleString = "";
        int preCount = this.slotPattern.preFillerPattern.size();
        int postCount = this.slotPattern.postFillerPattern.size();
        int fillerCount = this.slotPattern.fillerPattern.size();
        int totalSize = preCount + postCount + fillerCount;
        int index = 0;
        int totalIndex = 0;
        for (TextRulerRuleItem item : this.slotPattern.preFillerPattern) {
            ruleString = ruleString + item.getStringForRuleString(this, TextRulerRuleItem.MLRuleItemType.PREFILLER, index, preCount, totalIndex, totalSize, 0) + " ";
            ++index;
            ++totalIndex;
        }
        index = 0;
        for (TextRulerRuleItem item : this.slotPattern.fillerPattern) {
            ruleString = ruleString + item.getStringForRuleString(this, TextRulerRuleItem.MLRuleItemType.FILLER, index, fillerCount, totalIndex, totalSize, 0) + " ";
            ++index;
            ++totalIndex;
        }
        index = 0;
        for (TextRulerRuleItem item : this.slotPattern.postFillerPattern) {
            ruleString = ruleString + item.getStringForRuleString(this, TextRulerRuleItem.MLRuleItemType.POSTFILLER, index, postCount, totalIndex, totalSize, 0) + " ";
            ++index;
            ++totalIndex;
        }
        ruleString = ruleString.trim();
        this.ruleString = ruleString = ruleString + ";";
        this.setNeedsCompile(false);
    }

    public void addPreFillerItem(TextRulerRuleItem item) {
        this.slotPattern.preFillerPattern.add(0, item);
        this.setNeedsCompile(true);
    }

    public void addPreFillerItemWithNormalOrder(TextRulerRuleItem item) {
        this.slotPattern.preFillerPattern.add(item);
        this.setNeedsCompile(true);
    }

    public void addPostFillerItem(TextRulerRuleItem item) {
        this.slotPattern.postFillerPattern.add(item);
        this.setNeedsCompile(true);
    }

    public void addFillerItem(TextRulerRuleItem item) {
        if (this.target.type != TextRulerTarget.MLTargetType.SINGLE_WHOLE_SLOT) {
            throw new RuntimeException("[TextRulerRule] BOUNDARY SLOT RULES CANNOT HAVE FILLER ITEMS!");
        }
        this.slotPattern.fillerPattern.add(item);
        this.setNeedsCompile(true);
    }

    public TextRulerRuleItem getOutermostPreFillerItem() {
        if (this.slotPattern.preFillerPattern.size() == 0) {
            return null;
        }
        return (TextRulerRuleItem)this.slotPattern.preFillerPattern.get(0);
    }

    public TextRulerRuleItem getOutermostPostFillerItem() {
        if (this.slotPattern.postFillerPattern.size() == 0) {
            return null;
        }
        return (TextRulerRuleItem)this.slotPattern.postFillerPattern.get(this.slotPattern.postFillerPattern.size() - 1);
    }

    public void removeOutermostPreFillerItem() {
        if (this.slotPattern.preFillerPattern.size() > 0) {
            this.slotPattern.preFillerPattern.remove(0);
            this.setNeedsCompile(true);
        }
    }

    public void removeOutermostPostFillerItem() {
        if (this.slotPattern.postFillerPattern.size() > 0) {
            this.slotPattern.postFillerPattern.remove(this.slotPattern.postFillerPattern.size() - 1);
            this.setNeedsCompile(true);
        }
    }

    public TextRulerRuleItem getRuleItemWithIndex(int index) {
        int i = index;
        if (i < this.slotPattern.preFillerPattern.size()) {
            return (TextRulerRuleItem)this.slotPattern.preFillerPattern.get(i);
        }
        if ((i -= this.slotPattern.preFillerPattern.size()) < this.slotPattern.fillerPattern.size()) {
            return (TextRulerRuleItem)this.slotPattern.fillerPattern.get(i);
        }
        if ((i -= this.slotPattern.fillerPattern.size()) < this.slotPattern.postFillerPattern.size()) {
            return (TextRulerRuleItem)this.slotPattern.postFillerPattern.get(i);
        }
        return null;
    }

    public int totalItemCount() {
        return this.slotPattern.preFillerPattern.size() + this.slotPattern.fillerPattern.size() + this.slotPattern.postFillerPattern.size();
    }

    @Override
    public TextRulerSingleSlotRule copy() {
        return new TextRulerSingleSlotRule(this);
    }
}

