/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.dde.internal.details;

import org.apache.uima.aae.deployment.AsyncAEErrorConfiguration;
import org.apache.uima.aae.deployment.AsyncAggregateErrorConfiguration;
import org.apache.uima.aae.deployment.CollectionProcessCompleteErrors;
import org.apache.uima.aae.deployment.GetMetadataErrors;
import org.apache.uima.aae.deployment.ProcessCasErrors;
import org.apache.uima.aae.deployment.impl.DeploymentMetaData_Impl;
import org.apache.uima.dde.internal.DeploymentDescriptorEditor;
import org.apache.uima.dde.internal.Messages;
import org.apache.uima.dde.internal.provider.ErrorConfigContentProvider;
import org.apache.uima.dde.internal.provider.ErrorsConfigLabelProvider;
import org.apache.uima.dde.internal.provider.NameValuePair;
import org.apache.uima.tools.debug.util.Trace;
import org.apache.uima.tools.internal.ui.forms.FormSection;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.TableEditor;
import org.eclipse.swt.custom.TreeEditor;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.forms.IDetailsPage;
import org.eclipse.ui.forms.IFormPart;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.SectionPart;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.forms.widgets.TableWrapLayout;

public class ErrorConfigDetailsPage
implements IDetailsPage {
    private DeploymentDescriptorEditor multiPageEditor;
    private boolean isDelegate;
    private Object selectedObject = null;
    private IManagedForm mform;
    private FormToolkit toolkit;
    private Section sectionErrorConfigDetails;
    protected TableViewer getMetaDataViewer;
    protected TableViewer processCasErrorsViewer;
    protected TableViewer collProcessCompleteErrorsViewer;
    protected Button buttonGetMetaData;
    protected Button buttonProcessCasErrors;
    protected Button buttonCollCompleteErrors;
    protected Table tableGetMetaData;
    protected Table tableProcessCasErrors;
    protected Table tableCollCompleteErrors;

    public ErrorConfigDetailsPage(DeploymentDescriptorEditor editor, IManagedForm mform, boolean isDelegate) {
        this.multiPageEditor = editor;
        this.mform = mform;
        this.toolkit = mform.getToolkit();
        this.isDelegate = isDelegate;
    }

    public void createContents(Composite parent) {
        TableWrapLayout layout = new TableWrapLayout();
        layout.topMargin = 0;
        layout.leftMargin = 5;
        layout.rightMargin = 2;
        layout.bottomMargin = 2;
        parent.setLayout((Layout)layout);
        this.createConfigurationsSection(parent, this.toolkit);
    }

    public Section createConfigurationsSection(Composite parent, FormToolkit toolkit) {
        this.sectionErrorConfigDetails = FormSection.createTableWrapDataSection(toolkit, parent, 66, Messages.DDE_AEConfigPage_ErrorConfig_Section_Title, "The following is the information about the ...", 10, 5, 256, 256, 1, 1);
        SectionPart spart = new SectionPart(this.sectionErrorConfigDetails);
        this.mform.addPart((IFormPart)spart);
        spart.initialize(this.mform);
        this.sectionErrorConfigDetails.setExpanded(true);
        Composite sectionClient = toolkit.createComposite((Composite)this.sectionErrorConfigDetails);
        TableWrapLayout tl = new TableWrapLayout();
        tl.numColumns = 1;
        tl.leftMargin = 2;
        tl.rightMargin = 2;
        tl.topMargin = 2;
        tl.bottomMargin = 6;
        sectionClient.setLayout((Layout)tl);
        this.sectionErrorConfigDetails.setClient((Control)sectionClient);
        toolkit.paintBordersFor(sectionClient);
        if (this.isDelegate) {
            toolkit.createLabel(sectionClient, "Get Metadata Error:");
            this.tableGetMetaData = this.createErrorsTable(sectionClient, 3);
            this.getMetaDataViewer = new TableViewer(this.tableGetMetaData);
            this.getMetaDataViewer.setContentProvider((IContentProvider)new ErrorConfigContentProvider());
            this.getMetaDataViewer.setLabelProvider((IBaseLabelProvider)new ErrorsConfigLabelProvider(this.getMetaDataViewer));
            this.createEditorsForTableColumn(this.tableGetMetaData);
            new Label(sectionClient, 0).setText("");
        }
        toolkit.createLabel(sectionClient, "Process CAS Errors:");
        this.tableProcessCasErrors = this.createErrorsTable(sectionClient, this.isDelegate ? 6 : 3);
        this.processCasErrorsViewer = new TableViewer(this.tableProcessCasErrors);
        this.processCasErrorsViewer.setContentProvider((IContentProvider)new ErrorConfigContentProvider());
        this.processCasErrorsViewer.setLabelProvider((IBaseLabelProvider)new ErrorsConfigLabelProvider(this.processCasErrorsViewer));
        this.createEditorsForTableColumn(this.tableProcessCasErrors);
        new Label(sectionClient, 0).setText("");
        toolkit.createLabel(sectionClient, "Collection Process Complete Error:");
        this.tableCollCompleteErrors = this.createErrorsTable(sectionClient, 2);
        this.collProcessCompleteErrorsViewer = new TableViewer(this.tableCollCompleteErrors);
        this.collProcessCompleteErrorsViewer.setContentProvider((IContentProvider)new ErrorConfigContentProvider());
        this.collProcessCompleteErrorsViewer.setLabelProvider((IBaseLabelProvider)new ErrorsConfigLabelProvider(this.collProcessCompleteErrorsViewer));
        this.createEditorsForTableColumn(this.tableCollCompleteErrors);
        return this.sectionErrorConfigDetails;
    }

    private Table createErrorsTable(Composite parent, int totalItems) {
        Table table = this.toolkit.createTable(parent, 99072);
        table.setLinesVisible(true);
        table.setHeaderVisible(true);
        String[] headers = new String[]{"Name", "Value"};
        TableColumn[] columns = new TableColumn[headers.length];
        for (int i = 0; i < headers.length; ++i) {
            TableColumn tc = new TableColumn(table, 0, i);
            tc.setResizable(true);
            tc.setText(headers[i]);
            if (i == 0) {
                tc.setWidth(200);
            } else {
                tc.setWidth(100);
            }
            columns[i] = tc;
        }
        TableWrapData gd = new TableWrapData(256, 256);
        gd.grabHorizontal = true;
        gd.valign = 128;
        gd.heightHint = table.getHeaderHeight() + table.getItemHeight() * (totalItems + 1);
        table.setLayoutData((Object)gd);
        return table;
    }

    public void displayDetails(DeploymentMetaData_Impl meta, AsyncAEErrorConfiguration obj) {
        this.sectionErrorConfigDetails.setText(Messages.DDE_AEConfigPage_ErrorConfig_Section_Title + " - " + meta.getKey());
        if (this.getMetaDataViewer != null && obj.getGetMetadataErrors() != null) {
            this.getMetaDataViewer.setInput((Object)obj.getGetMetadataErrors());
        }
        if (obj.getProcessCasErrors() != null) {
            this.processCasErrorsViewer.setInput((Object)obj.getProcessCasErrors());
        }
        if (obj.getCollectionProcessCompleteErrors() != null) {
            this.collProcessCompleteErrorsViewer.setInput((Object)obj.getCollectionProcessCompleteErrors());
        }
    }

    private void createEditorsForTree(final Tree tree) {
        final TreeEditor editor1 = new TreeEditor(tree);
        editor1.horizontalAlignment = 0x1000000;
        editor1.minimumWidth = 60;
        final TreeEditor editor2 = new TreeEditor(tree);
        editor2.horizontalAlignment = 0x1000000;
        editor2.grabHorizontal = true;
        editor2.minimumWidth = 60;
        tree.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Control oldEditor = editor1.getEditor();
                if (oldEditor != null) {
                    oldEditor.dispose();
                }
                if ((oldEditor = editor2.getEditor()) != null) {
                    oldEditor.dispose();
                }
                final TreeItem item = (TreeItem)e.item;
                final Spinner spinner = new Spinner((Composite)tree, 2048);
                spinner.setMinimum(0);
                String level = item.getText(1);
                int defaultLevel = level.length() == 0 || "default".equals(level) ? 0 : Integer.parseInt(level);
                spinner.setSelection(defaultLevel);
                spinner.addModifyListener(new ModifyListener(){

                    public void modifyText(ModifyEvent e) {
                        if (item.getChecked()) {
                            int selection = spinner.getSelection();
                            item.setText(1, selection == 0 ? "default" : Integer.toString(selection));
                        }
                    }
                });
                editor1.setEditor((Control)spinner, item, 1);
                final CCombo combo = new CCombo((Composite)tree, 2056);
                combo.setItems(new String[]{"default", Boolean.toString(true), Boolean.toString(false)});
                combo.setText(item.getText(2));
                combo.pack();
                combo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        if (item.getChecked()) {
                            item.setText(2, combo.getText());
                        }
                    }
                });
                editor2.setEditor((Control)combo, item, 2);
            }
        });
    }

    private void createEditorsForTableColumn(final Table table) {
        final TableEditor editor1 = new TableEditor(table);
        editor1.horizontalAlignment = 0x1000000;
        editor1.grabHorizontal = true;
        editor1.minimumWidth = 60;
        final TableEditor editor2 = new TableEditor(table);
        editor2.horizontalAlignment = 0x1000000;
        editor2.grabHorizontal = true;
        editor2.minimumWidth = 60;
        table.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TableItem item;
                Control oldEditor = editor1.getEditor();
                if (oldEditor != null) {
                    oldEditor.dispose();
                }
                if ((oldEditor = editor2.getEditor()) != null) {
                    oldEditor.dispose();
                }
                if (!ErrorConfigDetailsPage.this.isEditable(item = (TableItem)e.item)) {
                    table.setSelection(new TableItem[0]);
                    return;
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                TableItem item;
                Control oldEditor = editor1.getEditor();
                if (oldEditor != null) {
                    oldEditor.dispose();
                }
                if ((oldEditor = editor2.getEditor()) != null) {
                    oldEditor.dispose();
                }
                if (!ErrorConfigDetailsPage.this.isEditable(item = (TableItem)e.item)) {
                    table.setSelection(new TableItem[0]);
                    return;
                }
                final NameValuePair nvp = (NameValuePair)item.getData();
                if (nvp == null) {
                    Trace.err((String)"No item's object");
                    return;
                }
                final Object obj = nvp.getParent();
                if (nvp.getType() == Integer.class) {
                    final Spinner spinner = new Spinner((Composite)table, 2048);
                    spinner.setMinimum(0);
                    spinner.setMaximum(Integer.MAX_VALUE);
                    String value = item.getText(1);
                    if (value.equals("no timeout") || value.equals("no retries") || value.equals("no threshold") || value.equals("no window")) {
                        value = "0";
                    }
                    int level = Integer.parseInt(value);
                    spinner.setSelection(level);
                    spinner.setFocus();
                    spinner.addFocusListener(new FocusListener(){

                        public void focusGained(FocusEvent e) {
                        }

                        public void focusLost(FocusEvent e) {
                            Control oldEditor = editor1.getEditor();
                            if (oldEditor != null) {
                                oldEditor.dispose();
                            }
                            if ((oldEditor = editor2.getEditor()) != null) {
                                oldEditor.dispose();
                            }
                            spinner.dispose();
                        }
                    });
                    spinner.addModifyListener(new ModifyListener(){

                        public void modifyText(ModifyEvent e) {
                            int selection = spinner.getSelection();
                            item.setText(1, Integer.toString(selection));
                            int id = nvp.getId();
                            if (obj instanceof GetMetadataErrors) {
                                GetMetadataErrors getMetadataErrors = (GetMetadataErrors)obj;
                                getMetadataErrors.setValueById(id, (Object)selection);
                                ErrorConfigDetailsPage.this.getMetaDataViewer.refresh();
                            } else if (obj instanceof ProcessCasErrors) {
                                ProcessCasErrors processCasErrors = (ProcessCasErrors)obj;
                                processCasErrors.setValueById(id, (Object)selection);
                                ErrorConfigDetailsPage.this.processCasErrorsViewer.refresh();
                            } else if (obj instanceof CollectionProcessCompleteErrors) {
                                CollectionProcessCompleteErrors completeErrors = (CollectionProcessCompleteErrors)obj;
                                completeErrors.setValueById(id, (Object)selection);
                                ErrorConfigDetailsPage.this.collProcessCompleteErrorsViewer.refresh();
                            }
                            ErrorConfigDetailsPage.this.multiPageEditor.setFileDirty();
                        }
                    });
                    editor1.setEditor((Control)spinner, item, 1);
                } else if (nvp.getType() == String.class) {
                    final CCombo combo = new CCombo((Composite)table, 2056);
                    combo.setItems(new String[]{"terminate", "disable"});
                    combo.setText(item.getText(1));
                    combo.pack();
                    combo.setFocus();
                    combo.addFocusListener(new FocusListener(){

                        public void focusGained(FocusEvent e) {
                        }

                        public void focusLost(FocusEvent e) {
                            Control oldEditor = editor1.getEditor();
                            if (oldEditor != null) {
                                oldEditor.dispose();
                            }
                            if ((oldEditor = editor2.getEditor()) != null) {
                                oldEditor.dispose();
                            }
                            combo.dispose();
                        }
                    });
                    combo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                        public void widgetSelected(SelectionEvent e) {
                            String selection = combo.getText();
                            item.setText(1, selection);
                            int id = nvp.getId();
                            if (obj instanceof GetMetadataErrors) {
                                GetMetadataErrors getMetadataErrors = (GetMetadataErrors)obj;
                                getMetadataErrors.setValueById(id, (Object)selection);
                                ErrorConfigDetailsPage.this.getMetaDataViewer.refresh();
                            } else if (obj instanceof ProcessCasErrors) {
                                ProcessCasErrors processCasErrors = (ProcessCasErrors)obj;
                                processCasErrors.setValueById(id, (Object)selection);
                                ErrorConfigDetailsPage.this.processCasErrorsViewer.refresh();
                            } else if (obj instanceof CollectionProcessCompleteErrors) {
                                CollectionProcessCompleteErrors completeErrors = (CollectionProcessCompleteErrors)obj;
                                completeErrors.setValueById(id, (Object)selection);
                                ErrorConfigDetailsPage.this.collProcessCompleteErrorsViewer.refresh();
                            }
                            ErrorConfigDetailsPage.this.multiPageEditor.setFileDirty();
                        }
                    });
                    editor2.setEditor((Control)combo, item, 1);
                } else if (nvp.getType() == Boolean.class) {
                    if (obj instanceof ProcessCasErrors) {
                        final CCombo combo = new CCombo((Composite)table, 2056);
                        combo.setItems(new String[]{Boolean.toString(true), Boolean.toString(false)});
                        combo.setText(item.getText(1));
                        combo.pack();
                        combo.setFocus();
                        combo.addFocusListener(new FocusListener(){

                            public void focusGained(FocusEvent e) {
                            }

                            public void focusLost(FocusEvent e) {
                                Control oldEditor = editor1.getEditor();
                                if (oldEditor != null) {
                                    oldEditor.dispose();
                                }
                                if ((oldEditor = editor2.getEditor()) != null) {
                                    oldEditor.dispose();
                                }
                                combo.dispose();
                            }
                        });
                        combo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                            public void widgetSelected(SelectionEvent e) {
                                String selection = combo.getText();
                                int id = nvp.getId();
                                item.setText(1, selection);
                                ProcessCasErrors processCasErrors = (ProcessCasErrors)obj;
                                processCasErrors.setValueById(id, (Object)selection);
                                ErrorConfigDetailsPage.this.processCasErrorsViewer.refresh();
                                ErrorConfigDetailsPage.this.multiPageEditor.setFileDirty();
                            }
                        });
                        editor2.setEditor((Control)combo, item, 1);
                    }
                } else {
                    Trace.err((String)("nvp.getType(): " + nvp.getType().getClass().getName()));
                }
            }
        });
    }

    private void createEditorsForTable_NOT_USED(final Table table) {
        final TableEditor editor1 = new TableEditor(table);
        editor1.horizontalAlignment = 0x1000000;
        editor1.grabHorizontal = true;
        editor1.minimumWidth = 60;
        final TableEditor editor2 = new TableEditor(table);
        editor2.horizontalAlignment = 0x1000000;
        editor2.grabHorizontal = true;
        editor2.minimumWidth = 60;
        table.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TableItem item;
                NameValuePair nvp;
                Control oldEditor = editor1.getEditor();
                if (oldEditor != null) {
                    oldEditor.dispose();
                }
                if ((oldEditor = editor2.getEditor()) != null) {
                    oldEditor.dispose();
                }
                if ((nvp = (NameValuePair)(item = (TableItem)e.item).getData()) == null) {
                    Trace.err((String)"No item's object");
                    return;
                }
                final Object obj = nvp.getParent();
                if (nvp.getType() == Integer.class) {
                    final Spinner spinner = new Spinner((Composite)table, 2048);
                    spinner.setMinimum(0);
                    spinner.setMaximum(Integer.MAX_VALUE);
                    int level = Integer.parseInt(item.getText(1));
                    spinner.setSelection(level);
                    spinner.addModifyListener(new ModifyListener(){

                        public void modifyText(ModifyEvent e) {
                            int selection = spinner.getSelection();
                            item.setText(1, Integer.toString(selection));
                            int id = nvp.getId();
                            if (obj instanceof GetMetadataErrors) {
                                GetMetadataErrors getMetadataErrors = (GetMetadataErrors)obj;
                                getMetadataErrors.setValueById(id, (Object)selection);
                                ErrorConfigDetailsPage.this.getMetaDataViewer.refresh();
                            } else if (obj instanceof ProcessCasErrors) {
                                ProcessCasErrors processCasErrors = (ProcessCasErrors)obj;
                                processCasErrors.setValueById(id, (Object)selection);
                                ErrorConfigDetailsPage.this.processCasErrorsViewer.refresh();
                            } else if (obj instanceof CollectionProcessCompleteErrors) {
                                CollectionProcessCompleteErrors completeErrors = (CollectionProcessCompleteErrors)obj;
                                completeErrors.setValueById(id, (Object)selection);
                                ErrorConfigDetailsPage.this.collProcessCompleteErrorsViewer.refresh();
                            }
                        }
                    });
                    editor1.setEditor((Control)spinner, item, 1);
                } else if (nvp.getType() == String.class) {
                    final CCombo combo = new CCombo((Composite)table, 2056);
                    combo.setItems(new String[]{"terminate", "disable"});
                    combo.setText(item.getText(1));
                    combo.pack();
                    combo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                        public void widgetSelected(SelectionEvent e) {
                            String selection = combo.getText();
                            item.setText(1, selection);
                            int id = nvp.getId();
                            if (obj instanceof GetMetadataErrors) {
                                GetMetadataErrors getMetadataErrors = (GetMetadataErrors)obj;
                                getMetadataErrors.setValueById(id, (Object)selection);
                                ErrorConfigDetailsPage.this.getMetaDataViewer.refresh();
                            } else if (obj instanceof ProcessCasErrors) {
                                ProcessCasErrors processCasErrors = (ProcessCasErrors)obj;
                                processCasErrors.setValueById(id, (Object)selection);
                                ErrorConfigDetailsPage.this.processCasErrorsViewer.refresh();
                            } else if (obj instanceof CollectionProcessCompleteErrors) {
                                CollectionProcessCompleteErrors completeErrors = (CollectionProcessCompleteErrors)obj;
                                completeErrors.setValueById(id, (Object)selection);
                                ErrorConfigDetailsPage.this.collProcessCompleteErrorsViewer.refresh();
                            }
                        }
                    });
                    editor2.setEditor((Control)combo, item, 1);
                } else if (nvp.getType() == Boolean.class) {
                    if (obj instanceof ProcessCasErrors) {
                        final CCombo combo = new CCombo((Composite)table, 2056);
                        combo.setItems(new String[]{Boolean.toString(true), Boolean.toString(false)});
                        combo.setText(item.getText(1));
                        combo.pack();
                        combo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                            public void widgetSelected(SelectionEvent e) {
                                int id = nvp.getId();
                                item.setText(1, combo.getText());
                                ProcessCasErrors processCasErrors = (ProcessCasErrors)obj;
                                processCasErrors.setValueById(id, (Object)combo.getText());
                                ErrorConfigDetailsPage.this.processCasErrorsViewer.refresh();
                            }
                        });
                        editor2.setEditor((Control)combo, item, 1);
                    }
                } else {
                    Trace.err((String)("nvp.getType(): " + nvp.getType().getClass().getName()));
                }
            }
        });
    }

    private boolean isEditable(TableItem item) {
        NameValuePair nvp = (NameValuePair)item.getData();
        if (nvp == null) {
            Trace.err((String)"No item's object");
            return false;
        }
        return nvp.getStatusFlags() != 1;
    }

    public void commit(boolean onSave) {
    }

    public void dispose() {
    }

    public void initialize(IManagedForm form) {
        this.mform = form;
    }

    public boolean isDirty() {
        return false;
    }

    public boolean isStale() {
        return false;
    }

    public void refresh() {
    }

    public void setFocus() {
    }

    public boolean setFormInput(Object input) {
        return false;
    }

    public void selectionChanged(IFormPart part, ISelection selection) {
        if (selection == null || !(selection instanceof IStructuredSelection)) {
            return;
        }
        IStructuredSelection ssel = (IStructuredSelection)selection;
        if (ssel.size() != 1) {
            return;
        }
        this.selectedObject = ssel.getFirstElement();
        if (!(this.selectedObject instanceof AsyncAggregateErrorConfiguration)) {
            Trace.err((String)("selectedObject: " + this.selectedObject.getClass().getName()));
        }
    }

    private class WidgetListener
    implements ModifyListener,
    SelectionListener {
        private WidgetListener() {
        }

        public void modifyText(ModifyEvent e) {
        }

        public void widgetSelected(SelectionEvent e) {
            Object source = e.getSource();
            if (source == ErrorConfigDetailsPage.this.buttonGetMetaData) {
                ErrorConfigDetailsPage.this.tableGetMetaData.setEnabled(ErrorConfigDetailsPage.this.buttonGetMetaData.getSelection());
            } else if (source == ErrorConfigDetailsPage.this.buttonProcessCasErrors) {
                ErrorConfigDetailsPage.this.tableProcessCasErrors.setEnabled(ErrorConfigDetailsPage.this.buttonProcessCasErrors.getSelection());
            } else if (source == ErrorConfigDetailsPage.this.buttonCollCompleteErrors) {
                ErrorConfigDetailsPage.this.tableCollCompleteErrors.setEnabled(ErrorConfigDetailsPage.this.buttonCollCompleteErrors.getSelection());
            }
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }
    }
}

