/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.textruler.learner.trabal;

import java.util.List;
import org.apache.uima.ruta.textruler.core.TextRulerTarget;
import org.apache.uima.ruta.textruler.learner.trabal.AnnotationErrorType;
import org.apache.uima.ruta.textruler.learner.trabal.Condition;
import org.apache.uima.ruta.textruler.learner.trabal.ConditionType;
import org.apache.uima.ruta.textruler.learner.trabal.ShiftingRule;
import org.apache.uima.ruta.textruler.learner.trabal.TrabalAnnotation;
import org.apache.uima.ruta.textruler.learner.trabal.TrabalLearner;
import org.apache.uima.ruta.textruler.learner.trabal.TrabalRule;

public class ExpansionRule
extends ShiftingRule {
    public ExpansionRule(TrabalLearner parentAlgorithm, TextRulerTarget target, TrabalAnnotation annotation, TrabalAnnotation targetAnnotation, AnnotationErrorType errorType) {
        super(parentAlgorithm, target, annotation, targetAnnotation, errorType);
    }

    public ExpansionRule(ExpansionRule copyFrom) {
        super(copyFrom);
    }

    @Override
    public void compileRuleString() {
        boolean expandToLeft;
        this.ruleString = "";
        int errorBegin = this.annotation.getBegin();
        int truthBegin = this.targetAnnotation.getBegin();
        int truthEnd = this.targetAnnotation.getEnd();
        boolean bl = expandToLeft = truthBegin < errorBegin;
        if (expandToLeft) {
            this.expandToLeft(truthBegin);
        } else {
            this.expandToRight(truthEnd);
        }
        this.setNeedsCompile(false);
    }

    private void expandToLeft(int truthBegin) {
        String before;
        boolean frontItemInBorders = this.frontBoundaryItem.getAnnotation().getBegin() == truthBegin;
        Object conditions = this.parseConditions(this.conditionTypes, true);
        if (((String)conditions).length() > 0) {
            conditions = (String)conditions + " ";
        }
        this.conditionTypes.add(ConditionType.BEFORE);
        Object negativeConditions = this.parseConditions(this.conditionTypes, false);
        if (((String)negativeConditions).length() > 0) {
            negativeConditions = (String)negativeConditions + " ";
        }
        if ((before = this.parseConditions(ConditionType.BEFORE, true)).length() > 0 && ((String)negativeConditions).length() > 0) {
            negativeConditions = before + ", " + (String)negativeConditions;
        } else if (before.length() > 0) {
            negativeConditions = before + " ";
        }
        String unmark = "{" + (String)negativeConditions + "-> UNMARK(" + this.annotation.getType().getShortName() + ")}";
        Object after = this.parseConditions(ConditionType.AFTER);
        if (((String)after).length() > 0) {
            after = "{" + (String)after + "}";
        }
        this.ruleString = frontItemInBorders ? this.ruleString + "(" + String.valueOf(this.frontBoundaryItem) + (String)after + " " : this.ruleString + String.valueOf(this.frontBoundaryItem) + (String)after + " (";
        this.ruleString = this.ruleString + "ANY*{-PARTOF(" + this.annotation.getType().getShortName() + ")} ";
        String mark = ((TrabalLearner)this.algorithm).getEnableFeatures() ? "-> CREATE(" + this.targetAnnotation.getType().getShortName() + this.parseFeatures() + ")" : "-> MARK(" + this.targetAnnotation.getType().getShortName() + ")";
        String action = "{" + (String)conditions + mark + "}";
        this.ruleString = this.ruleString + this.annotation.getType().getShortName() + unmark + ")" + action + ";";
    }

    private void expandToRight(int truthEnd) {
        String after;
        boolean rearItemInBorders = this.rearBoundaryItem.getAnnotation().getEnd() == truthEnd;
        Object conditions = this.parseConditions(this.conditionTypes, true);
        if (((String)conditions).length() > 0) {
            conditions = (String)conditions + " ";
        }
        this.conditionTypes.add(ConditionType.AFTER);
        Object negativeConditions = this.parseConditions(this.conditionTypes, false);
        if (((String)negativeConditions).length() > 0) {
            negativeConditions = (String)negativeConditions + " ";
        }
        if ((after = this.parseConditions(ConditionType.AFTER, true)).length() > 0 && ((String)negativeConditions).length() > 0) {
            negativeConditions = after + ", " + (String)negativeConditions;
        } else if (after.length() > 0) {
            negativeConditions = after + " ";
        }
        String unmark = "{" + (String)negativeConditions + "-> UNMARK(" + this.annotation.getType().getShortName() + ")}";
        this.ruleString = this.ruleString + "(" + this.annotation.getType().getShortName() + unmark + " ";
        this.ruleString = this.ruleString + "ANY*{-PARTOF(" + String.valueOf(this.rearBoundaryItem) + ")}";
        String mark = ((TrabalLearner)this.algorithm).getEnableFeatures() ? "-> CREATE(" + this.targetAnnotation.getType().getShortName() + this.parseFeatures() + ")" : "-> MARK(" + this.targetAnnotation.getType().getShortName() + ")";
        String action = "{" + (String)conditions + mark + "}";
        Object before = this.parseConditions(ConditionType.BEFORE);
        if (((String)before).length() > 0) {
            before = "{" + (String)before + "}";
        }
        this.ruleString = rearItemInBorders ? this.ruleString + " " + String.valueOf(this.rearBoundaryItem) + (String)before + ")" + action + ";" : this.ruleString + ")" + action + " " + String.valueOf(this.rearBoundaryItem) + (String)before + ";";
    }

    private String parseConditions(List<ConditionType> types, boolean positive) {
        Object result = "";
        for (Condition each : this.conditions) {
            if (!types.contains((Object)each.getType()) || each.isNegative() == positive) continue;
            if (each.isNegative()) {
                each.changePosNegValue();
                result = (String)result + String.valueOf(each) + ", ";
                each.changePosNegValue();
                continue;
            }
            result = (String)result + String.valueOf(each) + ", ";
        }
        if (((String)result).length() > 0) {
            return ((String)result).substring(0, ((String)result).length() - 2);
        }
        return "";
    }

    private String parseConditions(ConditionType type, boolean positive) {
        Object result = "";
        for (Condition each : this.conditions) {
            if (each.getType() != type || each.isNegative() == positive) continue;
            if (each.isNegative()) {
                each.changePosNegValue();
                result = (String)result + String.valueOf(each) + ", ";
                each.changePosNegValue();
                continue;
            }
            result = (String)result + String.valueOf(each) + ", ";
        }
        if (((String)result).length() > 0) {
            return ((String)result).substring(0, ((String)result).length() - 2);
        }
        return "";
    }

    @Override
    public TrabalRule copy() {
        return new ExpansionRule(this);
    }
}

