/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.ps.service.transport.target;

import org.apache.uima.ducc.ps.service.errors.ServiceException;
import org.apache.uima.ducc.ps.service.transport.ITargetURI;
import org.apache.uima.ducc.ps.service.transport.target.HttpTargetURI;
import org.apache.uima.ducc.ps.service.transport.target.SocketTargetURI;

public class TargetURIFactory {
    private TargetURIFactory() {
    }

    public static ITargetURI newTarget(String targetAsString) throws ServiceException {
        if (targetAsString.toLowerCase().startsWith("http:")) {
            return new HttpTargetURI(targetAsString);
        }
        if (targetAsString.toLowerCase().startsWith("tcp:")) {
            return new SocketTargetURI(targetAsString);
        }
        throw new ServiceException("Registry provider unsupported URL protocol - Expected either tcp or http - Instead got " + targetAsString);
    }
}

