/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.adapter.soap;

import java.io.File;
import org.apache.axis.encoding.DeserializationContext;
import org.apache.axis.encoding.DeserializerImpl;
import org.apache.axis.message.SOAPHandler;
import org.apache.uima.UIMAFramework;
import org.apache.uima.util.InvalidXMLException;
import org.apache.uima.util.XMLParser;
import org.apache.uima.util.XMLizable;
import org.apache.uima.util.impl.SaxDeserializer_impl;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.LocatorImpl;

public class XmlDeserializer
extends DeserializerImpl {
    private static final long serialVersionUID = -2178663551643071383L;
    private SaxDeserializer_impl mDeser;
    private int mNesting;

    public XmlDeserializer() {
        try {
            this.mNesting = 0;
            this.mDeser = new SaxDeserializer_impl(UIMAFramework.getXMLParser(), null, null, new XMLParser.ParsingOptions(false));
            LocatorImpl loc = new LocatorImpl();
            loc.setSystemId(new File(System.getProperty("user.dir")).toURL().toString());
            this.mDeser.setDocumentLocator((Locator)loc);
            this.mDeser.startDocument();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public SOAPHandler onStartChild(String namespace, String localName, String prefix, Attributes attributes, DeserializationContext context) throws SAXException {
        return this;
    }

    public void onStartElement(String arg0, String arg1, String arg2, Attributes arg3, DeserializationContext arg4) throws SAXException {
        if (this.mNesting > 0) {
            this.mDeser.startElement(arg0, arg1, arg1, arg3);
        }
        ++this.mNesting;
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        this.mDeser.characters(ch, start, length);
    }

    public void onEndElement(String arg0, String arg1, DeserializationContext arg2) throws SAXException {
        --this.mNesting;
        if (this.mNesting > 0) {
            this.mDeser.endElement(arg0, arg1, arg1);
        }
    }

    public void valueComplete() throws SAXException {
        if (this.mNesting == 0) {
            this.mDeser.endDocument();
            try {
                XMLizable val = this.mDeser.getObject();
                this.setValue(val);
            }
            catch (InvalidXMLException e) {
                e.printStackTrace();
                this.setValue(null);
            }
            super.valueComplete();
        }
    }
}

