/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.orchestrator;

import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.uima.ducc.common.utils.DuccLogger;
import org.apache.uima.ducc.common.utils.id.DuccId;
import org.apache.uima.ducc.orchestrator.OrchestratorCommonArea;
import org.apache.uima.ducc.transport.event.common.DuccWorkMap;
import org.apache.uima.ducc.transport.event.common.IDuccWorkJob;
import org.apache.uima.ducc.transport.event.common.IDuccWorkReservation;
import org.apache.uima.ducc.transport.event.common.history.IHistoryPersistenceManager;

public class OrchestratorRecovery {
    private static final DuccLogger logger = DuccLogger.getLogger(OrchestratorRecovery.class);
    private static final DuccId jobid = null;
    IHistoryPersistenceManager historyPersistenceManager = null;

    public OrchestratorRecovery(IHistoryPersistenceManager historyPersistenceManager) {
        this.setHistoryPersistenceManager(historyPersistenceManager);
    }

    private void setHistoryPersistenceManager(IHistoryPersistenceManager value) {
        this.historyPersistenceManager = value;
    }

    private Long findHistoryLastJob() {
        String location = "findHistoryLastJob";
        Long retVal = new Long(-1L);
        try {
            List duccWorkJobs = this.historyPersistenceManager.restoreJobs(1L);
            if (duccWorkJobs != null) {
                if (!duccWorkJobs.isEmpty()) {
                    Iterator iterator = duccWorkJobs.iterator();
                    if (iterator.hasNext()) {
                        IDuccWorkJob job = (IDuccWorkJob)iterator.next();
                        DuccId duccId = job.getDuccId();
                        retVal = duccId.getFriendly();
                        logger.info(location, jobid, new Object[]{"hist job " + retVal});
                    }
                } else {
                    logger.debug(location, jobid, new Object[]{"hist job empty"});
                }
            } else {
                logger.debug(location, jobid, new Object[]{"hist job not found"});
            }
        }
        catch (Exception e) {
            logger.error(location, jobid, (Throwable)e, new Object[0]);
        }
        return retVal;
    }

    private Long findHistoryLastReservation() {
        String location = "findHistoryLastReservation";
        Long retVal = new Long(-1L);
        try {
            List duccWorkReservations = this.historyPersistenceManager.restoreReservations(1L);
            if (duccWorkReservations != null) {
                if (!duccWorkReservations.isEmpty()) {
                    Iterator iterator = duccWorkReservations.iterator();
                    if (iterator.hasNext()) {
                        IDuccWorkReservation reservation = (IDuccWorkReservation)iterator.next();
                        DuccId duccId = reservation.getDuccId();
                        retVal = duccId.getFriendly();
                        logger.info(location, jobid, new Object[]{"hist reservation " + retVal});
                    }
                } else {
                    logger.debug(location, jobid, new Object[]{"hist reservation empty"});
                }
            } else {
                logger.debug(location, jobid, new Object[]{"hist reservation not found"});
            }
        }
        catch (Exception e) {
            logger.error(location, jobid, (Throwable)e, new Object[0]);
        }
        return retVal;
    }

    private Long findCheckpointLastJob() {
        String location = "findCheckpointLastJob";
        Long retVal = new Long(-1L);
        DuccWorkMap workMap = OrchestratorCommonArea.getInstance().getWorkMap();
        try {
            if (workMap != null) {
                DuccId duccId = this.getMax(workMap.getJobKeySet());
                if (duccId != null) {
                    retVal = duccId.getFriendly();
                    logger.info(location, jobid, new Object[]{"ckpt job " + retVal});
                } else {
                    logger.debug(location, jobid, new Object[]{"ckpt job not found"});
                }
            } else {
                logger.debug(location, jobid, new Object[]{"workmap not found"});
            }
        }
        catch (Exception e) {
            logger.error(location, jobid, (Throwable)e, new Object[0]);
        }
        return retVal;
    }

    private Long findCheckpointLastReservation() {
        String location = "findCheckpointLastReservation";
        Long retVal = new Long(-1L);
        DuccWorkMap workMap = OrchestratorCommonArea.getInstance().getWorkMap();
        try {
            if (workMap != null) {
                DuccId duccId = this.getMax(workMap.getReservationKeySet());
                if (duccId != null) {
                    retVal = duccId.getFriendly();
                    logger.info(location, jobid, new Object[]{"ckpt reservation " + retVal});
                } else {
                    logger.debug(location, jobid, new Object[]{"ckpt reservation not found"});
                }
            } else {
                logger.debug(location, jobid, new Object[]{"workmap not found"});
            }
        }
        catch (Exception e) {
            logger.error(location, jobid, (Throwable)e, new Object[0]);
        }
        return retVal;
    }

    private DuccId getMax(Set<DuccId> keys) {
        DuccId retVal = null;
        if (keys != null) {
            for (DuccId key : keys) {
                if (retVal == null) {
                    retVal = key;
                    continue;
                }
                if (key.getFriendly() <= retVal.getFriendly()) continue;
                retVal = key;
            }
        }
        return retVal;
    }

    private Long maxOf(Long v0, Long v1, String text) {
        String location = "maxOf";
        Long retVal = v0;
        if (v1 > v0) {
            retVal = v1;
            logger.info(location, jobid, new Object[]{text, v0, v1});
        }
        return retVal;
    }

    public Long recoverSeqNo() {
        String location = "recoverSeqNo";
        Long seqNo = new Long(-1L);
        seqNo = this.maxOf(seqNo, this.findHistoryLastJob(), "history:job");
        seqNo = this.maxOf(seqNo, this.findHistoryLastReservation(), "history:reservation");
        seqNo = this.maxOf(seqNo, this.findCheckpointLastJob(), "checkpoint:job");
        seqNo = this.maxOf(seqNo, this.findCheckpointLastReservation(), "checkpoint:reservation");
        logger.info(location, jobid, new Object[]{seqNo});
        return seqNo;
    }
}

