/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.orchestrator;

import org.apache.uima.ducc.common.utils.DuccLogger;
import org.apache.uima.ducc.common.utils.IDuccLoggerComponents;
import org.apache.uima.ducc.common.utils.TimeStamp;
import org.apache.uima.ducc.orchestrator.system.events.log.SystemEventsLogger;
import org.apache.uima.ducc.orchestrator.user.UserLogging;
import org.apache.uima.ducc.transport.event.common.IDuccCompletionType;
import org.apache.uima.ducc.transport.event.common.IDuccState;
import org.apache.uima.ducc.transport.event.common.IDuccTypes;
import org.apache.uima.ducc.transport.event.common.IDuccWork;
import org.apache.uima.ducc.transport.event.common.IDuccWorkJob;
import org.apache.uima.ducc.transport.event.common.IDuccWorkService;
import org.apache.uima.ducc.transport.event.common.IRationale;

public class StateJobAccounting {
    private static final DuccLogger logger = DuccLogger.getLogger(StateJobAccounting.class);
    private static StateJobAccounting instance = new StateJobAccounting();

    public static StateJobAccounting getInstance() {
        return instance;
    }

    private boolean advance(IDuccWorkJob job) {
        String methodName = "advance";
        boolean retVal = false;
        try {
            IDuccTypes.DuccType duccType = job.getDuccType();
            block1 : switch (duccType) {
                case Service: {
                    IDuccWorkService.ServiceDeploymentType sdt = job.getServiceDeploymentType();
                    switch (sdt) {
                        case other: {
                            IDuccState.JobState state = job.getJobState();
                            switch (state) {
                                case Initializing: {
                                    IDuccState.JobState next = IDuccState.JobState.Running;
                                    IDuccState.JobState prev = state;
                                    logger.info(methodName, job.getDuccId(), new Object[]{"current[" + next + "] previous[" + prev + "] -> skipped"});
                                    retVal = this.stateChange(job, next);
                                    break block1;
                                }
                            }
                            logger.debug(methodName, job.getDuccId(), new Object[]{"State is not " + IDuccState.JobState.Initializing + " state"});
                            break block1;
                        }
                    }
                    logger.debug(methodName, job.getDuccId(), new Object[]{"Service is not ManagedReservation (other); ServiceDeploymentType=" + sdt});
                    break;
                }
                default: {
                    logger.debug(methodName, job.getDuccId(), new Object[]{"DuccType=" + duccType});
                    break;
                }
            }
        }
        catch (Exception e) {
            logger.error(methodName, job.getDuccId(), (Throwable)e, new Object[0]);
        }
        return retVal;
    }

    public boolean stateChange(IDuccWorkJob job, IDuccState.JobState state) {
        String methodName = "stateChange";
        boolean retVal = false;
        logger.debug(methodName, job.getDuccId(), new Object[]{job.getCompletionType() + " " + job.getCompletionRationale()});
        IDuccState.JobState prev = job.getJobState();
        IDuccState.JobState next = state;
        String p = prev.name();
        String n = next.name();
        switch (prev) {
            case Completing: {
                retVal = this.stateChangeFromCompleting(prev, next);
                break;
            }
            case Completed: {
                switch (next) {
                    case Completing: {
                        next = prev;
                        break;
                    }
                }
                retVal = this.stateChangeFromCompleted(prev, next);
                break;
            }
            case Assigned: {
                retVal = this.stateChangeFromAssigned(prev, next);
                break;
            }
            case Initializing: {
                retVal = this.stateChangeFromInitializing(prev, next);
                break;
            }
            case Received: {
                retVal = this.stateChangeFromReceived(prev, next);
                break;
            }
            case Running: {
                retVal = this.stateChangeFromRunning(prev, next);
                break;
            }
            case Undefined: {
                retVal = this.stateChangeFromUndefined(prev, next);
                break;
            }
            case WaitingForDriver: {
                retVal = this.stateChangeFromWaitingForDriver(prev, next);
                break;
            }
            case WaitingForResources: {
                retVal = this.stateChangeFromWaitingForResources(prev, next);
                break;
            }
            case WaitingForServices: {
                retVal = this.stateChangeFromWaitingForServices(prev, next);
            }
        }
        if (retVal) {
            job.setJobState(state);
            switch (state) {
                case Completing: {
                    job.getStandardInfo().setDateOfCompletion(TimeStamp.getCurrentMillis());
                }
            }
            switch (state) {
                case Completed: {
                    this.recordUserState(job);
                    this.recordUserCompletion(job);
                    SystemEventsLogger.info(IDuccLoggerComponents.abbrv_orchestrator, state.name(), (IDuccWork)job);
                    break;
                }
                default: {
                    this.recordUserState(job);
                }
            }
            boolean advanceVal = this.advance(job);
            if (!advanceVal) {
                logger.info(methodName, job.getDuccId(), new Object[]{"current[" + next + "] previous[" + prev + "]"});
            }
        } else {
            try {
                throw new RuntimeException();
            }
            catch (Exception e) {
                logger.error(methodName, job.getDuccId(), new Object[]{"current[" + prev + "] requested[" + next + "] ignored", e});
            }
        }
        logger.info(methodName, job.getDuccId(), new Object[]{p, n, retVal});
        return retVal;
    }

    private boolean stateChangeFromCompleting(IDuccState.JobState prev, IDuccState.JobState next) {
        boolean retVal = false;
        switch (next) {
            case Completing: {
                break;
            }
            case Completed: {
                retVal = true;
                break;
            }
            case Assigned: {
                break;
            }
            case Initializing: {
                break;
            }
            case Received: {
                break;
            }
            case Running: {
                break;
            }
            case Undefined: {
                break;
            }
            case WaitingForDriver: {
                break;
            }
            case WaitingForResources: {
                break;
            }
        }
        return retVal;
    }

    private boolean stateChangeFromCompleted(IDuccState.JobState prev, IDuccState.JobState next) {
        boolean retVal = false;
        switch (next) {
            case Completing: {
                break;
            }
            case Completed: {
                break;
            }
            case Assigned: {
                break;
            }
            case Initializing: {
                break;
            }
            case Received: {
                break;
            }
            case Running: {
                break;
            }
            case Undefined: {
                break;
            }
            case WaitingForDriver: {
                break;
            }
            case WaitingForResources: {
                break;
            }
        }
        return retVal;
    }

    private boolean stateChangeFromAssigned(IDuccState.JobState prev, IDuccState.JobState next) {
        boolean retVal = false;
        switch (next) {
            case Completing: {
                retVal = true;
                break;
            }
            case Completed: {
                retVal = true;
                break;
            }
            case Assigned: {
                break;
            }
            case Initializing: {
                retVal = true;
                break;
            }
            case Received: {
                break;
            }
            case Running: {
                retVal = true;
                break;
            }
            case Undefined: {
                break;
            }
            case WaitingForDriver: {
                break;
            }
            case WaitingForResources: {
                break;
            }
        }
        return retVal;
    }

    private boolean stateChangeFromInitializing(IDuccState.JobState prev, IDuccState.JobState next) {
        boolean retVal = false;
        switch (next) {
            case Completing: {
                retVal = true;
                break;
            }
            case Completed: {
                retVal = true;
                break;
            }
            case Assigned: {
                break;
            }
            case Initializing: {
                break;
            }
            case Received: {
                break;
            }
            case Running: {
                retVal = true;
                break;
            }
            case Undefined: {
                break;
            }
            case WaitingForDriver: {
                break;
            }
            case WaitingForResources: {
                break;
            }
        }
        return retVal;
    }

    private boolean stateChangeFromReceived(IDuccState.JobState prev, IDuccState.JobState next) {
        boolean retVal = false;
        switch (next) {
            case Completing: {
                retVal = true;
                break;
            }
            case Completed: {
                retVal = true;
                break;
            }
            case Assigned: {
                break;
            }
            case Initializing: {
                break;
            }
            case Received: {
                break;
            }
            case Running: {
                break;
            }
            case Undefined: {
                break;
            }
            case WaitingForDriver: {
                retVal = true;
                break;
            }
            case WaitingForResources: {
                retVal = true;
                break;
            }
            case WaitingForServices: {
                retVal = true;
            }
        }
        return retVal;
    }

    private boolean stateChangeFromRunning(IDuccState.JobState prev, IDuccState.JobState next) {
        boolean retVal = false;
        switch (next) {
            case Completing: {
                retVal = true;
                break;
            }
            case Completed: {
                retVal = true;
                break;
            }
            case Assigned: {
                break;
            }
            case Initializing: {
                break;
            }
            case Received: {
                break;
            }
            case Running: {
                break;
            }
            case Undefined: {
                break;
            }
            case WaitingForDriver: {
                break;
            }
            case WaitingForResources: {
                break;
            }
        }
        return retVal;
    }

    private boolean stateChangeFromUndefined(IDuccState.JobState prev, IDuccState.JobState next) {
        boolean retVal = false;
        switch (next) {
            case Completing: {
                break;
            }
            case Completed: {
                break;
            }
            case Assigned: {
                break;
            }
            case Initializing: {
                break;
            }
            case Received: {
                retVal = true;
                break;
            }
            case Running: {
                break;
            }
            case Undefined: {
                break;
            }
            case WaitingForDriver: {
                break;
            }
            case WaitingForResources: {
                break;
            }
        }
        return retVal;
    }

    private boolean stateChangeFromWaitingForDriver(IDuccState.JobState prev, IDuccState.JobState next) {
        boolean retVal = false;
        switch (next) {
            case Completing: {
                retVal = true;
                break;
            }
            case Completed: {
                retVal = true;
                break;
            }
            case Assigned: {
                break;
            }
            case Initializing: {
                break;
            }
            case Received: {
                break;
            }
            case Running: {
                break;
            }
            case Undefined: {
                break;
            }
            case WaitingForDriver: {
                break;
            }
            case WaitingForResources: {
                retVal = true;
                break;
            }
            case WaitingForServices: {
                retVal = true;
            }
        }
        return retVal;
    }

    private boolean stateChangeFromWaitingForResources(IDuccState.JobState prev, IDuccState.JobState next) {
        boolean retVal = false;
        switch (next) {
            case Completing: {
                retVal = true;
                break;
            }
            case Completed: {
                retVal = true;
                break;
            }
            case Assigned: {
                retVal = true;
                break;
            }
            case Initializing: {
                retVal = true;
                break;
            }
            case Received: {
                break;
            }
            case Running: {
                break;
            }
            case Undefined: {
                break;
            }
            case WaitingForDriver: {
                break;
            }
            case WaitingForResources: {
                break;
            }
        }
        return retVal;
    }

    private boolean stateChangeFromWaitingForServices(IDuccState.JobState prev, IDuccState.JobState next) {
        boolean retVal = false;
        switch (next) {
            case Completing: {
                retVal = true;
                break;
            }
            case Completed: {
                retVal = true;
                break;
            }
            case Assigned: {
                break;
            }
            case Initializing: {
                break;
            }
            case Received: {
                break;
            }
            case Running: {
                break;
            }
            case Undefined: {
                break;
            }
            case WaitingForDriver: {
                break;
            }
            case WaitingForResources: {
                retVal = true;
                break;
            }
        }
        return retVal;
    }

    public boolean complete(IDuccWorkJob job, IDuccCompletionType.JobCompletionType completionType, IRationale completionRationale) {
        String methodName = "complete";
        boolean retVal = false;
        logger.debug(methodName, job.getDuccId(), new Object[]{job.getCompletionType() + " " + job.getCompletionRationale()});
        switch (job.getCompletionType()) {
            case Undefined: {
                retVal = true;
                break;
            }
        }
        if (retVal) {
            job.setCompletion(completionType, completionRationale);
            logger.info(methodName, job.getDuccId(), new Object[]{completionType + " " + completionRationale});
        } else {
            logger.info(methodName, job.getDuccId(), new Object[]{completionType + " ignored"});
        }
        return retVal;
    }

    private void recordUserState(IDuccWorkJob job) {
        String methodName = "recordUserState";
        String text = "";
        try {
            IDuccState.JobState jobState = job.getJobState();
            if (jobState != null) {
                text = jobState.toString();
                UserLogging.record(job, text);
                logger.debug(methodName, job.getDuccId(), new Object[]{text});
            }
        }
        catch (Exception e) {
            logger.error(methodName, job.getDuccId(), (Throwable)e, new Object[0]);
        }
    }

    private void recordUserCompletion(IDuccWorkJob job) {
        String methodName = "recordUserCompletion";
        String text = "";
        try {
            IRationale rationale;
            IDuccCompletionType.JobCompletionType jobCompletionType = job.getCompletionType();
            if (jobCompletionType != null) {
                text = "completion type: " + jobCompletionType.toString();
                UserLogging.record(job, text);
                logger.debug(methodName, job.getDuccId(), new Object[]{text});
            }
            if ((rationale = job.getCompletionRationale()) != null) {
                text = "rationale: " + rationale.toString();
                UserLogging.record(job, text);
                logger.debug(methodName, job.getDuccId(), new Object[]{text});
            }
        }
        catch (Exception e) {
            logger.error(methodName, job.getDuccId(), (Throwable)e, new Object[0]);
        }
    }
}

