/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.orchestrator.user;

import org.apache.uima.ducc.common.utils.TimeStamp;
import org.apache.uima.ducc.orchestrator.user.DuccAsUser;
import org.apache.uima.ducc.transport.event.common.IDuccWorkJob;

public class UserLogging {
    private static String ducc_log = "ducc.log";
    private static String ducc_error = "ducc.error";

    public static void record(IDuccWorkJob job, String text) {
        UserLogging.write(job, ducc_log, text);
    }

    public static void error(IDuccWorkJob job, String text) {
        UserLogging.write(job, ducc_error, text);
    }

    static void write(IDuccWorkJob job, String fname, String text) {
        if (text != null) {
            String user = job.getStandardInfo().getUser();
            String umask = job.getStandardInfo().getUmask();
            String file = job.getUserLogDir() + fname;
            String millis = "" + System.currentTimeMillis();
            String ts = TimeStamp.simpleFormat((String)millis);
            DuccAsUser.duckling(user, umask, file, ts + " " + text);
        }
    }
}

