/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.store.kahadb;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.activemq.broker.Broker;
import org.apache.activemq.broker.ConnectionContext;
import org.apache.activemq.broker.region.BaseDestination;
import org.apache.activemq.command.Message;
import org.apache.activemq.command.MessageAck;
import org.apache.activemq.command.MessageId;
import org.apache.activemq.command.TransactionId;
import org.apache.activemq.command.XATransactionId;
import org.apache.activemq.store.AbstractMessageStore;
import org.apache.activemq.store.IndexListener;
import org.apache.activemq.store.ListenableFuture;
import org.apache.activemq.store.MessageStore;
import org.apache.activemq.store.PersistenceAdapter;
import org.apache.activemq.store.ProxyMessageStore;
import org.apache.activemq.store.ProxyTopicMessageStore;
import org.apache.activemq.store.TopicMessageStore;
import org.apache.activemq.store.TransactionRecoveryListener;
import org.apache.activemq.store.TransactionStore;
import org.apache.activemq.store.kahadb.FilteredKahaDBPersistenceAdapter;
import org.apache.activemq.store.kahadb.JournalCommand;
import org.apache.activemq.store.kahadb.KahaDBPersistenceAdapter;
import org.apache.activemq.store.kahadb.MultiKahaDBPersistenceAdapter;
import org.apache.activemq.store.kahadb.TransactionIdConversion;
import org.apache.activemq.store.kahadb.data.KahaCommitCommand;
import org.apache.activemq.store.kahadb.data.KahaEntryType;
import org.apache.activemq.store.kahadb.data.KahaPrepareCommand;
import org.apache.activemq.store.kahadb.data.KahaTraceCommand;
import org.apache.activemq.store.kahadb.disk.journal.Journal;
import org.apache.activemq.store.kahadb.disk.journal.Location;
import org.apache.activemq.usage.StoreUsage;
import org.apache.activemq.usage.Usage;
import org.apache.activemq.util.DataByteArrayInputStream;
import org.apache.activemq.util.DataByteArrayOutputStream;
import org.apache.activemq.util.IOHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultiKahaDBTransactionStore
implements TransactionStore {
    static final Logger LOG = LoggerFactory.getLogger(MultiKahaDBTransactionStore.class);
    final MultiKahaDBPersistenceAdapter multiKahaDBPersistenceAdapter;
    final ConcurrentMap<TransactionId, Tx> inflightTransactions = new ConcurrentHashMap<TransactionId, Tx>();
    final Set<TransactionId> recoveredPendingCommit = new HashSet<TransactionId>();
    private Journal journal;
    private int journalMaxFileLength = 0x2000000;
    private int journalWriteBatchSize = 0x400000;
    private final AtomicBoolean started = new AtomicBoolean(false);

    public MultiKahaDBTransactionStore(MultiKahaDBPersistenceAdapter multiKahaDBPersistenceAdapter) {
        this.multiKahaDBPersistenceAdapter = multiKahaDBPersistenceAdapter;
    }

    public MessageStore proxy(final TransactionStore transactionStore, MessageStore messageStore) {
        return new ProxyMessageStore(messageStore){

            public void addMessage(ConnectionContext context, Message send) throws IOException {
                MultiKahaDBTransactionStore.this.addMessage(transactionStore, context, this.getDelegate(), send);
            }

            public void addMessage(ConnectionContext context, Message send, boolean canOptimizeHint) throws IOException {
                MultiKahaDBTransactionStore.this.addMessage(transactionStore, context, this.getDelegate(), send);
            }

            public ListenableFuture<Object> asyncAddQueueMessage(ConnectionContext context, Message message) throws IOException {
                return MultiKahaDBTransactionStore.this.asyncAddQueueMessage(transactionStore, context, this.getDelegate(), message);
            }

            public ListenableFuture<Object> asyncAddQueueMessage(ConnectionContext context, Message message, boolean canOptimizeHint) throws IOException {
                return MultiKahaDBTransactionStore.this.asyncAddQueueMessage(transactionStore, context, this.getDelegate(), message);
            }

            public void removeMessage(ConnectionContext context, MessageAck ack) throws IOException {
                MultiKahaDBTransactionStore.this.removeMessage(transactionStore, context, this.getDelegate(), ack);
            }

            public void removeAsyncMessage(ConnectionContext context, MessageAck ack) throws IOException {
                MultiKahaDBTransactionStore.this.removeAsyncMessage(transactionStore, context, this.getDelegate(), ack);
            }

            public void registerIndexListener(IndexListener indexListener) {
                this.getDelegate().registerIndexListener(indexListener);
                try {
                    FilteredKahaDBPersistenceAdapter filteredAdapter;
                    Object matchingPersistenceAdapter;
                    if (indexListener instanceof BaseDestination && (matchingPersistenceAdapter = MultiKahaDBTransactionStore.this.multiKahaDBPersistenceAdapter.destinationMap.chooseValue(this.getDelegate().getDestination())) instanceof FilteredKahaDBPersistenceAdapter && (filteredAdapter = (FilteredKahaDBPersistenceAdapter)((Object)matchingPersistenceAdapter)).getUsage() != null && filteredAdapter.getPersistenceAdapter() instanceof KahaDBPersistenceAdapter) {
                        StoreUsage storeUsage = filteredAdapter.getUsage();
                        storeUsage.setStore(filteredAdapter.getPersistenceAdapter());
                        storeUsage.setParent((Usage)MultiKahaDBTransactionStore.this.multiKahaDBPersistenceAdapter.getBrokerService().getSystemUsage().getStoreUsage());
                        ((BaseDestination)indexListener).getSystemUsage().setStoreUsage(storeUsage);
                    }
                }
                catch (Exception ignored) {
                    LOG.warn("Failed to set mKahaDB destination store usage", (Throwable)ignored);
                }
            }
        };
    }

    public TopicMessageStore proxy(final TransactionStore transactionStore, TopicMessageStore messageStore) {
        return new ProxyTopicMessageStore(messageStore){

            public void addMessage(ConnectionContext context, Message send, boolean canOptimizeHint) throws IOException {
                MultiKahaDBTransactionStore.this.addMessage(transactionStore, context, this.getDelegate(), send);
            }

            public void addMessage(ConnectionContext context, Message send) throws IOException {
                MultiKahaDBTransactionStore.this.addMessage(transactionStore, context, this.getDelegate(), send);
            }

            public ListenableFuture<Object> asyncAddTopicMessage(ConnectionContext context, Message message, boolean canOptimizeHint) throws IOException {
                return MultiKahaDBTransactionStore.this.asyncAddTopicMessage(transactionStore, context, this.getDelegate(), message);
            }

            public ListenableFuture<Object> asyncAddTopicMessage(ConnectionContext context, Message message) throws IOException {
                return MultiKahaDBTransactionStore.this.asyncAddTopicMessage(transactionStore, context, this.getDelegate(), message);
            }

            public void removeMessage(ConnectionContext context, MessageAck ack) throws IOException {
                MultiKahaDBTransactionStore.this.removeMessage(transactionStore, context, this.getDelegate(), ack);
            }

            public void removeAsyncMessage(ConnectionContext context, MessageAck ack) throws IOException {
                MultiKahaDBTransactionStore.this.removeAsyncMessage(transactionStore, context, this.getDelegate(), ack);
            }

            public void acknowledge(ConnectionContext context, String clientId, String subscriptionName, MessageId messageId, MessageAck ack) throws IOException {
                MultiKahaDBTransactionStore.this.acknowledge(transactionStore, context, (TopicMessageStore)this.getDelegate(), clientId, subscriptionName, messageId, ack);
            }
        };
    }

    public void deleteAllMessages() {
        IOHelper.deleteChildren((File)this.getDirectory());
    }

    public int getJournalMaxFileLength() {
        return this.journalMaxFileLength;
    }

    public void setJournalMaxFileLength(int journalMaxFileLength) {
        this.journalMaxFileLength = journalMaxFileLength;
    }

    public int getJournalMaxWriteBatchSize() {
        return this.journalWriteBatchSize;
    }

    public void setJournalMaxWriteBatchSize(int journalWriteBatchSize) {
        this.journalWriteBatchSize = journalWriteBatchSize;
    }

    public Tx getTx(TransactionId txid) {
        Tx tx = (Tx)this.inflightTransactions.get(txid);
        if (tx == null) {
            tx = new Tx();
            this.inflightTransactions.put(txid, tx);
        }
        return tx;
    }

    public Tx removeTx(TransactionId txid) {
        return (Tx)this.inflightTransactions.remove(txid);
    }

    public void prepare(TransactionId txid) throws IOException {
        Tx tx = this.getTx(txid);
        for (TransactionStore store : tx.getStores()) {
            store.prepare(txid);
        }
    }

    public void commit(TransactionId txid, boolean wasPrepared, Runnable preCommit, Runnable postCommit) throws IOException {
        if (preCommit != null) {
            preCommit.run();
        }
        Tx tx = this.getTx(txid);
        if (wasPrepared) {
            for (TransactionStore store : tx.getStores()) {
                store.commit(txid, true, null, null);
            }
        } else if (tx.getStores().size() == 1) {
            for (TransactionStore store : tx.getStores()) {
                store.commit(txid, false, null, null);
            }
        } else {
            for (TransactionStore store : tx.getStores()) {
                store.prepare(txid);
            }
            this.persistOutcome(tx, txid);
            for (TransactionStore store : tx.getStores()) {
                store.commit(txid, true, null, null);
            }
            this.persistCompletion(txid);
        }
        this.removeTx(txid);
        if (postCommit != null) {
            postCommit.run();
        }
    }

    public void persistOutcome(Tx tx, TransactionId txid) throws IOException {
        tx.trackPrepareLocation(this.store((JournalCommand)new KahaPrepareCommand().setTransactionInfo(TransactionIdConversion.convert(this.multiKahaDBPersistenceAdapter.transactionIdTransformer.transform(txid)))));
    }

    public void persistCompletion(TransactionId txid) throws IOException {
        this.store((JournalCommand)new KahaCommitCommand().setTransactionInfo(TransactionIdConversion.convert(this.multiKahaDBPersistenceAdapter.transactionIdTransformer.transform(txid))));
    }

    private Location store(JournalCommand<?> data) throws IOException {
        int size = data.serializedSizeFramed();
        DataByteArrayOutputStream os = new DataByteArrayOutputStream(size + 1);
        os.writeByte(data.type().getNumber());
        data.writeFramed((OutputStream)os);
        Location location = this.journal.write(os.toByteSequence(), true);
        this.journal.setLastAppendLocation(location);
        return location;
    }

    public void rollback(TransactionId txid) throws IOException {
        Tx tx = this.removeTx(txid);
        if (tx != null) {
            for (TransactionStore store : tx.getStores()) {
                store.rollback(txid);
            }
        }
    }

    public void start() throws Exception {
        if (this.started.compareAndSet(false, true)) {
            this.journal = new Journal(){

                @Override
                public void cleanup() {
                    super.cleanup();
                    MultiKahaDBTransactionStore.this.txStoreCleanup();
                }
            };
            this.journal.setDirectory(this.getDirectory());
            this.journal.setMaxFileLength(this.journalMaxFileLength);
            this.journal.setWriteBatchSize(this.journalWriteBatchSize);
            IOHelper.mkdirs((File)this.journal.getDirectory());
            this.journal.start();
            this.recoverPendingLocalTransactions();
            this.store((JournalCommand)new KahaTraceCommand().setMessage("LOADED " + new Date()));
        }
    }

    private void txStoreCleanup() {
        TreeSet<Integer> knownDataFileIds = new TreeSet<Integer>(this.journal.getFileMap().keySet());
        for (Tx tx : this.inflightTransactions.values()) {
            knownDataFileIds.remove(tx.getPreparedLocationId());
        }
        try {
            this.journal.removeDataFiles(knownDataFileIds);
        }
        catch (Exception e) {
            LOG.error(this + ", Failed to remove tx journal datafiles " + knownDataFileIds);
        }
    }

    private File getDirectory() {
        return new File(this.multiKahaDBPersistenceAdapter.getDirectory(), "txStore");
    }

    public void stop() throws Exception {
        if (this.started.compareAndSet(true, false) && this.journal != null) {
            this.journal.close();
            this.journal = null;
        }
    }

    private void recoverPendingLocalTransactions() throws IOException {
        Location location = this.journal.getNextLocation(null);
        while (location != null) {
            this.process(this.load(location));
            location = this.journal.getNextLocation(location);
        }
        this.recoveredPendingCommit.addAll(this.inflightTransactions.keySet());
        LOG.info("pending local transactions: " + this.recoveredPendingCommit);
    }

    public JournalCommand<?> load(Location location) throws IOException {
        DataByteArrayInputStream is = new DataByteArrayInputStream(this.journal.read(location));
        byte readByte = is.readByte();
        KahaEntryType type = KahaEntryType.valueOf(readByte);
        if (type == null) {
            throw new IOException("Could not load journal record. Invalid location: " + location);
        }
        JournalCommand message = (JournalCommand)type.createMessage();
        message.mergeFramed((InputStream)is);
        return message;
    }

    public void process(JournalCommand<?> command) throws IOException {
        switch (command.type()) {
            case KAHA_PREPARE_COMMAND: {
                KahaPrepareCommand prepareCommand = (KahaPrepareCommand)command;
                this.getTx(TransactionIdConversion.convert(prepareCommand.getTransactionInfo()));
                break;
            }
            case KAHA_COMMIT_COMMAND: {
                KahaCommitCommand commitCommand = (KahaCommitCommand)command;
                this.removeTx(TransactionIdConversion.convert(commitCommand.getTransactionInfo()));
                break;
            }
            case KAHA_TRACE_COMMAND: {
                break;
            }
            default: {
                throw new IOException("Unexpected command in transaction journal: " + command);
            }
        }
    }

    public synchronized void recover(final TransactionRecoveryListener listener) throws IOException {
        for (final PersistenceAdapter adapter : this.multiKahaDBPersistenceAdapter.adapters) {
            adapter.createTransactionStore().recover(new TransactionRecoveryListener(){

                public void recover(XATransactionId xid, Message[] addedMessages, MessageAck[] acks) {
                    try {
                        MultiKahaDBTransactionStore.this.getTx((TransactionId)xid).trackStore(adapter.createTransactionStore());
                    }
                    catch (IOException e) {
                        LOG.error("Failed to access transaction store: " + adapter + " for prepared xa tid: " + xid, (Throwable)e);
                    }
                    listener.recover(xid, addedMessages, acks);
                }
            });
        }
        try {
            Broker broker = this.multiKahaDBPersistenceAdapter.getBrokerService().getBroker();
            for (TransactionId txid : broker.getPreparedTransactions(null)) {
                if (!this.multiKahaDBPersistenceAdapter.isLocalXid(txid)) continue;
                try {
                    if (this.recoveredPendingCommit.contains(txid)) {
                        LOG.info("delivering pending commit outcome for tid: " + txid);
                        broker.commitTransaction(null, txid, false);
                    } else {
                        LOG.info("delivering rollback outcome to store for tid: " + txid);
                        broker.forgetTransaction(null, txid);
                    }
                    this.persistCompletion(txid);
                }
                catch (Exception ex) {
                    LOG.error("failed to deliver pending outcome for tid: " + txid, (Throwable)ex);
                }
            }
        }
        catch (Exception e) {
            LOG.error("failed to resolve pending local transactions", (Throwable)e);
        }
    }

    void addMessage(TransactionStore transactionStore, ConnectionContext context, MessageStore destination, Message message) throws IOException {
        if (message.getTransactionId() != null) {
            this.getTx(message.getTransactionId()).trackStore(transactionStore);
        }
        destination.addMessage(context, message);
    }

    ListenableFuture<Object> asyncAddQueueMessage(TransactionStore transactionStore, ConnectionContext context, MessageStore destination, Message message) throws IOException {
        if (message.getTransactionId() != null) {
            this.getTx(message.getTransactionId()).trackStore(transactionStore);
            destination.addMessage(context, message);
            return AbstractMessageStore.FUTURE;
        }
        return destination.asyncAddQueueMessage(context, message);
    }

    ListenableFuture<Object> asyncAddTopicMessage(TransactionStore transactionStore, ConnectionContext context, MessageStore destination, Message message) throws IOException {
        if (message.getTransactionId() != null) {
            this.getTx(message.getTransactionId()).trackStore(transactionStore);
            destination.addMessage(context, message);
            return AbstractMessageStore.FUTURE;
        }
        return destination.asyncAddTopicMessage(context, message);
    }

    final void removeMessage(TransactionStore transactionStore, ConnectionContext context, MessageStore destination, MessageAck ack) throws IOException {
        if (ack.getTransactionId() != null) {
            this.getTx(ack.getTransactionId()).trackStore(transactionStore);
        }
        destination.removeMessage(context, ack);
    }

    final void removeAsyncMessage(TransactionStore transactionStore, ConnectionContext context, MessageStore destination, MessageAck ack) throws IOException {
        if (ack.getTransactionId() != null) {
            this.getTx(ack.getTransactionId()).trackStore(transactionStore);
        }
        destination.removeAsyncMessage(context, ack);
    }

    final void acknowledge(TransactionStore transactionStore, ConnectionContext context, TopicMessageStore destination, String clientId, String subscriptionName, MessageId messageId, MessageAck ack) throws IOException {
        if (ack.getTransactionId() != null) {
            this.getTx(ack.getTransactionId()).trackStore(transactionStore);
        }
        destination.acknowledge(context, clientId, subscriptionName, messageId, ack);
    }

    public class Tx {
        private final Set<TransactionStore> stores = new HashSet<TransactionStore>();
        private int prepareLocationId = 0;

        public void trackStore(TransactionStore store) {
            this.stores.add(store);
        }

        public Set<TransactionStore> getStores() {
            return this.stores;
        }

        public void trackPrepareLocation(Location location) {
            this.prepareLocationId = location.getDataFileId();
        }

        public int getPreparedLocationId() {
            return this.prepareLocationId;
        }
    }
}

