/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.net;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.IOError;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.net.BindException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.nio.channels.AsynchronousCloseException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.ServerSocketChannel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.net.ssl.SSLHandshakeException;
import org.apache.cassandra.batchlog.Batch;
import org.apache.cassandra.concurrent.ExecutorLocals;
import org.apache.cassandra.concurrent.LocalAwareExecutorService;
import org.apache.cassandra.concurrent.ScheduledExecutors;
import org.apache.cassandra.concurrent.Stage;
import org.apache.cassandra.concurrent.StageManager;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.config.EncryptionOptions;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.ConsistencyLevel;
import org.apache.cassandra.db.CounterMutation;
import org.apache.cassandra.db.IMutation;
import org.apache.cassandra.db.Keyspace;
import org.apache.cassandra.db.Mutation;
import org.apache.cassandra.db.ReadCommand;
import org.apache.cassandra.db.ReadResponse;
import org.apache.cassandra.db.SnapshotCommand;
import org.apache.cassandra.db.TruncateResponse;
import org.apache.cassandra.db.Truncation;
import org.apache.cassandra.db.WriteResponse;
import org.apache.cassandra.dht.AbstractBounds;
import org.apache.cassandra.dht.BootStrapper;
import org.apache.cassandra.dht.IPartitioner;
import org.apache.cassandra.exceptions.ConfigurationException;
import org.apache.cassandra.exceptions.RequestFailureReason;
import org.apache.cassandra.gms.EchoMessage;
import org.apache.cassandra.gms.GossipDigestAck;
import org.apache.cassandra.gms.GossipDigestAck2;
import org.apache.cassandra.gms.GossipDigestSyn;
import org.apache.cassandra.hints.HintMessage;
import org.apache.cassandra.hints.HintResponse;
import org.apache.cassandra.io.IVersionedSerializer;
import org.apache.cassandra.io.util.DataInputPlus;
import org.apache.cassandra.io.util.DataOutputPlus;
import org.apache.cassandra.io.util.FileUtils;
import org.apache.cassandra.locator.ILatencySubscriber;
import org.apache.cassandra.metrics.CassandraMetricsRegistry;
import org.apache.cassandra.metrics.ConnectionMetrics;
import org.apache.cassandra.metrics.DroppedMessageMetrics;
import org.apache.cassandra.metrics.MessagingMetrics;
import org.apache.cassandra.net.AsyncOneResponse;
import org.apache.cassandra.net.BackPressureState;
import org.apache.cassandra.net.BackPressureStrategy;
import org.apache.cassandra.net.CallbackInfo;
import org.apache.cassandra.net.IAsyncCallback;
import org.apache.cassandra.net.IAsyncCallbackWithFailure;
import org.apache.cassandra.net.IMessageSink;
import org.apache.cassandra.net.IVerbHandler;
import org.apache.cassandra.net.IncomingStreamingConnection;
import org.apache.cassandra.net.IncomingTcpConnection;
import org.apache.cassandra.net.MessageDeliveryTask;
import org.apache.cassandra.net.MessageIn;
import org.apache.cassandra.net.MessageOut;
import org.apache.cassandra.net.MessagingServiceMBean;
import org.apache.cassandra.net.OutboundTcpConnection;
import org.apache.cassandra.net.OutboundTcpConnectionPool;
import org.apache.cassandra.net.PingMessage;
import org.apache.cassandra.net.WriteCallbackInfo;
import org.apache.cassandra.repair.messages.RepairMessage;
import org.apache.cassandra.security.SSLFactory;
import org.apache.cassandra.service.AbstractWriteResponseHandler;
import org.apache.cassandra.service.MigrationManager;
import org.apache.cassandra.service.StorageProxy;
import org.apache.cassandra.service.StorageService;
import org.apache.cassandra.service.paxos.Commit;
import org.apache.cassandra.service.paxos.PrepareResponse;
import org.apache.cassandra.tracing.TraceState;
import org.apache.cassandra.tracing.Tracing;
import org.apache.cassandra.utils.BooleanSerializer;
import org.apache.cassandra.utils.ExpiringMap;
import org.apache.cassandra.utils.FBUtilities;
import org.apache.cassandra.utils.Pair;
import org.apache.cassandra.utils.StatusLogger;
import org.apache.cassandra.utils.UUIDSerializer;
import org.apache.cassandra.utils.concurrent.SimpleCondition;
import org.cliffc.high_scale_lib.NonBlockingHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MessagingService
implements MessagingServiceMBean {
    public static final boolean FORCE_3_0_PROTOCOL_VERSION = Boolean.getBoolean("cassandra.force_3_0_protocol_version");
    public static final String MBEAN_NAME = "org.apache.cassandra.net:type=MessagingService";
    public static final int VERSION_12 = 6;
    public static final int VERSION_20 = 7;
    public static final int VERSION_21 = 8;
    public static final int VERSION_22 = 9;
    public static final int VERSION_30 = 10;
    public static final int VERSION_3014 = 11;
    public static final int current_version = FORCE_3_0_PROTOCOL_VERSION ? 10 : 11;
    public static final String FAILURE_CALLBACK_PARAM = "CAL_BAC";
    public static final byte[] ONE_BYTE = new byte[1];
    public static final String FAILURE_RESPONSE_PARAM = "FAIL";
    public static final String FAILURE_REASON_PARAM = "FAIL_REASON";
    public static final int PROTOCOL_MAGIC = -900387334;
    private boolean allNodesAtLeast22 = true;
    private boolean allNodesAtLeast30 = true;
    public final MessagingMetrics metrics = new MessagingMetrics();
    public static final Verb[] verbValues = Verb.values();
    public static final EnumMap<Verb, Stage> verbStages = new EnumMap<Verb, Stage>(Verb.class){
        {
            this.put(Verb.MUTATION, Stage.MUTATION);
            this.put(Verb.COUNTER_MUTATION, Stage.COUNTER_MUTATION);
            this.put(Verb.READ_REPAIR, Stage.MUTATION);
            this.put(Verb.HINT, Stage.MUTATION);
            this.put(Verb.TRUNCATE, Stage.MUTATION);
            this.put(Verb.PAXOS_PREPARE, Stage.MUTATION);
            this.put(Verb.PAXOS_PROPOSE, Stage.MUTATION);
            this.put(Verb.PAXOS_COMMIT, Stage.MUTATION);
            this.put(Verb.BATCH_STORE, Stage.MUTATION);
            this.put(Verb.BATCH_REMOVE, Stage.MUTATION);
            this.put(Verb.READ, Stage.READ);
            this.put(Verb.RANGE_SLICE, Stage.READ);
            this.put(Verb.INDEX_SCAN, Stage.READ);
            this.put(Verb.PAGED_RANGE, Stage.READ);
            this.put(Verb.REQUEST_RESPONSE, Stage.REQUEST_RESPONSE);
            this.put(Verb.INTERNAL_RESPONSE, Stage.INTERNAL_RESPONSE);
            this.put(Verb.STREAM_REPLY, Stage.MISC);
            this.put(Verb.STREAM_REQUEST, Stage.MISC);
            this.put(Verb.REPLICATION_FINISHED, Stage.MISC);
            this.put(Verb.SNAPSHOT, Stage.MISC);
            this.put(Verb.TREE_REQUEST, Stage.ANTI_ENTROPY);
            this.put(Verb.TREE_RESPONSE, Stage.ANTI_ENTROPY);
            this.put(Verb.STREAMING_REPAIR_REQUEST, Stage.ANTI_ENTROPY);
            this.put(Verb.STREAMING_REPAIR_RESPONSE, Stage.ANTI_ENTROPY);
            this.put(Verb.REPAIR_MESSAGE, Stage.ANTI_ENTROPY);
            this.put(Verb.GOSSIP_DIGEST_ACK, Stage.GOSSIP);
            this.put(Verb.GOSSIP_DIGEST_ACK2, Stage.GOSSIP);
            this.put(Verb.GOSSIP_DIGEST_SYN, Stage.GOSSIP);
            this.put(Verb.GOSSIP_SHUTDOWN, Stage.GOSSIP);
            this.put(Verb.DEFINITIONS_UPDATE, Stage.MIGRATION);
            this.put(Verb.SCHEMA_CHECK, Stage.MIGRATION);
            this.put(Verb.MIGRATION_REQUEST, Stage.MIGRATION);
            this.put(Verb.INDEX_SCAN, Stage.READ);
            this.put(Verb.REPLICATION_FINISHED, Stage.MISC);
            this.put(Verb.SNAPSHOT, Stage.MISC);
            this.put(Verb.ECHO, Stage.GOSSIP);
            this.put(Verb.UNUSED_2, Stage.INTERNAL_RESPONSE);
            this.put(Verb.UNUSED_3, Stage.INTERNAL_RESPONSE);
            this.put(Verb.PING, Stage.READ);
        }
    };
    public final EnumMap<Verb, IVersionedSerializer<?>> verbSerializers = new EnumMap<Verb, IVersionedSerializer<?>>(Verb.class){
        {
            this.put(Verb.REQUEST_RESPONSE, CallbackDeterminedSerializer.instance);
            this.put(Verb.INTERNAL_RESPONSE, CallbackDeterminedSerializer.instance);
            this.put(Verb.MUTATION, Mutation.serializer);
            this.put(Verb.READ_REPAIR, Mutation.serializer);
            this.put(Verb.READ, ReadCommand.readSerializer);
            this.put(Verb.RANGE_SLICE, ReadCommand.rangeSliceSerializer);
            this.put(Verb.PAGED_RANGE, ReadCommand.pagedRangeSerializer);
            this.put(Verb.BOOTSTRAP_TOKEN, BootStrapper.StringSerializer.instance);
            this.put(Verb.REPAIR_MESSAGE, RepairMessage.serializer);
            this.put(Verb.GOSSIP_DIGEST_ACK, GossipDigestAck.serializer);
            this.put(Verb.GOSSIP_DIGEST_ACK2, GossipDigestAck2.serializer);
            this.put(Verb.GOSSIP_DIGEST_SYN, GossipDigestSyn.serializer);
            this.put(Verb.DEFINITIONS_UPDATE, MigrationManager.MigrationsSerializer.instance);
            this.put(Verb.TRUNCATE, Truncation.serializer);
            this.put(Verb.REPLICATION_FINISHED, null);
            this.put(Verb.COUNTER_MUTATION, CounterMutation.serializer);
            this.put(Verb.SNAPSHOT, SnapshotCommand.serializer);
            this.put(Verb.ECHO, EchoMessage.serializer);
            this.put(Verb.PAXOS_PREPARE, Commit.serializer);
            this.put(Verb.PAXOS_PROPOSE, Commit.serializer);
            this.put(Verb.PAXOS_COMMIT, Commit.serializer);
            this.put(Verb.HINT, HintMessage.serializer);
            this.put(Verb.BATCH_STORE, Batch.serializer);
            this.put(Verb.BATCH_REMOVE, UUIDSerializer.serializer);
            this.put(Verb.PING, PingMessage.serializer);
        }
    };
    public static final EnumMap<Verb, IVersionedSerializer<?>> callbackDeserializers = new EnumMap<Verb, IVersionedSerializer<?>>(Verb.class){
        {
            this.put(Verb.MUTATION, WriteResponse.serializer);
            this.put(Verb.HINT, HintResponse.serializer);
            this.put(Verb.READ_REPAIR, WriteResponse.serializer);
            this.put(Verb.COUNTER_MUTATION, WriteResponse.serializer);
            this.put(Verb.RANGE_SLICE, ReadResponse.rangeSliceSerializer);
            this.put(Verb.PAGED_RANGE, ReadResponse.rangeSliceSerializer);
            this.put(Verb.READ, ReadResponse.serializer);
            this.put(Verb.TRUNCATE, TruncateResponse.serializer);
            this.put(Verb.SNAPSHOT, null);
            this.put(Verb.MIGRATION_REQUEST, MigrationManager.MigrationsSerializer.instance);
            this.put(Verb.SCHEMA_CHECK, UUIDSerializer.serializer);
            this.put(Verb.BOOTSTRAP_TOKEN, BootStrapper.StringSerializer.instance);
            this.put(Verb.REPLICATION_FINISHED, null);
            this.put(Verb.PAXOS_PREPARE, PrepareResponse.serializer);
            this.put(Verb.PAXOS_PROPOSE, BooleanSerializer.serializer);
            this.put(Verb.BATCH_STORE, WriteResponse.serializer);
            this.put(Verb.BATCH_REMOVE, WriteResponse.serializer);
        }
    };
    private final ExpiringMap<Integer, CallbackInfo> callbacks;
    private final Map<Verb, IVerbHandler> verbHandlers;
    private final ConcurrentMap<InetAddress, OutboundTcpConnectionPool> connectionManagers = new NonBlockingHashMap();
    private static final Logger logger = LoggerFactory.getLogger(MessagingService.class);
    private static final int LOG_DROPPED_INTERVAL_IN_MS = 5000;
    private final List<SocketThread> socketThreads = Lists.newArrayList();
    private final SimpleCondition listenGate;
    public static final EnumSet<Verb> DROPPABLE_VERBS = EnumSet.of(Verb._TRACE, new Verb[]{Verb.MUTATION, Verb.COUNTER_MUTATION, Verb.HINT, Verb.READ_REPAIR, Verb.READ, Verb.RANGE_SLICE, Verb.PAGED_RANGE, Verb.REQUEST_RESPONSE, Verb.BATCH_STORE, Verb.BATCH_REMOVE});
    private final Map<Verb, DroppedMessages> droppedMessagesMap = new EnumMap<Verb, DroppedMessages>(Verb.class);
    private final List<ILatencySubscriber> subscribers = new ArrayList<ILatencySubscriber>();
    private final ConcurrentMap<InetAddress, Integer> versions = new NonBlockingHashMap();
    private final Set<IMessageSink> messageSinks = new CopyOnWriteArraySet<IMessageSink>();
    private final BackPressureStrategy backPressure = DatabaseDescriptor.getBackPressureStrategy();
    private static final AtomicInteger idGen = new AtomicInteger(0);

    @VisibleForTesting
    public void resetDroppedMessagesMap(String scope) {
        for (Verb verb : this.droppedMessagesMap.keySet()) {
            this.droppedMessagesMap.put(verb, new DroppedMessages(new DroppedMessageMetrics(metricName -> new CassandraMetricsRegistry.MetricName("DroppedMessages", metricName, scope))));
        }
    }

    public static MessagingService instance() {
        return MSHandle.instance;
    }

    static MessagingService test() {
        return MSTestHandle.instance;
    }

    private MessagingService(boolean testOnly) {
        for (Verb verb : DROPPABLE_VERBS) {
            this.droppedMessagesMap.put(verb, new DroppedMessages(verb));
        }
        this.listenGate = new SimpleCondition();
        this.verbHandlers = new EnumMap<Verb, IVerbHandler>(Verb.class);
        if (!testOnly) {
            Runnable logDropped = new Runnable(){

                @Override
                public void run() {
                    MessagingService.this.logDroppedMessages();
                }
            };
            ScheduledExecutors.scheduledTasks.scheduleWithFixedDelay(logDropped, 5000L, 5000L, TimeUnit.MILLISECONDS);
        }
        Function<Pair<Integer, ExpiringMap.CacheableObject<CallbackInfo>>, Object> timeoutReporter = new Function<Pair<Integer, ExpiringMap.CacheableObject<CallbackInfo>>, Object>(){

            public Object apply(Pair<Integer, ExpiringMap.CacheableObject<CallbackInfo>> pair) {
                final CallbackInfo expiredCallbackInfo = (CallbackInfo)((ExpiringMap.CacheableObject)pair.right).value;
                MessagingService.this.maybeAddLatency(expiredCallbackInfo.callback, expiredCallbackInfo.target, ((ExpiringMap.CacheableObject)pair.right).timeout);
                ConnectionMetrics.totalTimeouts.mark();
                MessagingService.this.getConnectionPool(expiredCallbackInfo.target).incrementTimeout();
                if (expiredCallbackInfo.callback.supportsBackPressure()) {
                    MessagingService.this.updateBackPressureOnReceive(expiredCallbackInfo.target, expiredCallbackInfo.callback, true);
                }
                if (expiredCallbackInfo.isFailureCallback()) {
                    StageManager.getStage(Stage.INTERNAL_RESPONSE).submit(new Runnable(){

                        @Override
                        public void run() {
                            ((IAsyncCallbackWithFailure)expiredCallbackInfo.callback).onFailure(expiredCallbackInfo.target, RequestFailureReason.UNKNOWN);
                        }
                    });
                }
                if (expiredCallbackInfo.shouldHint()) {
                    Mutation mutation = ((WriteCallbackInfo)expiredCallbackInfo).mutation();
                    return StorageProxy.submitHint(mutation, expiredCallbackInfo.target, null);
                }
                return null;
            }
        };
        this.callbacks = new ExpiringMap<Integer, CallbackInfo>(DatabaseDescriptor.getMinRpcTimeout(), timeoutReporter);
        if (!testOnly) {
            MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
            try {
                mbs.registerMBean(this, new ObjectName(MBEAN_NAME));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    public void addMessageSink(IMessageSink sink) {
        this.messageSinks.add(sink);
    }

    public void removeMessageSink(IMessageSink sink) {
        this.messageSinks.remove(sink);
    }

    public void clearMessageSinks() {
        this.messageSinks.clear();
    }

    public void updateBackPressureOnSend(InetAddress host, IAsyncCallback callback, MessageOut<?> message) {
        if (DatabaseDescriptor.backPressureEnabled() && callback.supportsBackPressure()) {
            BackPressureState backPressureState = this.getConnectionPool(host).getBackPressureState();
            backPressureState.onMessageSent(message);
        }
    }

    public void updateBackPressureOnReceive(InetAddress host, IAsyncCallback callback, boolean timeout) {
        if (DatabaseDescriptor.backPressureEnabled() && callback.supportsBackPressure()) {
            BackPressureState backPressureState = this.getConnectionPool(host).getBackPressureState();
            if (!timeout) {
                backPressureState.onResponseReceived();
            } else {
                backPressureState.onResponseTimeout();
            }
        }
    }

    public void applyBackPressure(Iterable<InetAddress> hosts, long timeoutInNanos) {
        if (DatabaseDescriptor.backPressureEnabled()) {
            this.backPressure.apply(StreamSupport.stream(hosts.spliterator(), false).filter(h -> !h.equals(FBUtilities.getBroadcastAddress())).map(h -> this.getConnectionPool((InetAddress)h).getBackPressureState()).collect(Collectors.toSet()), timeoutInNanos, TimeUnit.NANOSECONDS);
        }
    }

    public void maybeAddLatency(IAsyncCallback cb, InetAddress address, long latency) {
        if (cb.isLatencyForSnitch()) {
            this.addLatency(address, latency);
        }
    }

    public void addLatency(InetAddress address, long latency) {
        for (ILatencySubscriber subscriber : this.subscribers) {
            subscriber.receiveTiming(address, latency);
        }
    }

    public void convict(InetAddress ep) {
        logger.trace("Resetting pool for {}", (Object)ep);
        this.getConnectionPool(ep).reset();
    }

    public void listen() {
        this.callbacks.reset();
        this.listen(FBUtilities.getLocalAddress());
        if (DatabaseDescriptor.shouldListenOnBroadcastAddress() && !FBUtilities.getLocalAddress().equals(FBUtilities.getBroadcastAddress())) {
            this.listen(FBUtilities.getBroadcastAddress());
        }
        this.listenGate.signalAll();
    }

    private void listen(InetAddress localEp) throws ConfigurationException {
        for (ServerSocket ss : this.getServerSockets(localEp)) {
            SocketThread th = new SocketThread(ss, "ACCEPT-" + localEp);
            th.start();
            this.socketThreads.add(th);
        }
    }

    private List<ServerSocket> getServerSockets(InetAddress localEp) throws ConfigurationException {
        ArrayList<ServerSocket> ss = new ArrayList<ServerSocket>(2);
        if (DatabaseDescriptor.getServerEncryptionOptions().internode_encryption != EncryptionOptions.ServerEncryptionOptions.InternodeEncryption.none) {
            try {
                ss.add(SSLFactory.getServerSocket(DatabaseDescriptor.getServerEncryptionOptions(), localEp, DatabaseDescriptor.getSSLStoragePort()));
            }
            catch (IOException e) {
                throw new ConfigurationException("Unable to create ssl socket", e);
            }
            logger.info("Starting Encrypted Messaging Service on SSL port {}", (Object)DatabaseDescriptor.getSSLStoragePort());
        }
        if (DatabaseDescriptor.getServerEncryptionOptions().internode_encryption != EncryptionOptions.ServerEncryptionOptions.InternodeEncryption.all) {
            ServerSocketChannel serverChannel = null;
            try {
                serverChannel = ServerSocketChannel.open();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            ServerSocket socket = serverChannel.socket();
            try {
                socket.setReuseAddress(true);
            }
            catch (SocketException e) {
                FileUtils.closeQuietly(socket);
                throw new ConfigurationException("Insufficient permissions to setReuseAddress", e);
            }
            InetSocketAddress address = new InetSocketAddress(localEp, DatabaseDescriptor.getStoragePort());
            try {
                socket.bind(address, 500);
            }
            catch (BindException e) {
                FileUtils.closeQuietly(socket);
                if (e.getMessage().contains("in use")) {
                    throw new ConfigurationException(address + " is in use by another process.  Change listen_address:storage_port in cassandra.yaml to values that do not conflict with other services");
                }
                if (e.getMessage().contains("Cannot assign requested address")) {
                    throw new ConfigurationException("Unable to bind to address " + address + ". Set listen_address in cassandra.yaml to an interface you can bind to, e.g., your private IP address on EC2");
                }
                throw new RuntimeException(e);
            }
            catch (IOException e) {
                FileUtils.closeQuietly(socket);
                throw new RuntimeException(e);
            }
            String nic = FBUtilities.getNetworkInterface(localEp);
            logger.info("Starting Messaging Service on {}:{}{}", new Object[]{localEp, DatabaseDescriptor.getStoragePort(), nic == null ? "" : String.format(" (%s)", nic)});
            ss.add(socket);
        }
        return ss;
    }

    public void waitUntilListening() {
        try {
            this.listenGate.await();
        }
        catch (InterruptedException ie) {
            logger.trace("await interrupted");
        }
    }

    public boolean isListening() {
        return this.listenGate.isSignaled();
    }

    public void destroyConnectionPool(InetAddress to) {
        OutboundTcpConnectionPool cp = (OutboundTcpConnectionPool)this.connectionManagers.get(to);
        if (cp == null) {
            return;
        }
        cp.close();
        this.connectionManagers.remove(to);
    }

    public OutboundTcpConnectionPool getConnectionPool(InetAddress to) {
        OutboundTcpConnectionPool cp = (OutboundTcpConnectionPool)this.connectionManagers.get(to);
        if (cp == null) {
            cp = new OutboundTcpConnectionPool(to, (BackPressureState)this.backPressure.newState(to));
            OutboundTcpConnectionPool existingPool = this.connectionManagers.putIfAbsent(to, cp);
            if (existingPool != null) {
                cp = existingPool;
            } else {
                cp.start();
            }
        }
        cp.waitForStarted();
        return cp;
    }

    public OutboundTcpConnection getConnection(InetAddress to, MessageOut msg) {
        return this.getConnectionPool(to).getConnection(msg);
    }

    public void registerVerbHandlers(Verb verb, IVerbHandler verbHandler) {
        assert (!this.verbHandlers.containsKey((Object)verb));
        this.verbHandlers.put(verb, verbHandler);
    }

    public IVerbHandler getVerbHandler(Verb type) {
        return this.verbHandlers.get((Object)type);
    }

    public int addCallback(IAsyncCallback cb, MessageOut message, InetAddress to, long timeout, boolean failureCallback) {
        assert (message.verb != Verb.MUTATION);
        int messageId = MessagingService.nextId();
        CallbackInfo previous = this.callbacks.put(messageId, new CallbackInfo(to, cb, callbackDeserializers.get((Object)message.verb), failureCallback), timeout);
        assert (previous == null) : String.format("Callback already exists for id %d! (%s)", messageId, previous);
        return messageId;
    }

    public int addCallback(IAsyncCallback cb, MessageOut<?> message, InetAddress to, long timeout, ConsistencyLevel consistencyLevel, boolean allowHints) {
        assert (message.verb == Verb.MUTATION || message.verb == Verb.COUNTER_MUTATION || message.verb == Verb.PAXOS_COMMIT);
        int messageId = MessagingService.nextId();
        CallbackInfo previous = this.callbacks.put(messageId, new WriteCallbackInfo(to, cb, message, callbackDeserializers.get((Object)message.verb), consistencyLevel, allowHints), timeout);
        assert (previous == null) : String.format("Callback already exists for id %d! (%s)", messageId, previous);
        return messageId;
    }

    private static int nextId() {
        return idGen.incrementAndGet();
    }

    public int sendRR(MessageOut message, InetAddress to, IAsyncCallback cb) {
        return this.sendRR(message, to, cb, message.getTimeout(), false);
    }

    public int sendRRWithFailure(MessageOut message, InetAddress to, IAsyncCallbackWithFailure cb) {
        return this.sendRR(message, to, cb, message.getTimeout(), true);
    }

    public int sendRR(MessageOut message, InetAddress to, IAsyncCallback cb, long timeout, boolean failureCallback) {
        int id = this.addCallback(cb, message, to, timeout, failureCallback);
        this.updateBackPressureOnSend(to, cb, message);
        this.sendOneWay(failureCallback ? message.withParameter(FAILURE_CALLBACK_PARAM, ONE_BYTE) : message, id, to);
        return id;
    }

    public int sendRR(MessageOut<?> message, InetAddress to, AbstractWriteResponseHandler<?> handler, boolean allowHints) {
        int id = this.addCallback(handler, message, to, message.getTimeout(), handler.consistencyLevel, allowHints);
        this.updateBackPressureOnSend(to, handler, message);
        this.sendOneWay(message.withParameter(FAILURE_CALLBACK_PARAM, ONE_BYTE), id, to);
        return id;
    }

    public void sendOneWay(MessageOut message, InetAddress to) {
        this.sendOneWay(message, MessagingService.nextId(), to);
    }

    public void sendReply(MessageOut message, int id, InetAddress to) {
        this.sendOneWay(message, id, to);
    }

    public void sendOneWay(MessageOut message, int id, InetAddress to) {
        if (logger.isTraceEnabled()) {
            logger.trace("{} sending {} to {}@{}", new Object[]{FBUtilities.getBroadcastAddress(), message.verb, id, to});
        }
        if (to.equals(FBUtilities.getBroadcastAddress())) {
            logger.trace("Message-to-self {} going over MessagingService", (Object)message);
        }
        for (IMessageSink ms : this.messageSinks) {
            if (ms.allowOutgoingMessage(message, id, to)) continue;
            return;
        }
        OutboundTcpConnection connection = this.getConnection(to, message);
        connection.enqueue(message, id);
    }

    public <T> AsyncOneResponse<T> sendRR(MessageOut message, InetAddress to) {
        AsyncOneResponse iar = new AsyncOneResponse();
        this.sendRR(message, to, iar);
        return iar;
    }

    public void register(ILatencySubscriber subcriber) {
        this.subscribers.add(subcriber);
    }

    public void clearCallbacksUnsafe() {
        this.callbacks.reset();
    }

    public void shutdown() {
        logger.info("Waiting for messaging service to quiesce");
        assert (!StageManager.getStage(Stage.MUTATION).isShutdown());
        if (!this.callbacks.shutdownBlocking()) {
            logger.warn("Failed to wait for messaging service callbacks shutdown");
        }
        try {
            for (SocketThread th : this.socketThreads) {
                try {
                    th.close();
                }
                catch (IOException e) {
                    MessagingService.handleIOExceptionOnClose(e);
                }
            }
        }
        catch (IOException e) {
            throw new IOError(e);
        }
    }

    public void receive(MessageIn message, int id) {
        TraceState state = Tracing.instance.initializeFromMessage(message);
        if (state != null) {
            state.trace("{} message received from {}", (Object)message.verb, message.from);
        }
        for (IMessageSink ms : this.messageSinks) {
            if (ms.allowIncomingMessage(message, id)) continue;
            return;
        }
        MessageDeliveryTask runnable = new MessageDeliveryTask(message, id);
        LocalAwareExecutorService stage = StageManager.getStage(message.getMessageType());
        assert (stage != null) : "No stage for message type " + (Object)((Object)message.verb);
        stage.execute(runnable, ExecutorLocals.create(state));
    }

    public void setCallbackForTests(int messageId, CallbackInfo callback) {
        this.callbacks.put(messageId, callback);
    }

    public CallbackInfo getRegisteredCallback(int messageId) {
        return this.callbacks.get(messageId);
    }

    public CallbackInfo removeRegisteredCallback(int messageId) {
        return this.callbacks.remove(messageId);
    }

    public long getRegisteredCallbackAge(int messageId) {
        return this.callbacks.getAge(messageId);
    }

    public static void validateMagic(int magic) throws IOException {
        if (magic != -900387334) {
            throw new IOException("invalid protocol header");
        }
    }

    public static int getBits(int packed, int start, int count) {
        return packed >>> start + 1 - count & ~(-1 << count);
    }

    public boolean areAllNodesAtLeast22() {
        return this.allNodesAtLeast22;
    }

    public boolean areAllNodesAtLeast30() {
        return this.allNodesAtLeast30;
    }

    public int setVersion(InetAddress endpoint, int version) {
        Integer v;
        logger.trace("Setting version {} for {}", (Object)version, (Object)endpoint);
        if (version < 9) {
            this.allNodesAtLeast22 = false;
        }
        if (version < 10) {
            this.allNodesAtLeast30 = false;
        }
        if ((v = this.versions.put(endpoint, version)) != null && v < 10 && version >= 9) {
            this.refreshAllNodeMinVersions();
        }
        return v == null ? version : v;
    }

    public void resetVersion(InetAddress endpoint) {
        logger.trace("Resetting version for {}", (Object)endpoint);
        Integer removed = (Integer)this.versions.remove(endpoint);
        if (removed != null && Math.min(removed, current_version) <= 10) {
            this.refreshAllNodeMinVersions();
        }
    }

    private void refreshAllNodeMinVersions() {
        boolean anyNodeLowerThan30 = false;
        for (Integer version : this.versions.values()) {
            if (version < 10) {
                anyNodeLowerThan30 = true;
                this.allNodesAtLeast30 = false;
            }
            if (version >= 9) continue;
            this.allNodesAtLeast22 = false;
            return;
        }
        this.allNodesAtLeast22 = true;
        this.allNodesAtLeast30 = !anyNodeLowerThan30;
    }

    public int getVersion(InetAddress endpoint) {
        Integer v = (Integer)this.versions.get(endpoint);
        if (v == null) {
            logger.trace("Assuming current protocol version for {}", (Object)endpoint);
            return current_version;
        }
        return Math.min(v, current_version);
    }

    @Override
    public int getVersion(String endpoint) throws UnknownHostException {
        return this.getVersion(InetAddress.getByName(endpoint));
    }

    public int getRawVersion(InetAddress endpoint) {
        Integer v = (Integer)this.versions.get(endpoint);
        if (v == null) {
            throw new IllegalStateException("getRawVersion() was called without checking knowsVersion() result first");
        }
        return v;
    }

    public boolean knowsVersion(InetAddress endpoint) {
        return this.versions.containsKey(endpoint);
    }

    public void incrementDroppedMutations(Optional<IMutation> mutationOpt, long timeTaken) {
        if (mutationOpt.isPresent()) {
            this.updateDroppedMutationCount(mutationOpt.get());
        }
        this.incrementDroppedMessages(Verb.MUTATION, timeTaken);
    }

    public void incrementDroppedMessages(Verb verb) {
        this.incrementDroppedMessages(verb, false);
    }

    public void incrementDroppedMessages(Verb verb, long timeTaken) {
        this.incrementDroppedMessages(verb, timeTaken, false);
    }

    public void incrementDroppedMessages(MessageIn message, long timeTaken) {
        if (message.payload instanceof IMutation) {
            this.updateDroppedMutationCount((IMutation)message.payload);
        }
        this.incrementDroppedMessages(message.verb, timeTaken, message.isCrossNode());
    }

    public void incrementDroppedMessages(Verb verb, long timeTaken, boolean isCrossNode) {
        assert (DROPPABLE_VERBS.contains((Object)verb)) : "Verb " + (Object)((Object)verb) + " should not legally be dropped";
        this.incrementDroppedMessages(this.droppedMessagesMap.get((Object)verb), timeTaken, isCrossNode);
    }

    public void incrementDroppedMessages(Verb verb, boolean isCrossNode) {
        assert (DROPPABLE_VERBS.contains((Object)verb)) : "Verb " + (Object)((Object)verb) + " should not legally be dropped";
        this.incrementDroppedMessages(this.droppedMessagesMap.get((Object)verb), isCrossNode);
    }

    private void updateDroppedMutationCount(IMutation mutation) {
        assert (mutation != null) : "Mutation should not be null when updating dropped mutations count";
        for (UUID columnFamilyId : mutation.getColumnFamilyIds()) {
            ColumnFamilyStore cfs = Keyspace.open(mutation.getKeyspaceName()).getColumnFamilyStore(columnFamilyId);
            if (cfs == null) continue;
            cfs.metric.droppedMutations.inc();
        }
    }

    private void incrementDroppedMessages(DroppedMessages droppedMessages, long timeTaken, boolean isCrossNode) {
        if (isCrossNode) {
            droppedMessages.metrics.crossNodeDroppedLatency.update(timeTaken, TimeUnit.MILLISECONDS);
        } else {
            droppedMessages.metrics.internalDroppedLatency.update(timeTaken, TimeUnit.MILLISECONDS);
        }
        this.incrementDroppedMessages(droppedMessages, isCrossNode);
    }

    private void incrementDroppedMessages(DroppedMessages droppedMessages, boolean isCrossNode) {
        droppedMessages.metrics.dropped.mark();
        if (isCrossNode) {
            droppedMessages.droppedCrossNode.incrementAndGet();
        } else {
            droppedMessages.droppedInternal.incrementAndGet();
        }
    }

    private void logDroppedMessages() {
        List<String> logs = this.getDroppedMessagesLogs();
        for (String log : logs) {
            logger.info(log);
        }
        if (logs.size() > 0) {
            StatusLogger.log();
        }
    }

    @VisibleForTesting
    List<String> getDroppedMessagesLogs() {
        ArrayList<String> ret = new ArrayList<String>();
        for (Map.Entry<Verb, DroppedMessages> entry : this.droppedMessagesMap.entrySet()) {
            Verb verb = entry.getKey();
            DroppedMessages droppedMessages = entry.getValue();
            int droppedInternal = droppedMessages.droppedInternal.getAndSet(0);
            int droppedCrossNode = droppedMessages.droppedCrossNode.getAndSet(0);
            if (droppedInternal <= 0 && droppedCrossNode <= 0) continue;
            ret.add(String.format("%s messages were dropped in last %d ms: %d internal and %d cross node. Mean internal dropped latency: %d ms and Mean cross-node dropped latency: %d ms", new Object[]{verb, 5000, droppedInternal, droppedCrossNode, TimeUnit.NANOSECONDS.toMillis((long)droppedMessages.metrics.internalDroppedLatency.getSnapshot().getMean()), TimeUnit.NANOSECONDS.toMillis((long)droppedMessages.metrics.crossNodeDroppedLatency.getSnapshot().getMean())}));
        }
        return ret;
    }

    private static void handleIOExceptionOnClose(IOException e) throws IOException {
        if ("Mac OS X".equals(System.getProperty("os.name"))) {
            switch (e.getMessage()) {
                case "Unknown error: 316": 
                case "No such file or directory": {
                    return;
                }
            }
        }
        throw e;
    }

    @Override
    public Map<String, Integer> getLargeMessagePendingTasks() {
        HashMap<String, Integer> pendingTasks = new HashMap<String, Integer>(this.connectionManagers.size());
        for (Map.Entry entry : this.connectionManagers.entrySet()) {
            pendingTasks.put(((InetAddress)entry.getKey()).getHostAddress(), ((OutboundTcpConnectionPool)entry.getValue()).largeMessages.getPendingMessages());
        }
        return pendingTasks;
    }

    public int getLargeMessagePendingTasks(InetAddress address) {
        OutboundTcpConnectionPool connection = (OutboundTcpConnectionPool)this.connectionManagers.get(address);
        return connection == null ? 0 : connection.largeMessages.getPendingMessages();
    }

    @Override
    public Map<String, Long> getLargeMessageCompletedTasks() {
        HashMap<String, Long> completedTasks = new HashMap<String, Long>(this.connectionManagers.size());
        for (Map.Entry entry : this.connectionManagers.entrySet()) {
            completedTasks.put(((InetAddress)entry.getKey()).getHostAddress(), ((OutboundTcpConnectionPool)entry.getValue()).largeMessages.getCompletedMesssages());
        }
        return completedTasks;
    }

    @Override
    public Map<String, Long> getLargeMessageDroppedTasks() {
        HashMap<String, Long> droppedTasks = new HashMap<String, Long>(this.connectionManagers.size());
        for (Map.Entry entry : this.connectionManagers.entrySet()) {
            droppedTasks.put(((InetAddress)entry.getKey()).getHostAddress(), ((OutboundTcpConnectionPool)entry.getValue()).largeMessages.getDroppedMessages());
        }
        return droppedTasks;
    }

    @Override
    public Map<String, Integer> getSmallMessagePendingTasks() {
        HashMap<String, Integer> pendingTasks = new HashMap<String, Integer>(this.connectionManagers.size());
        for (Map.Entry entry : this.connectionManagers.entrySet()) {
            pendingTasks.put(((InetAddress)entry.getKey()).getHostAddress(), ((OutboundTcpConnectionPool)entry.getValue()).smallMessages.getPendingMessages());
        }
        return pendingTasks;
    }

    @Override
    public Map<String, Long> getSmallMessageCompletedTasks() {
        HashMap<String, Long> completedTasks = new HashMap<String, Long>(this.connectionManagers.size());
        for (Map.Entry entry : this.connectionManagers.entrySet()) {
            completedTasks.put(((InetAddress)entry.getKey()).getHostAddress(), ((OutboundTcpConnectionPool)entry.getValue()).smallMessages.getCompletedMesssages());
        }
        return completedTasks;
    }

    @Override
    public Map<String, Long> getSmallMessageDroppedTasks() {
        HashMap<String, Long> droppedTasks = new HashMap<String, Long>(this.connectionManagers.size());
        for (Map.Entry entry : this.connectionManagers.entrySet()) {
            droppedTasks.put(((InetAddress)entry.getKey()).getHostAddress(), ((OutboundTcpConnectionPool)entry.getValue()).smallMessages.getDroppedMessages());
        }
        return droppedTasks;
    }

    @Override
    public Map<String, Integer> getGossipMessagePendingTasks() {
        HashMap<String, Integer> pendingTasks = new HashMap<String, Integer>(this.connectionManagers.size());
        for (Map.Entry entry : this.connectionManagers.entrySet()) {
            pendingTasks.put(((InetAddress)entry.getKey()).getHostAddress(), ((OutboundTcpConnectionPool)entry.getValue()).gossipMessages.getPendingMessages());
        }
        return pendingTasks;
    }

    @Override
    public Map<String, Long> getGossipMessageCompletedTasks() {
        HashMap<String, Long> completedTasks = new HashMap<String, Long>(this.connectionManagers.size());
        for (Map.Entry entry : this.connectionManagers.entrySet()) {
            completedTasks.put(((InetAddress)entry.getKey()).getHostAddress(), ((OutboundTcpConnectionPool)entry.getValue()).gossipMessages.getCompletedMesssages());
        }
        return completedTasks;
    }

    @Override
    public Map<String, Long> getGossipMessageDroppedTasks() {
        HashMap<String, Long> droppedTasks = new HashMap<String, Long>(this.connectionManagers.size());
        for (Map.Entry entry : this.connectionManagers.entrySet()) {
            droppedTasks.put(((InetAddress)entry.getKey()).getHostAddress(), ((OutboundTcpConnectionPool)entry.getValue()).gossipMessages.getDroppedMessages());
        }
        return droppedTasks;
    }

    @Override
    public Map<String, Integer> getDroppedMessages() {
        HashMap<String, Integer> map = new HashMap<String, Integer>(this.droppedMessagesMap.size());
        for (Map.Entry<Verb, DroppedMessages> entry : this.droppedMessagesMap.entrySet()) {
            map.put(entry.getKey().toString(), (int)entry.getValue().metrics.dropped.getCount());
        }
        return map;
    }

    @Override
    public long getTotalTimeouts() {
        return ConnectionMetrics.totalTimeouts.getCount();
    }

    @Override
    public Map<String, Long> getTimeoutsPerHost() {
        HashMap<String, Long> result = new HashMap<String, Long>(this.connectionManagers.size());
        for (Map.Entry entry : this.connectionManagers.entrySet()) {
            String ip = ((InetAddress)entry.getKey()).getHostAddress();
            long recent = ((OutboundTcpConnectionPool)entry.getValue()).getTimeouts();
            result.put(ip, recent);
        }
        return result;
    }

    @Override
    public Map<String, Double> getBackPressurePerHost() {
        HashMap<String, Double> map = new HashMap<String, Double>(this.connectionManagers.size());
        for (Map.Entry entry : this.connectionManagers.entrySet()) {
            map.put(((InetAddress)entry.getKey()).getHostAddress(), ((OutboundTcpConnectionPool)entry.getValue()).getBackPressureState().getBackPressureRateLimit());
        }
        return map;
    }

    @Override
    public void setBackPressureEnabled(boolean enabled) {
        DatabaseDescriptor.setBackPressureEnabled(enabled);
    }

    @Override
    public boolean isBackPressureEnabled() {
        return DatabaseDescriptor.backPressureEnabled();
    }

    public static IPartitioner globalPartitioner() {
        return StorageService.instance.getTokenMetadata().partitioner;
    }

    public static void validatePartitioner(Collection<? extends AbstractBounds<?>> allBounds) {
        for (AbstractBounds<?> bounds : allBounds) {
            MessagingService.validatePartitioner(bounds);
        }
    }

    public static void validatePartitioner(AbstractBounds<?> bounds) {
        if (MessagingService.globalPartitioner() != bounds.left.getPartitioner()) {
            throw new AssertionError((Object)String.format("Partitioner in bounds serialization. Expected %s, was %s.", MessagingService.globalPartitioner().getClass().getName(), bounds.left.getPartitioner().getClass().getName()));
        }
    }

    @VisibleForTesting
    public List<SocketThread> getSocketThreads() {
        return this.socketThreads;
    }

    @VisibleForTesting
    public static class SocketThread
    extends Thread {
        private final ServerSocket server;
        @VisibleForTesting
        public final Set<Closeable> connections = Sets.newConcurrentHashSet();

        SocketThread(ServerSocket server, String name) {
            super(name);
            this.server = server;
        }

        @Override
        public void run() {
            while (!this.server.isClosed()) {
                Socket socket = null;
                try {
                    socket = this.server.accept();
                    if (!this.authenticate(socket)) {
                        logger.trace("remote failed to authenticate");
                        socket.close();
                        continue;
                    }
                    socket.setKeepAlive(true);
                    socket.setSoTimeout(10000);
                    DataInputStream in = new DataInputStream(socket.getInputStream());
                    MessagingService.validateMagic(in.readInt());
                    int header = in.readInt();
                    boolean isStream = MessagingService.getBits(header, 3, 1) == 1;
                    int version = MessagingService.getBits(header, 15, 8);
                    logger.trace("Connection version {} from {}", (Object)version, (Object)socket.getInetAddress());
                    socket.setSoTimeout(0);
                    Closeable thread = isStream ? new IncomingStreamingConnection(version, socket, this.connections) : new IncomingTcpConnection(version, MessagingService.getBits(header, 2, 1) == 1, socket, this.connections);
                    ((Thread)((Object)thread)).start();
                    this.connections.add(thread);
                }
                catch (AsynchronousCloseException e) {
                    logger.trace("Asynchronous close seen by server thread");
                    break;
                }
                catch (ClosedChannelException e) {
                    logger.trace("MessagingService server thread already closed");
                    break;
                }
                catch (SSLHandshakeException e) {
                    logger.error("SSL handshake error for inbound connection from " + socket, (Throwable)e);
                    FileUtils.closeQuietly(socket);
                }
                catch (Throwable t) {
                    logger.trace("Error reading the socket {}", (Object)socket, (Object)t);
                    FileUtils.closeQuietly(socket);
                }
            }
            logger.info("MessagingService has terminated the accept() thread");
        }

        void close() throws IOException {
            logger.trace("Closing accept() thread");
            try {
                this.server.close();
            }
            catch (IOException e) {
                MessagingService.handleIOExceptionOnClose(e);
            }
            for (Closeable connection : this.connections) {
                connection.close();
            }
        }

        private boolean authenticate(Socket socket) {
            return DatabaseDescriptor.getInternodeAuthenticator().authenticate(socket.getInetAddress(), socket.getPort());
        }
    }

    private static class MSTestHandle {
        public static final MessagingService instance = new MessagingService(true);

        private MSTestHandle() {
        }
    }

    private static class MSHandle {
        public static final MessagingService instance = new MessagingService(false);

        private MSHandle() {
        }
    }

    private static final class DroppedMessages {
        final DroppedMessageMetrics metrics;
        final AtomicInteger droppedInternal;
        final AtomicInteger droppedCrossNode;

        DroppedMessages(Verb verb) {
            this(new DroppedMessageMetrics(verb));
        }

        DroppedMessages(DroppedMessageMetrics metrics) {
            this.metrics = metrics;
            this.droppedInternal = new AtomicInteger(0);
            this.droppedCrossNode = new AtomicInteger(0);
        }
    }

    static class CallbackDeterminedSerializer
    implements IVersionedSerializer<Object> {
        public static final CallbackDeterminedSerializer instance = new CallbackDeterminedSerializer();

        CallbackDeterminedSerializer() {
        }

        @Override
        public Object deserialize(DataInputPlus in, int version) throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public void serialize(Object o, DataOutputPlus out, int version) throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public long serializedSize(Object o, int version) {
            throw new UnsupportedOperationException();
        }
    }

    public static enum Verb {
        MUTATION{

            @Override
            public long getTimeout() {
                return DatabaseDescriptor.getWriteRpcTimeout();
            }
        }
        ,
        HINT{

            @Override
            public long getTimeout() {
                return DatabaseDescriptor.getWriteRpcTimeout();
            }
        }
        ,
        READ_REPAIR{

            @Override
            public long getTimeout() {
                return DatabaseDescriptor.getWriteRpcTimeout();
            }
        }
        ,
        READ{

            @Override
            public long getTimeout() {
                return DatabaseDescriptor.getReadRpcTimeout();
            }
        }
        ,
        REQUEST_RESPONSE,
        BATCH_STORE{

            @Override
            public long getTimeout() {
                return DatabaseDescriptor.getWriteRpcTimeout();
            }
        }
        ,
        BATCH_REMOVE{

            @Override
            public long getTimeout() {
                return DatabaseDescriptor.getWriteRpcTimeout();
            }
        }
        ,
        STREAM_REPLY,
        STREAM_REQUEST,
        RANGE_SLICE{

            @Override
            public long getTimeout() {
                return DatabaseDescriptor.getRangeRpcTimeout();
            }
        }
        ,
        BOOTSTRAP_TOKEN,
        TREE_REQUEST,
        TREE_RESPONSE,
        JOIN,
        GOSSIP_DIGEST_SYN,
        GOSSIP_DIGEST_ACK,
        GOSSIP_DIGEST_ACK2,
        DEFINITIONS_ANNOUNCE,
        DEFINITIONS_UPDATE,
        TRUNCATE{

            @Override
            public long getTimeout() {
                return DatabaseDescriptor.getTruncateRpcTimeout();
            }
        }
        ,
        SCHEMA_CHECK,
        INDEX_SCAN,
        REPLICATION_FINISHED,
        INTERNAL_RESPONSE,
        COUNTER_MUTATION{

            @Override
            public long getTimeout() {
                return DatabaseDescriptor.getCounterWriteRpcTimeout();
            }
        }
        ,
        STREAMING_REPAIR_REQUEST,
        STREAMING_REPAIR_RESPONSE,
        SNAPSHOT,
        MIGRATION_REQUEST,
        GOSSIP_SHUTDOWN,
        _TRACE,
        ECHO,
        REPAIR_MESSAGE,
        PAXOS_PREPARE{

            @Override
            public long getTimeout() {
                return DatabaseDescriptor.getWriteRpcTimeout();
            }
        }
        ,
        PAXOS_PROPOSE{

            @Override
            public long getTimeout() {
                return DatabaseDescriptor.getWriteRpcTimeout();
            }
        }
        ,
        PAXOS_COMMIT{

            @Override
            public long getTimeout() {
                return DatabaseDescriptor.getWriteRpcTimeout();
            }
        }
        ,
        PAGED_RANGE{

            @Override
            public long getTimeout() {
                return DatabaseDescriptor.getRangeRpcTimeout();
            }
        }
        ,
        PING,
        UNUSED_2,
        UNUSED_3,
        UNUSED_4,
        UNUSED_5;


        public static Verb convertForMessagingServiceVersion(Verb verb, int version) {
            if (verb == PAGED_RANGE && version >= 10) {
                return RANGE_SLICE;
            }
            return verb;
        }

        public long getTimeout() {
            return DatabaseDescriptor.getRpcTimeout();
        }
    }
}

