/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.cli.aio;

import java.util.Date;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.uima.ducc.cli.IDuccCallback;
import org.apache.uima.ducc.cli.aio.IMessageHandler;

public class MessageHandler
implements IMessageHandler {
    private ConcurrentHashMap<IMessageHandler.Level, IMessageHandler.Toggle> map = new ConcurrentHashMap();
    private IMessageHandler.Toggle timestamping = IMessageHandler.Toggle.Off;
    private IMessageHandler.Toggle typeIdentifying = IMessageHandler.Toggle.On;
    private IDuccCallback consoleCb = null;

    public MessageHandler() {
        this.initialize();
    }

    public MessageHandler(IDuccCallback consoleCb) {
        this.consoleCb = consoleCb;
        this.initialize();
    }

    public MessageHandler(IMessageHandler.Toggle timestamping) {
        this.setTimestamping(timestamping);
        this.initialize();
    }

    private void initialize() {
        this.map.put(IMessageHandler.Level.UserInfo, IMessageHandler.Toggle.On);
        this.map.put(IMessageHandler.Level.UserError, IMessageHandler.Toggle.On);
        this.map.put(IMessageHandler.Level.UserWarn, IMessageHandler.Toggle.On);
        this.map.put(IMessageHandler.Level.UserDebug, IMessageHandler.Toggle.Off);
        this.map.put(IMessageHandler.Level.UserTrace, IMessageHandler.Toggle.Off);
        this.map.put(IMessageHandler.Level.FrameworkInfo, IMessageHandler.Toggle.Off);
        this.map.put(IMessageHandler.Level.FrameworkError, IMessageHandler.Toggle.Off);
        this.map.put(IMessageHandler.Level.FrameworkWarn, IMessageHandler.Toggle.Off);
        this.map.put(IMessageHandler.Level.FrameworkDebug, IMessageHandler.Toggle.Off);
        this.map.put(IMessageHandler.Level.FrameworkTrace, IMessageHandler.Toggle.Off);
    }

    @Override
    public void setLevel(IMessageHandler.Level level, IMessageHandler.Toggle toggle) {
        if (level != null && toggle != null) {
            this.map.put(level, toggle);
        }
    }

    @Override
    public IMessageHandler.Toggle getLevel(IMessageHandler.Level level) {
        IMessageHandler.Toggle retVal = IMessageHandler.Toggle.Off;
        if (level != null && this.map.containsKey((Object)level)) {
            retVal = this.map.get((Object)level);
        }
        return retVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setTimestamping(IMessageHandler.Toggle toggle) {
        MessageHandler messageHandler = this;
        synchronized (messageHandler) {
            if (toggle != null) {
                this.timestamping = toggle;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IMessageHandler.Toggle getTimestamping() {
        MessageHandler messageHandler = this;
        synchronized (messageHandler) {
            return this.timestamping;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTypeIdentifying(IMessageHandler.Toggle toggle) {
        MessageHandler messageHandler = this;
        synchronized (messageHandler) {
            if (toggle != null) {
                this.typeIdentifying = toggle;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IMessageHandler.Toggle getTypeIdentifying() {
        MessageHandler messageHandler = this;
        synchronized (messageHandler) {
            return this.typeIdentifying;
        }
    }

    private void sysout(IMessageHandler.Level level, String message) {
        String text = message;
        switch (this.getTypeIdentifying()) {
            case On: {
                if (level == null) break;
                text = level.getLabel() + " " + message;
            }
        }
        switch (this.getTimestamping()) {
            case On: {
                Date date = new Date();
                text = date + " " + text;
            }
        }
        if (this.consoleCb != null) {
            this.consoleCb.status(text);
        } else {
            System.out.println(text);
            System.out.flush();
        }
    }

    private void syserr(IMessageHandler.Level level, String message) {
        String text = message;
        switch (this.getTypeIdentifying()) {
            case On: {
                if (level == null) break;
                text = level.getLabel() + " " + message;
            }
        }
        switch (this.getTimestamping()) {
            case On: {
                Date date = new Date();
                text = date + " " + text;
            }
        }
        if (this.consoleCb != null) {
            this.consoleCb.status(text);
        } else {
            System.err.println(text);
            System.err.flush();
        }
    }

    @Override
    public void info(String message) {
        IMessageHandler.Toggle toggle = this.map.get((Object)IMessageHandler.Level.UserInfo);
        switch (toggle) {
            case On: {
                this.sysout(IMessageHandler.Level.UserInfo, message);
            }
        }
    }

    @Override
    public void error(String message) {
        IMessageHandler.Toggle toggle = this.map.get((Object)IMessageHandler.Level.UserError);
        switch (toggle) {
            case On: {
                this.syserr(IMessageHandler.Level.UserError, message);
            }
        }
    }

    @Override
    public void error(Exception e) {
        IMessageHandler.Toggle toggle = this.map.get((Object)IMessageHandler.Level.UserError);
        switch (toggle) {
            case On: {
                e.printStackTrace(System.err);
                System.err.flush();
            }
        }
    }

    @Override
    public void error(Throwable t) {
        IMessageHandler.Toggle toggle = this.map.get((Object)IMessageHandler.Level.UserError);
        switch (toggle) {
            case On: {
                t.printStackTrace(System.err);
                System.err.flush();
            }
        }
    }

    @Override
    public void warn(String message) {
        IMessageHandler.Toggle toggle = this.map.get((Object)IMessageHandler.Level.UserWarn);
        switch (toggle) {
            case On: {
                this.sysout(IMessageHandler.Level.UserWarn, message);
            }
        }
    }

    @Override
    public void debug(String message) {
        IMessageHandler.Toggle toggle = this.map.get((Object)IMessageHandler.Level.UserDebug);
        switch (toggle) {
            case On: {
                this.sysout(IMessageHandler.Level.UserDebug, message);
            }
        }
    }

    @Override
    public void trace(String message) {
        IMessageHandler.Toggle toggle = this.map.get((Object)IMessageHandler.Level.UserTrace);
        switch (toggle) {
            case On: {
                this.sysout(IMessageHandler.Level.UserTrace, message);
            }
        }
    }

    @Override
    public void info(String cid, String mid, String message) {
        this.info(cid + "." + mid + " " + message);
    }

    @Override
    public void error(String cid, String mid, String message) {
        this.error(cid + "." + mid + " " + message);
    }

    @Override
    public void warn(String cid, String mid, String message) {
        this.warn(cid + "." + mid + " " + message);
    }

    @Override
    public void debug(String cid, String mid, String message) {
        this.debug(cid + "." + mid + " " + message);
    }

    @Override
    public void trace(String cid, String mid, String message) {
        this.trace(cid + "." + mid + " " + message);
    }

    @Override
    public void frameworkInfo(String message) {
        IMessageHandler.Toggle toggle = this.map.get((Object)IMessageHandler.Level.FrameworkInfo);
        switch (toggle) {
            case On: {
                this.sysout(IMessageHandler.Level.FrameworkInfo, message);
            }
        }
    }

    @Override
    public void frameworkError(String message) {
        IMessageHandler.Toggle toggle = this.map.get((Object)IMessageHandler.Level.FrameworkError);
        switch (toggle) {
            case On: {
                this.syserr(IMessageHandler.Level.FrameworkError, message);
            }
        }
    }

    @Override
    public void frameworkError(Exception e) {
        IMessageHandler.Toggle toggle = this.map.get((Object)IMessageHandler.Level.FrameworkError);
        switch (toggle) {
            case On: {
                e.printStackTrace(System.err);
                System.err.flush();
            }
        }
    }

    @Override
    public void frameworkError(Throwable t) {
        IMessageHandler.Toggle toggle = this.map.get((Object)IMessageHandler.Level.FrameworkError);
        switch (toggle) {
            case On: {
                t.printStackTrace(System.err);
                System.err.flush();
            }
        }
    }

    @Override
    public void frameworkWarn(String message) {
        IMessageHandler.Toggle toggle = this.map.get((Object)IMessageHandler.Level.FrameworkWarn);
        switch (toggle) {
            case On: {
                this.sysout(IMessageHandler.Level.FrameworkWarn, message);
            }
        }
    }

    @Override
    public void frameworkDebug(String message) {
        IMessageHandler.Toggle toggle = this.map.get((Object)IMessageHandler.Level.FrameworkDebug);
        switch (toggle) {
            case On: {
                this.sysout(IMessageHandler.Level.FrameworkDebug, message);
            }
        }
    }

    @Override
    public void frameworkTrace(String message) {
        IMessageHandler.Toggle toggle = this.map.get((Object)IMessageHandler.Level.FrameworkTrace);
        switch (toggle) {
            case On: {
                this.sysout(IMessageHandler.Level.FrameworkTrace, message);
            }
        }
    }

    @Override
    public void frameworkInfo(String cid, String mid, String message) {
        this.frameworkInfo(cid + "." + mid + " " + message);
    }

    @Override
    public void frameworkError(String cid, String mid, String message) {
        this.frameworkError(cid + "." + mid + " " + message);
    }

    @Override
    public void frameworkWarn(String cid, String mid, String message) {
        this.frameworkWarn(cid + "." + mid + " " + message);
    }

    @Override
    public void frameworkDebug(String cid, String mid, String message) {
        this.frameworkDebug(cid + "." + mid + " " + message);
    }

    @Override
    public void frameworkTrace(String cid, String mid, String message) {
        this.frameworkTrace(cid + "." + mid + " " + message);
    }
}

