/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.ws.self.message;

import java.io.Serializable;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.ObjectMessage;
import javax.jms.Session;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.command.ActiveMQTopic;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.uima.ducc.common.utils.DuccLogger;
import org.apache.uima.ducc.ws.self.message.WebServerState;
import org.apache.uima.ducc.ws.self.message.WebServerStateDuccEvent;
import org.springframework.jms.core.JmsTemplate;
import org.springframework.jms.core.MessageCreator;

public class WebServerStateProcessor
implements Processor {
    private final String brokerUrl;
    private final String username;
    private final String password;
    private final String endpoint;
    private DuccLogger duccLogger = DuccLogger.getLogger(WebServerStateProcessor.class);

    public WebServerStateProcessor(String brokerUrl, String username, String password, String endpoint) {
        this.brokerUrl = brokerUrl;
        this.username = username;
        this.password = password;
        this.endpoint = endpoint;
    }

    public void process(Exchange exchange) throws Exception {
        try {
            ActiveMQConnectionFactory amqcf = new ActiveMQConnectionFactory(this.username, this.password, this.brokerUrl);
            amqcf.setTrustAllPackages(true);
            JmsTemplate jmsDispatcher = new JmsTemplate((ConnectionFactory)amqcf);
            int pos = this.endpoint.indexOf("topic:") + "topic:".length();
            String topicName = this.endpoint.substring(pos);
            ActiveMQTopic topic = new ActiveMQTopic(topicName);
            jmsDispatcher.send((Destination)topic, new MessageCreator(){

                public Message createMessage(Session session) throws JMSException {
                    ObjectMessage body = session.createObjectMessage();
                    WebServerStateDuccEvent wse = new WebServerStateDuccEvent();
                    WebServerState wss = new WebServerState();
                    wse.setState(wss);
                    body.setObject((Serializable)((Object)wse));
                    return body;
                }
            });
        }
        catch (Throwable t) {
            this.duccLogger.error("process", null, t, new Object[0]);
        }
    }
}

