/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.sort;

import java.io.PrintStream;
import java.util.Arrays;
import java.util.Iterator;
import net.sf.saxon.Configuration;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.Optimizer;
import net.sf.saxon.expr.PromotionOffer;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.Item;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.ExternalObjectType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.ObjectValue;
import net.sf.saxon.value.Value;

public class TupleExpression
extends Expression {
    Expression[] components;
    int[] evaluationModes;

    public TupleExpression(int n) {
        this.components = new Expression[n];
        this.evaluationModes = new int[n];
    }

    public void setExpression(int n, Expression expression) {
        this.components[n] = expression;
        this.adoptChildExpression(this.components[n]);
        this.evaluationModes[n] = -1;
    }

    public Expression[] getComponents() {
        return this.components;
    }

    public Expression simplify(StaticContext staticContext) throws XPathException {
        for (int i = 0; i < this.components.length; ++i) {
            this.components[i] = this.components[i].simplify(staticContext);
            this.adoptChildExpression(this.components[i]);
        }
        return this;
    }

    public Expression promote(PromotionOffer promotionOffer) throws XPathException {
        for (int i = 0; i < this.components.length; ++i) {
            this.components[i] = this.doPromotion(this.components[i], promotionOffer);
            this.adoptChildExpression(this.components[i]);
        }
        return this;
    }

    public ItemType getItemType(TypeHierarchy typeHierarchy) {
        return new ExternalObjectType(Object.class, typeHierarchy.getConfiguration());
    }

    public Expression typeCheck(StaticContext staticContext, ItemType itemType) throws XPathException {
        for (int i = 0; i < this.components.length; ++i) {
            this.components[i] = this.components[i].typeCheck(staticContext, itemType);
            this.adoptChildExpression(this.components[i]);
        }
        return this;
    }

    public Expression optimize(Optimizer optimizer, StaticContext staticContext, ItemType itemType) throws XPathException {
        for (int i = 0; i < this.components.length; ++i) {
            this.components[i] = this.components[i].optimize(optimizer, staticContext, itemType);
            this.adoptChildExpression(this.components[i]);
            this.evaluationModes[i] = i < 2 ? ExpressionTool.eagerEvaluationMode(this.components[i]) : ExpressionTool.lazyEvaluationMode(this.components[i]);
        }
        return this;
    }

    public void display(int n, PrintStream printStream, Configuration configuration) {
        printStream.println(ExpressionTool.indent(n) + "Tuple");
        for (int i = 0; i < this.components.length; ++i) {
            this.components[i].display(n + 1, printStream, configuration);
        }
    }

    public Item evaluateItem(XPathContext xPathContext) throws XPathException {
        Value[] valueArray = new Value[this.components.length];
        for (int i = 0; i < this.components.length; ++i) {
            valueArray[i] = Value.asValue(ExpressionTool.evaluate(this.components[i], this.evaluationModes[i], xPathContext, 10));
        }
        return new ObjectValue(valueArray);
    }

    public int computeCardinality() {
        return 16384;
    }

    public int getIntrinsicDependencies() {
        return 0;
    }

    public Iterator iterateSubExpressions() {
        return Arrays.asList(this.components).iterator();
    }

    public boolean replaceSubExpression(Expression expression, Expression expression2) {
        boolean bl = false;
        for (int i = 0; i < this.components.length; ++i) {
            if (this.components[i] != expression) continue;
            this.components[i] = expression2;
            bl = true;
        }
        return bl;
    }
}

