/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ep_launcher.ui;

import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.util.HashSet;
import org.apache.uima.ep_launcher.LauncherConstants;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.jdt.debug.ui.launchConfigurations.JavaLaunchTab;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ContainerSelectionDialog;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class AnalysisEngineMainTab
extends JavaLaunchTab {
    private Text projectText;
    private Text descriptorText;
    private Text inputText;
    private Button recursivelyButton;
    private Button casButton;
    private Button plainTextButton;
    private Combo encodingCombo;
    private Text languageText;
    private Text outputFolderText;
    private Button clearFolderButton;

    private IWorkspaceRoot getWorkspaceRoot() {
        return ResourcesPlugin.getWorkspace().getRoot();
    }

    private IProject getSelectedProject() {
        IResource project = ResourcesPlugin.getWorkspace().getRoot().findMember(this.projectText.getText());
        if (project instanceof IProject) {
            return (IProject)project;
        }
        return null;
    }

    private IContainer getContainer(String path) {
        Path containerPath = new Path(path);
        IResource resource = this.getWorkspaceRoot().findMember((IPath)containerPath);
        if (resource instanceof IContainer) {
            return (IContainer)resource;
        }
        return null;
    }

    public void createControl(Composite composite) {
        Composite projectComposite = new Composite(composite, 0);
        GridLayout projectGridLayout = new GridLayout();
        projectGridLayout.numColumns = 1;
        projectGridLayout.horizontalSpacing = 4;
        projectComposite.setLayout((Layout)projectGridLayout);
        Group projectGroup = new Group(projectComposite, 0);
        projectGroup.setText("Project:");
        GridData projectGroupData = new GridData();
        projectGroupData.grabExcessHorizontalSpace = true;
        projectGroupData.horizontalAlignment = 4;
        projectGroup.setLayoutData((Object)projectGroupData);
        GridLayout projectGroupLayout = new GridLayout(2, false);
        projectGroup.setLayout((Layout)projectGroupLayout);
        this.projectText = new Text((Composite)projectGroup, 2048);
        GridDataFactory.swtDefaults().align(4, 0x1000000).grab(true, false).applyTo((Control)this.projectText);
        this.projectText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                AnalysisEngineMainTab.this.updateLaunchConfigurationDialog();
            }
        });
        Button browseProject = new Button((Composite)projectGroup, 0);
        browseProject.setText("Browse ...");
        browseProject.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                WorkbenchLabelProvider labelProvider = new WorkbenchLabelProvider();
                ElementListSelectionDialog dialog = new ElementListSelectionDialog(AnalysisEngineMainTab.this.getShell(), (ILabelProvider)labelProvider);
                dialog.setTitle("Project Selection");
                dialog.setMessage("Select a project");
                dialog.setElements((Object[])AnalysisEngineMainTab.this.getWorkspaceRoot().getProjects());
                IProject project = AnalysisEngineMainTab.this.getSelectedProject();
                if (project != null) {
                    dialog.setInitialSelections(new Object[]{project});
                }
                if (dialog.open() == 0) {
                    IProject selectedProject = (IProject)dialog.getFirstResult();
                    AnalysisEngineMainTab.this.projectText.setText(selectedProject.getName());
                }
            }
        });
        Group descriptorGroup = new Group(projectComposite, 0);
        descriptorGroup.setText("Descriptor:");
        GridData descriptorGroupData = new GridData();
        descriptorGroupData.grabExcessHorizontalSpace = true;
        descriptorGroupData.horizontalAlignment = 4;
        descriptorGroup.setLayoutData((Object)projectGroupData);
        GridLayout descriptorGroupLayout = new GridLayout(2, false);
        descriptorGroup.setLayout((Layout)descriptorGroupLayout);
        this.descriptorText = new Text((Composite)descriptorGroup, 2048);
        GridDataFactory.swtDefaults().align(4, 0x1000000).grab(true, false).applyTo((Control)this.descriptorText);
        this.descriptorText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                AnalysisEngineMainTab.this.updateLaunchConfigurationDialog();
            }
        });
        Button browseDescriptor = new Button((Composite)descriptorGroup, 0);
        browseDescriptor.setText("Browse ...");
        browseDescriptor.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IResource resource;
                ElementTreeSelectionDialog dialog = new ElementTreeSelectionDialog(AnalysisEngineMainTab.this.getShell(), (ILabelProvider)new WorkbenchLabelProvider(), (ITreeContentProvider)new WorkbenchContentProvider());
                dialog.setTitle("Select descriptor");
                dialog.setMessage("Select descriptor");
                dialog.setInput((Object)AnalysisEngineMainTab.this.getWorkspaceRoot());
                dialog.setInitialSelection((Object)AnalysisEngineMainTab.this.getWorkspaceRoot().findMember(AnalysisEngineMainTab.this.descriptorText.getText()));
                if (dialog.open() == 0 && (resource = (IResource)dialog.getFirstResult()) != null) {
                    String fileLoc = resource.getFullPath().toString();
                    AnalysisEngineMainTab.this.descriptorText.setText(fileLoc);
                }
            }
        });
        Group inputResourceGroup = new Group(projectComposite, 0);
        inputResourceGroup.setText("Input Resource:");
        GridDataFactory.swtDefaults().align(4, 0x1000000).grab(true, false).applyTo((Control)inputResourceGroup);
        GridLayout inputResourceGroupLayout = new GridLayout(2, false);
        inputResourceGroup.setLayout((Layout)inputResourceGroupLayout);
        this.inputText = new Text((Composite)inputResourceGroup, 2048);
        GridDataFactory.swtDefaults().align(4, 0x1000000).grab(true, false).applyTo((Control)this.inputText);
        this.inputText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                AnalysisEngineMainTab.this.updateLaunchConfigurationDialog();
            }
        });
        Button browseInputResource = new Button((Composite)inputResourceGroup, 0);
        browseInputResource.setText("Browse ...");
        browseInputResource.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IResource resource;
                ElementTreeSelectionDialog dialog = new ElementTreeSelectionDialog(AnalysisEngineMainTab.this.getShell(), (ILabelProvider)new WorkbenchLabelProvider(), (ITreeContentProvider)new WorkbenchContentProvider());
                dialog.setTitle("Select input folder or file");
                dialog.setMessage("Select input folder or file");
                dialog.setInput((Object)AnalysisEngineMainTab.this.getSelectedProject());
                dialog.setInitialSelection((Object)AnalysisEngineMainTab.this.getWorkspaceRoot().findMember(AnalysisEngineMainTab.this.inputText.getText()));
                if (dialog.open() == 0 && (resource = (IResource)dialog.getFirstResult()) != null) {
                    String fileLoc = resource.getFullPath().toString();
                    AnalysisEngineMainTab.this.inputText.setText(fileLoc);
                }
            }
        });
        this.recursivelyButton = new Button((Composite)inputResourceGroup, 32);
        this.recursivelyButton.setText("Recursively, read all files under each directory");
        GridDataFactory.swtDefaults().align(4, 0x1000000).grab(true, false).applyTo((Control)this.recursivelyButton);
        this.recursivelyButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                AnalysisEngineMainTab.this.updateLaunchConfigurationDialog();
            }

            public void widgetDefaultSelected(SelectionEvent event) {
            }
        });
        Group inputFormatGroup = new Group(projectComposite, 0);
        inputFormatGroup.setText("Input Format:");
        GridDataFactory.swtDefaults().align(4, 0x1000000).grab(true, false).applyTo((Control)inputFormatGroup);
        GridLayout inputFormatGroupLayout = new GridLayout(4, false);
        inputFormatGroup.setLayout((Layout)inputFormatGroupLayout);
        this.casButton = new Button((Composite)inputFormatGroup, 16);
        this.casButton.setText("CASes (XMI or XCAS format)");
        GridDataFactory.swtDefaults().align(4, 0x1000000).grab(true, false).span(4, 1).applyTo((Control)this.casButton);
        this.casButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                AnalysisEngineMainTab.this.updateLaunchConfigurationDialog();
            }

            public void widgetDefaultSelected(SelectionEvent event) {
            }
        });
        this.plainTextButton = new Button((Composite)inputFormatGroup, 16);
        GridDataFactory.swtDefaults().align(16384, 0x1000000).grab(false, false).applyTo((Control)this.plainTextButton);
        this.plainTextButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                AnalysisEngineMainTab.this.encodingCombo.setEnabled(AnalysisEngineMainTab.this.plainTextButton.getSelection());
                AnalysisEngineMainTab.this.languageText.setEnabled(AnalysisEngineMainTab.this.plainTextButton.getSelection());
                AnalysisEngineMainTab.this.updateLaunchConfigurationDialog();
            }

            public void widgetDefaultSelected(SelectionEvent event) {
            }
        });
        this.plainTextButton.setText("Plain Text, encoding:");
        this.encodingCombo = new Combo((Composite)inputFormatGroup, 0);
        GridDataFactory.swtDefaults().align(16384, 0x1000000).grab(false, false).applyTo((Control)this.encodingCombo);
        this.encodingCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                AnalysisEngineMainTab.this.updateLaunchConfigurationDialog();
            }
        });
        String defaultEncoding = Charset.defaultCharset().displayName();
        HashSet<String> charsets = new HashSet<String>();
        charsets.add("US-ASCII");
        charsets.add("ISO-8859-1");
        charsets.add("UTF-8");
        charsets.add("UTF-16BE");
        charsets.add("UTF-16LE");
        charsets.add("UTF-16");
        charsets.add(defaultEncoding);
        this.encodingCombo.setItems(charsets.toArray(new String[charsets.size()]));
        this.encodingCombo.setEnabled(false);
        Label languageLabel = new Label((Composite)inputFormatGroup, 0);
        languageLabel.setText("Language:");
        this.languageText = new Text((Composite)inputFormatGroup, 2048);
        GridDataFactory.swtDefaults().hint(250, -1).align(16384, 0x1000000).grab(true, false).applyTo((Control)this.languageText);
        this.languageText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                AnalysisEngineMainTab.this.updateLaunchConfigurationDialog();
            }
        });
        Group outputFolderGroup = new Group(projectComposite, 0);
        outputFolderGroup.setText("Output Folder:");
        GridDataFactory.swtDefaults().align(4, 0x1000000).grab(true, false).applyTo((Control)outputFolderGroup);
        GridLayout outputFolderGroupLayout = new GridLayout(2, false);
        outputFolderGroup.setLayout((Layout)outputFolderGroupLayout);
        this.outputFolderText = new Text((Composite)outputFolderGroup, 2048);
        GridDataFactory.swtDefaults().align(4, 0x1000000).grab(true, false).applyTo((Control)this.outputFolderText);
        this.outputFolderText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                AnalysisEngineMainTab.this.updateLaunchConfigurationDialog();
            }
        });
        Button browseOutputFolderButton = new Button((Composite)outputFolderGroup, 0);
        browseOutputFolderButton.setText("Browse ...");
        browseOutputFolderButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String currentContainerString = AnalysisEngineMainTab.this.outputFolderText.getText();
                IContainer currentContainer = AnalysisEngineMainTab.this.getContainer(currentContainerString);
                ContainerSelectionDialog dialog = new ContainerSelectionDialog(AnalysisEngineMainTab.this.getShell(), currentContainer, false, "Select output folder");
                dialog.showClosedProjects(false);
                dialog.open();
                Object[] results = dialog.getResult();
                if (results != null && results.length > 0 && results[0] instanceof IPath) {
                    IPath path = (IPath)results[0];
                    String containerName = path.toOSString();
                    AnalysisEngineMainTab.this.outputFolderText.setText(containerName);
                }
            }
        });
        this.clearFolderButton = new Button((Composite)outputFolderGroup, 32);
        this.clearFolderButton.setText("Clear the output folder");
        GridDataFactory.swtDefaults().align(4, 0x1000000).grab(true, false).applyTo((Control)this.clearFolderButton);
        this.clearFolderButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                AnalysisEngineMainTab.this.updateLaunchConfigurationDialog();
            }

            public void widgetDefaultSelected(SelectionEvent event) {
            }
        });
        this.setControl((Control)projectComposite);
    }

    public String getName() {
        return "Main";
    }

    public boolean isValid(ILaunchConfiguration launchConfig) {
        IResource outputResource;
        this.setErrorMessage(null);
        String projectName = this.projectText.getText();
        IResource projectResource = ResourcesPlugin.getWorkspace().getRoot().findMember(projectName);
        if (!(projectResource instanceof IProject)) {
            this.setErrorMessage("Project does not exist!");
            return false;
        }
        IResource descriptorResource = this.getWorkspaceRoot().findMember(this.descriptorText.getText());
        if (!(descriptorResource instanceof IFile)) {
            this.setErrorMessage("Descriptor must be an existing file!");
            return false;
        }
        IResource inputResource = this.getWorkspaceRoot().findMember(this.inputText.getText());
        if (inputResource == null) {
            this.setErrorMessage("Input resource must be an existing file or folder!");
            return false;
        }
        if (this.plainTextButton.getSelection()) {
            boolean isEncodingValid;
            String inptuEncoding = this.encodingCombo.getText();
            try {
                isEncodingValid = Charset.isSupported(inptuEncoding);
            }
            catch (IllegalCharsetNameException e) {
                isEncodingValid = false;
            }
            if (!isEncodingValid) {
                this.setErrorMessage("Invalid input format encoding!");
                return false;
            }
        }
        if (this.outputFolderText.getText().length() > 0 && !((outputResource = this.getWorkspaceRoot().findMember(this.outputFolderText.getText())) instanceof IFolder)) {
            this.setErrorMessage("The output folder must be a valid folder or not be set!");
            return false;
        }
        return super.isValid(launchConfig);
    }

    public void performApply(ILaunchConfigurationWorkingCopy config) {
        String formatName;
        config.setAttribute(IJavaLaunchConfigurationConstants.ATTR_PROJECT_NAME, this.projectText.getText());
        config.setAttribute("org.apache.uima.ep_launcher.DESCRIPTOR_ATTR", this.descriptorText.getText());
        config.setAttribute("org.apache.uima.ep_launcher.INPUT_ATTR", this.inputText.getText());
        config.setAttribute("org.apache.uima.ep_launcher.INPUT_RECURSIVELY_ATTR", (Object)this.recursivelyButton.getSelection());
        if (this.casButton.getSelection()) {
            formatName = LauncherConstants.InputFormat.CAS.toString();
        } else if (this.plainTextButton.getSelection()) {
            formatName = LauncherConstants.InputFormat.PLAIN_TEXT.toString();
        } else {
            throw new IllegalStateException("One button must always be selected!");
        }
        config.setAttribute("org.apache.uima.ep_launcher.INPUT_FORMAT_ATTR", formatName);
        config.setAttribute("org.apache.uima.ep_launcher.INPUT_ENCODING_ATTR", this.encodingCombo.getText());
        config.setAttribute("org.apache.uima.ep_launcher.INPUT_LANGUAGE_ATTR", this.languageText.getText());
        config.setAttribute("org.apache.uima.ep_launcher.OUTPUT_FOLDER_ATTR", this.outputFolderText.getText());
        config.setAttribute("org.apache.uima.ep_launcher.OUTPUT_CLEAR_ATTR", (Object)this.clearFolderButton.getSelection());
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy config) {
        config.setAttribute("org.apache.uima.ep_launcher.INPUT_RECURSIVELY_ATTR", false);
        config.setAttribute("org.apache.uima.ep_launcher.INPUT_FORMAT_ATTR", LauncherConstants.InputFormat.CAS.toString());
        config.setAttribute("org.apache.uima.ep_launcher.INPUT_LANGUAGE_ATTR", "x-unspecified");
        config.setAttribute("org.apache.uima.ep_launcher.OUTPUT_CLEAR_ATTR", false);
    }

    public void initializeFrom(ILaunchConfiguration config) {
        String formatName;
        try {
            this.projectText.setText(config.getAttribute(IJavaLaunchConfigurationConstants.ATTR_PROJECT_NAME, ""));
        }
        catch (CoreException e) {
            this.projectText.setText("");
        }
        try {
            this.descriptorText.setText(config.getAttribute("org.apache.uima.ep_launcher.DESCRIPTOR_ATTR", ""));
        }
        catch (CoreException e) {
            this.descriptorText.setText("");
        }
        try {
            this.inputText.setText(config.getAttribute("org.apache.uima.ep_launcher.INPUT_ATTR", ""));
        }
        catch (CoreException e) {
            this.inputText.setText("");
        }
        try {
            this.recursivelyButton.setSelection(Boolean.valueOf(config.getAttribute("org.apache.uima.ep_launcher.INPUT_RECURSIVELY_ATTR", false)).booleanValue());
        }
        catch (CoreException e) {
            this.recursivelyButton.setSelection(false);
        }
        try {
            formatName = config.getAttribute("org.apache.uima.ep_launcher.INPUT_FORMAT_ATTR", LauncherConstants.InputFormat.CAS.toString());
        }
        catch (CoreException e) {
            formatName = LauncherConstants.InputFormat.CAS.toString();
        }
        if (LauncherConstants.InputFormat.CAS.toString().equals(formatName)) {
            this.casButton.setSelection(true);
        } else if (LauncherConstants.InputFormat.PLAIN_TEXT.toString().equals(formatName)) {
            String language;
            this.plainTextButton.setSelection(true);
            this.encodingCombo.setEnabled(true);
            this.languageText.setEnabled(true);
            try {
                language = config.getAttribute("org.apache.uima.ep_launcher.INPUT_LANGUAGE_ATTR", "x-unspecified");
            }
            catch (CoreException e) {
                language = "x-unspecified";
            }
            this.languageText.setText(language);
        }
        String inputEncoding = Charset.defaultCharset().displayName();
        try {
            inputEncoding = config.getAttribute("org.apache.uima.ep_launcher.INPUT_ENCODING_ATTR", inputEncoding);
        }
        catch (CoreException e) {
            // empty catch block
        }
        this.encodingCombo.setText(inputEncoding);
        try {
            this.outputFolderText.setText(config.getAttribute("org.apache.uima.ep_launcher.OUTPUT_FOLDER_ATTR", ""));
        }
        catch (CoreException e) {
            this.outputFolderText.setText("");
        }
        try {
            this.clearFolderButton.setSelection(Boolean.valueOf(config.getAttribute("org.apache.uima.ep_launcher.OUTPUT_CLEAR_ATTR", false)).booleanValue());
        }
        catch (CoreException e) {
            this.clearFolderButton.setSelection(false);
        }
        super.initializeFrom(config);
    }
}

