/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.cas.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.uima.cas.CASRuntimeException;
import org.apache.uima.cas.Feature;
import org.apache.uima.cas.FeatureValuePath;
import org.apache.uima.cas.Type;
import org.apache.uima.cas.TypeSystem;
import org.apache.uima.cas.impl.CASImpl;
import org.apache.uima.cas.impl.LowLevelCAS;
import org.apache.uima.cas.impl.LowLevelTypeSystem;
import org.apache.uima.cas.impl.TypeSystemImpl;
import org.apache.uima.cas.text.AnnotationFS;

public class FeatureValuePathImpl
implements FeatureValuePath {
    private static final boolean CAS_TYPE_CHECKS = true;
    private static final Map<String, String> CONTAINER_TO_ELEMENTYPE_MAP;
    private static final Map<String, String> LIST_TO_ARRAYTYPE_MAP;
    private static final String COVERED_TEXT = "coveredText()";
    private static final String[] EMPTY_LIST_TYPE_NAMES;
    private static final String FS_ID = "fsId()";
    private static final int LAST_ARRAY_ENTRY = -1;
    private static final String LAST_ARRAY_ENTRY_MARKER = "last";
    private static final String[] LIST_TYPE_NAMES;
    private static final String[] SIMPLE_VAL_TYPES;
    private static final int TYPE_CLASS_FLOATLIST = 2;
    private static final int TYPE_CLASS_FSLIST = 0;
    private static final int TYPE_CLASS_INTEGERLIST = 1;
    private static final int TYPE_CLASS_STRINGLIST = 3;
    private static final String TYPE_NAME = "typeName()";
    private static final String UNIQUE_ID = "uniqueId()";
    private static final int USE_ALL_ENTRIES = -2;
    private int arrayIndex;
    private final FeatureValuePathImpl childPath;
    private Type[] emptyListTypes;
    private int featureCode;
    private String featureName;
    private int featureRangeType;
    private int headFeature;
    private boolean isArrayOrList;
    private boolean isArrayType;
    private boolean isBracketsOnly;
    private boolean isCoveredTextFeature;
    private boolean isFsIdFeature;
    private boolean isListType;
    private boolean isSimpleRangeType;
    private boolean isTypeNameFeature;
    private boolean isUniqueIdFeature;
    private int listType;
    private int tailFeature;
    private int typeCode;
    private final String typeNameInSnippet;
    private String valueTypeName;

    public static FeatureValuePathImpl getFeaturePath(String featurePath) throws CASRuntimeException {
        if (featurePath == null || featurePath.length() == 0) {
            return null;
        }
        featurePath = featurePath.trim();
        StringTokenizer strTok = new StringTokenizer(featurePath, "/");
        String[] snippets = new String[strTok.countTokens()];
        int i = 0;
        while (strTok.hasMoreElements()) {
            String snippet;
            snippets[i] = snippet = (String)strTok.nextElement();
            ++i;
        }
        FeatureValuePathImpl result = new FeatureValuePathImpl(snippets[snippets.length - 1], null);
        for (int j = snippets.length - 2; j >= 0; --j) {
            result = new FeatureValuePathImpl(snippets[j], result);
        }
        return result;
    }

    private FeatureValuePathImpl(String pathSnippet, FeatureValuePathImpl child) throws CASRuntimeException {
        if (pathSnippet == null || pathSnippet.length() == 0) {
            throw new CASRuntimeException("INVALID_FEATURE_PATH", pathSnippet);
        }
        this.childPath = child;
        this.typeNameInSnippet = this.getTypeInSnippet(pathSnippet);
        this.featureName = this.getFeatureInSnippet(pathSnippet);
        this.isArrayOrList = false;
        this.isArrayType = false;
        this.determineArray();
        this.isListType = false;
        this.isCoveredTextFeature = COVERED_TEXT.equals(this.featureName);
        this.isFsIdFeature = FS_ID.equals(this.featureName);
        this.isTypeNameFeature = TYPE_NAME.equals(this.featureName);
        this.isUniqueIdFeature = UNIQUE_ID.equals(this.featureName);
        boolean bl = this.isBracketsOnly = this.isArrayOrList && this.featureName.length() == 0;
        if ((this.isCoveredTextFeature || this.isFsIdFeature || this.isUniqueIdFeature || this.isTypeNameFeature) && child != null) {
            throw new CASRuntimeException("INVALID_FEATURE_PATH", pathSnippet);
        }
    }

    @Override
    public Object evaluate(int currentFS, LowLevelCAS cas) {
        String valueType = this.getValueType();
        if ("uima.cas.Float".equals(valueType)) {
            return this.evaluateAsFloat(currentFS, cas);
        }
        if ("uima.cas.FloatArray".equals(valueType)) {
            return this.evaluateAsFloatArray(currentFS, cas);
        }
        if ("uima.cas.Integer".equals(valueType)) {
            return this.evaluateAsInt(currentFS, cas);
        }
        if ("uima.cas.IntegerArray".equals(valueType)) {
            return this.evaluateAsIntArray(currentFS, cas);
        }
        if ("uima.cas.String".equals(valueType)) {
            return this.evaluateAsString(currentFS, cas);
        }
        if ("uima.cas.StringArray".equals(valueType)) {
            return this.evaluateAsStringArray(currentFS, cas);
        }
        throw new IllegalStateException("unknown value type");
    }

    @Override
    public Float evaluateAsFloat(int currentFS, LowLevelCAS cas) {
        if (currentFS == 0) {
            return null;
        }
        if (this.isArrayType) {
            if (this.arrayIndex == -2) {
                throw new IllegalStateException("feature path denotes an array");
            }
            int arrayFS = this.isBracketsOnly ? currentFS : cas.ll_getRefValue(currentFS, this.featureCode);
            int arraySize = ((CASImpl)cas).ll_getArraySize(arrayFS);
            if (this.arrayIndex >= arraySize) {
                return null;
            }
            int typeClass = cas.ll_getTypeClass(this.featureRangeType);
            switch (typeClass) {
                case 5: {
                    int position = this.getArrayIndex(arraySize);
                    return Float.valueOf(cas.ll_getFloatArrayValue(arrayFS, position, false));
                }
                case 7: {
                    int childFS = this.getFsAtIndex(arrayFS, cas, arraySize);
                    return this.childPath.evaluateAsFloat(childFS, cas);
                }
            }
            throw new IllegalStateException("feature path snippet is neither float nor fs array");
        }
        if (this.isListType) {
            if (this.arrayIndex == -2) {
                throw new IllegalStateException("feature path denotes an array");
            }
            int listFS = this.isBracketsOnly ? currentFS : cas.ll_getRefValue(currentFS, this.featureCode);
            switch (this.listType) {
                case 2: {
                    return (Float)this.getValueAtListIndex(cas, listFS);
                }
                case 0: {
                    int childFs = this.getFsAtListIndex(cas, listFS);
                    if (childFs != 0) {
                        return this.childPath.evaluateAsFloat(childFs, cas);
                    }
                    return null;
                }
            }
            throw new IllegalStateException("feature path snippet is neither float nor fs list");
        }
        if (this.childPath != null) {
            int childFS = cas.ll_getRefValue(currentFS, this.featureCode, true);
            return this.childPath.evaluateAsFloat(childFS, cas);
        }
        if (this.isCoveredTextFeature || this.isUniqueIdFeature || this.isFsIdFeature || this.isTypeNameFeature) {
            throw new IllegalStateException("feature path does not denote a float");
        }
        int typeClass = cas.ll_getTypeClass(this.featureRangeType);
        switch (typeClass) {
            case 2: {
                return Float.valueOf(cas.ll_getFloatValue(currentFS, this.featureCode, true));
            }
        }
        throw new IllegalStateException("feature path does not denote a float");
    }

    @Override
    public Float[] evaluateAsFloatArray(int currentFS, LowLevelCAS cas) {
        if (!this.getValueType().equals("uima.cas.FloatArray")) {
            throw new IllegalStateException("Feature path does not denote a float array");
        }
        if (currentFS == 0) {
            return null;
        }
        if (this.isArrayType) {
            int arrayFS = this.isBracketsOnly ? currentFS : cas.ll_getRefValue(currentFS, this.featureCode);
            int arraySize = ((CASImpl)cas).ll_getArraySize(arrayFS);
            if (this.arrayIndex >= arraySize) {
                return null;
            }
            if (this.arrayIndex == -2) {
                Float[] result = new Float[arraySize];
                if (this.childPath != null) {
                    for (int i = 0; i < arraySize; ++i) {
                        int childFS = cas.ll_getRefArrayValue(arrayFS, i, true);
                        result[i] = this.childPath.evaluateAsFloat(childFS, cas);
                    }
                } else {
                    for (int i = 0; i < arraySize; ++i) {
                        result[i] = Float.valueOf(cas.ll_getFloatArrayValue(arrayFS, i));
                    }
                }
                return result;
            }
            int childFS = this.getFsAtIndex(arrayFS, cas, arraySize);
            return this.childPath.evaluateAsFloatArray(childFS, cas);
        }
        if (this.isListType) {
            int listFS;
            int n = listFS = this.isBracketsOnly ? currentFS : cas.ll_getRefValue(currentFS, this.featureCode);
            if (this.arrayIndex == -2) {
                ArrayList resultList = (ArrayList)this.getValueAtListIndex(cas, listFS);
                if (resultList == null) {
                    return null;
                }
                Float[] result = new Float[resultList.size()];
                if (this.childPath != null) {
                    for (int i = 0; i < resultList.size(); ++i) {
                        int childFS = (Integer)resultList.get(i);
                        result[i] = this.childPath.evaluateAsFloat(childFS, cas);
                    }
                } else {
                    resultList.toArray(result);
                }
                return result;
            }
            int childFS = this.getFsAtListIndex(cas, listFS);
            return this.childPath.evaluateAsFloatArray(childFS, cas);
        }
        int childFS = cas.ll_getRefValue(currentFS, this.featureCode, true);
        return this.childPath.evaluateAsFloatArray(childFS, cas);
    }

    @Override
    public Integer evaluateAsInt(int currentFS, LowLevelCAS cas) {
        if (currentFS == 0) {
            return null;
        }
        if (this.isArrayType) {
            if (this.arrayIndex == -2) {
                throw new IllegalStateException("feature path denotes an array");
            }
            int arrayFS = this.isBracketsOnly ? currentFS : cas.ll_getRefValue(currentFS, this.featureCode);
            int arraySize = ((CASImpl)cas).ll_getArraySize(arrayFS);
            if (this.arrayIndex >= arraySize) {
                return null;
            }
            int typeClass = cas.ll_getTypeClass(this.featureRangeType);
            switch (typeClass) {
                case 4: {
                    int position = this.getArrayIndex(arraySize);
                    return cas.ll_getIntArrayValue(arrayFS, position, false);
                }
                case 7: {
                    int childFS = this.getFsAtIndex(arrayFS, cas, arraySize);
                    return this.childPath.evaluateAsInt(childFS, cas);
                }
            }
            throw new IllegalStateException("feature path snippet is neither int nor fs array");
        }
        if (this.isListType) {
            if (this.arrayIndex == -2) {
                throw new IllegalStateException("feature path denotes an array");
            }
            int listFS = this.isBracketsOnly ? currentFS : cas.ll_getRefValue(currentFS, this.featureCode);
            switch (this.listType) {
                case 1: {
                    return (Integer)this.getValueAtListIndex(cas, listFS);
                }
                case 0: {
                    int childFs = this.getFsAtListIndex(cas, listFS);
                    if (childFs != 0) {
                        return this.childPath.evaluateAsInt(childFs, cas);
                    }
                    return null;
                }
            }
            throw new IllegalStateException("feature path snippet is neither int nor fs list");
        }
        if (this.childPath != null) {
            int childFS = cas.ll_getRefValue(currentFS, this.featureCode, true);
            return this.childPath.evaluateAsInt(childFS, cas);
        }
        if (this.isCoveredTextFeature || this.isTypeNameFeature) {
            throw new IllegalStateException("feature path does not denote an int");
        }
        if (this.isFsIdFeature) {
            return currentFS;
        }
        if (this.isUniqueIdFeature) {
            return currentFS;
        }
        int typeClass = cas.ll_getTypeClass(this.featureRangeType);
        switch (typeClass) {
            case 1: {
                return cas.ll_getIntValue(currentFS, this.featureCode, true);
            }
        }
        throw new IllegalStateException("feature path does not denote an int");
    }

    @Override
    public Integer[] evaluateAsIntArray(int currentFS, LowLevelCAS cas) {
        if (!this.getValueType().equals("uima.cas.IntegerArray")) {
            throw new IllegalStateException("Feature path does not denote an int array");
        }
        if (currentFS == 0) {
            return null;
        }
        if (this.isArrayType) {
            int arrayFS = this.isBracketsOnly ? currentFS : cas.ll_getRefValue(currentFS, this.featureCode);
            int arraySize = ((CASImpl)cas).ll_getArraySize(arrayFS);
            if (this.arrayIndex >= arraySize) {
                return null;
            }
            if (this.arrayIndex == -2) {
                Integer[] result = new Integer[arraySize];
                if (this.childPath != null) {
                    for (int i = 0; i < arraySize; ++i) {
                        int childFS = cas.ll_getRefArrayValue(arrayFS, i, true);
                        result[i] = this.childPath.evaluateAsInt(childFS, cas);
                    }
                } else {
                    for (int i = 0; i < arraySize; ++i) {
                        result[i] = cas.ll_getIntArrayValue(arrayFS, i);
                    }
                }
                return result;
            }
            int childFS = this.getFsAtIndex(arrayFS, cas, arraySize);
            return this.childPath.evaluateAsIntArray(childFS, cas);
        }
        if (this.isListType) {
            int listFS;
            int n = listFS = this.isBracketsOnly ? currentFS : cas.ll_getRefValue(currentFS, this.featureCode);
            if (this.arrayIndex == -2) {
                ArrayList resultList = (ArrayList)this.getValueAtListIndex(cas, listFS);
                if (resultList == null) {
                    return null;
                }
                Integer[] result = new Integer[resultList.size()];
                if (this.childPath != null) {
                    for (int i = 0; i < resultList.size(); ++i) {
                        int childFS = (Integer)resultList.get(i);
                        result[i] = this.childPath.evaluateAsInt(childFS, cas);
                    }
                } else {
                    resultList.toArray(result);
                }
                return result;
            }
            int childFS = this.getFsAtListIndex(cas, listFS);
            return this.childPath.evaluateAsIntArray(childFS, cas);
        }
        int childFS = cas.ll_getRefValue(currentFS, this.featureCode, true);
        return this.childPath.evaluateAsIntArray(childFS, cas);
    }

    @Override
    public String evaluateAsString(int currentFS, LowLevelCAS cas) {
        if (currentFS == 0) {
            return null;
        }
        if (this.isArrayType) {
            if (this.arrayIndex == -2) {
                throw new IllegalStateException("feature path denotes an array");
            }
            int arrayFS = this.isBracketsOnly ? currentFS : cas.ll_getRefValue(currentFS, this.featureCode);
            int arraySize = ((CASImpl)cas).ll_getArraySize(arrayFS);
            if (this.arrayIndex >= arraySize) {
                return null;
            }
            int typeClass = cas.ll_getTypeClass(this.featureRangeType);
            switch (typeClass) {
                case 6: {
                    int position = this.getArrayIndex(arraySize);
                    return cas.ll_getStringArrayValue(arrayFS, position, false);
                }
                case 7: {
                    int childFS = this.getFsAtIndex(arrayFS, cas, arraySize);
                    return this.childPath.evaluateAsString(childFS, cas);
                }
            }
            throw new IllegalStateException("feature path snippet is neither string nor fs array");
        }
        if (this.isListType) {
            if (this.arrayIndex == -2) {
                throw new IllegalStateException("feature path denotes an array");
            }
            int listFS = this.isBracketsOnly ? currentFS : cas.ll_getRefValue(currentFS, this.featureCode);
            switch (this.listType) {
                case 3: {
                    return (String)this.getValueAtListIndex(cas, listFS);
                }
                case 0: {
                    int childFs = this.getFsAtListIndex(cas, listFS);
                    if (childFs != 0) {
                        return this.childPath.evaluateAsString(childFs, cas);
                    }
                    return null;
                }
            }
            throw new IllegalStateException("feature path snippet is neither float nor fs list");
        }
        if (this.childPath != null) {
            int childFS = cas.ll_getRefValue(currentFS, this.featureCode, true);
            return this.childPath.evaluateAsString(childFS, cas);
        }
        if (this.isCoveredTextFeature) {
            AnnotationFS annotation = (AnnotationFS)cas.ll_getFSForRef(currentFS);
            return annotation.getCoveredText();
        }
        if (this.isTypeNameFeature) {
            Type type = cas.ll_getTypeSystem().ll_getTypeForCode(cas.ll_getFSRefType(currentFS));
            return type.getName();
        }
        if (this.isFsIdFeature) {
            throw new IllegalStateException("feature path denotes fsId()");
        }
        if (this.isUniqueIdFeature) {
            throw new IllegalStateException("feature path denotes uniqueId()");
        }
        int typeClass = cas.ll_getTypeClass(this.featureRangeType);
        switch (typeClass) {
            case 3: {
                return cas.ll_getStringValue(currentFS, this.featureCode, true);
            }
            case 2: {
                throw new IllegalStateException("feature path denotes a float");
            }
            case 1: {
                throw new IllegalStateException("feature path denotes an int");
            }
        }
        throw new IllegalStateException("feature path does not denote a string");
    }

    @Override
    public String[] evaluateAsStringArray(int currentFS, LowLevelCAS cas) {
        if (!this.getValueType().equals("uima.cas.StringArray")) {
            throw new IllegalStateException("Feature path does not denote a String array");
        }
        if (currentFS == 0) {
            return null;
        }
        if (this.isArrayType) {
            int arrayFS = this.isBracketsOnly ? currentFS : cas.ll_getRefValue(currentFS, this.featureCode);
            int arraySize = ((CASImpl)cas).ll_getArraySize(arrayFS);
            if (this.arrayIndex >= arraySize) {
                return null;
            }
            if (this.arrayIndex == -2) {
                String[] result = new String[arraySize];
                if (this.childPath != null) {
                    for (int i = 0; i < arraySize; ++i) {
                        int childFS = cas.ll_getRefArrayValue(arrayFS, i, true);
                        result[i] = this.childPath.evaluateAsString(childFS, cas);
                    }
                } else {
                    for (int i = 0; i < arraySize; ++i) {
                        result[i] = cas.ll_getStringArrayValue(arrayFS, i);
                    }
                }
                return result;
            }
            int childFS = this.getFsAtIndex(arrayFS, cas, arraySize);
            return this.childPath.evaluateAsStringArray(childFS, cas);
        }
        if (this.isListType) {
            int listFS;
            int n = listFS = this.isBracketsOnly ? currentFS : cas.ll_getRefValue(currentFS, this.featureCode);
            if (this.arrayIndex == -2) {
                ArrayList resultList = (ArrayList)this.getValueAtListIndex(cas, listFS);
                if (resultList == null) {
                    return null;
                }
                String[] result = new String[resultList.size()];
                if (this.childPath != null) {
                    for (int i = 0; i < resultList.size(); ++i) {
                        int childFS = (Integer)resultList.get(i);
                        result[i] = this.childPath.evaluateAsString(childFS, cas);
                    }
                } else {
                    resultList.toArray(result);
                }
                return result;
            }
            int childFS = this.getFsAtListIndex(cas, listFS);
            return this.childPath.evaluateAsStringArray(childFS, cas);
        }
        int childFS = cas.ll_getRefValue(currentFS, this.featureCode, true);
        return this.childPath.evaluateAsStringArray(childFS, cas);
    }

    @Override
    public int getFSType() {
        if (this.isSimpleRangeType) {
            return this.typeCode;
        }
        return this.childPath.getFSType();
    }

    @Override
    public String getValueType() {
        if (this.valueTypeName == null) {
            this.valueTypeName = this.childPath.getValueType();
            if (this.arrayIndex == -2) {
                if ("uima.cas.String".equals(this.valueTypeName)) {
                    this.valueTypeName = "uima.cas.StringArray";
                } else if ("uima.cas.Integer".equals(this.valueTypeName)) {
                    this.valueTypeName = "uima.cas.IntegerArray";
                } else if ("uima.cas.Float".equals(this.valueTypeName)) {
                    this.valueTypeName = "uima.cas.FloatArray";
                }
            }
        }
        return this.valueTypeName;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        if (this.typeNameInSnippet != null) {
            result.append(this.typeNameInSnippet);
            result.append(':');
        }
        result.append(this.featureName);
        if (this.isArrayOrList) {
            result.append('[');
            if (!this.isBracketsOnly && this.arrayIndex >= 0) {
                result.append(this.arrayIndex);
            }
            if (this.arrayIndex == -1) {
                result.append(LAST_ARRAY_ENTRY_MARKER);
            }
            result.append(']');
        }
        if (this.childPath != null) {
            result.append('/');
            result.append(this.childPath.toString());
        }
        return result.toString();
    }

    @Override
    public void typeSystemInit(int fsType, LowLevelTypeSystem ts) throws CASRuntimeException {
        int i;
        if (this.typeNameInSnippet != null) {
            fsType = ts.ll_getCodeForTypeName(this.typeNameInSnippet);
        }
        if (fsType == 0) {
            throw new CASRuntimeException("INVALID_FEATURE_PATH", this.typeNameInSnippet);
        }
        int rangeTypeCode = 0;
        if (!this.isBuiltInFeature() && !this.isBracketsOnly) {
            int[] features = ts.ll_getAppropriateFeatures(fsType);
            boolean found = false;
            for (i = 0; i < features.length && !found; ++i) {
                Feature feature = ts.ll_getFeatureForCode(features[i]);
                found = feature.getShortName().equals(this.featureName);
            }
            if (found) {
                this.featureCode = features[i - 1];
                rangeTypeCode = ts.ll_getRangeType(this.featureCode);
            } else {
                Type type = ts.ll_getTypeForCode(fsType);
                throw new CASRuntimeException("INAPPROP_FEAT", this.featureName, type.getName());
            }
        }
        if (this.isBracketsOnly) {
            rangeTypeCode = fsType;
        }
        this.typeCode = fsType;
        Type type = ts.ll_getTypeForCode(rangeTypeCode);
        this.featureRangeType = rangeTypeCode;
        if (this.isBuiltInFeature()) {
            this.isSimpleRangeType = true;
        } else {
            boolean bl = this.isSimpleRangeType = Arrays.binarySearch(SIMPLE_VAL_TYPES, type.getName()) >= 0;
        }
        if (this.isArrayOrList) {
            int arrayType = ts.ll_getCodeForTypeName("uima.cas.ArrayBase");
            this.isArrayType = ((TypeSystemImpl)ts).subsumes(arrayType, rangeTypeCode);
            if (!this.isArrayType) {
                for (i = 0; i < LIST_TYPE_NAMES.length && !this.isListType; ++i) {
                    int candidateType = ts.ll_getCodeForTypeName(LIST_TYPE_NAMES[i]);
                    this.isListType = ((TypeSystemImpl)ts).subsumes(candidateType, rangeTypeCode);
                    if (!this.isListType) continue;
                    this.listType = i;
                }
                switch (this.listType) {
                    case 0: {
                        this.headFeature = ts.ll_getCodeForFeatureName("uima.cas.NonEmptyFSList:head");
                        this.tailFeature = ts.ll_getCodeForFeatureName("uima.cas.NonEmptyFSList:tail");
                        break;
                    }
                    case 3: {
                        this.headFeature = ts.ll_getCodeForFeatureName("uima.cas.NonEmptyStringList:head");
                        this.tailFeature = ts.ll_getCodeForFeatureName("uima.cas.NonEmptyStringList:tail");
                        break;
                    }
                    case 1: {
                        this.headFeature = ts.ll_getCodeForFeatureName("uima.cas.NonEmptyIntegerList:head");
                        this.tailFeature = ts.ll_getCodeForFeatureName("uima.cas.NonEmptyIntegerList:tail");
                        break;
                    }
                    case 2: {
                        this.headFeature = ts.ll_getCodeForFeatureName("uima.cas.NonEmptyFloatList:head");
                        this.tailFeature = ts.ll_getCodeForFeatureName("uima.cas.NonEmptyFloatList:tail");
                        break;
                    }
                }
                this.emptyListTypes = new Type[EMPTY_LIST_TYPE_NAMES.length];
                for (i = 0; i < EMPTY_LIST_TYPE_NAMES.length; ++i) {
                    this.emptyListTypes[i] = ts.ll_getTypeForCode(ts.ll_getCodeForTypeName(EMPTY_LIST_TYPE_NAMES[i]));
                }
            }
        }
        if (this.childPath != null) {
            if (this.isSimpleRangeType && !this.childPath.isBracketsOnly() && !this.childPath.isFsIdFeature) {
                throw new CASRuntimeException("INVALID_FEATURE_PATH", this.featureName);
            }
            this.childPath.typeSystemInit(rangeTypeCode, ts);
        } else if (this.isCoveredTextFeature) {
            int annotationType = ts.ll_getCodeForTypeName("uima.tcas.Annotation");
            if (!((TypeSystemImpl)ts).subsumes(annotationType, fsType)) {
                throw new CASRuntimeException("INVALID_FEATURE_PATH", this.featureName);
            }
            this.valueTypeName = SIMPLE_VAL_TYPES[Arrays.binarySearch(SIMPLE_VAL_TYPES, "uima.cas.String")];
        } else if (this.isFsIdFeature) {
            this.valueTypeName = SIMPLE_VAL_TYPES[Arrays.binarySearch(SIMPLE_VAL_TYPES, "uima.cas.Integer")];
        } else if (this.isUniqueIdFeature) {
            this.valueTypeName = SIMPLE_VAL_TYPES[Arrays.binarySearch(SIMPLE_VAL_TYPES, "uima.cas.Integer")];
        } else if (this.isTypeNameFeature) {
            this.valueTypeName = SIMPLE_VAL_TYPES[Arrays.binarySearch(SIMPLE_VAL_TYPES, "uima.cas.String")];
        } else {
            if (!this.isSimpleRangeType) {
                CASRuntimeException exception = new CASRuntimeException("NO_PRIMITIVE_TAIL", new Object[0]);
                throw exception;
            }
            this.valueTypeName = this.isArrayOrList && this.arrayIndex != -2 ? CONTAINER_TO_ELEMENTYPE_MAP.get(type.getName()) : (this.isListType ? LIST_TO_ARRAYTYPE_MAP.get(type.getName()) : SIMPLE_VAL_TYPES[Arrays.binarySearch(SIMPLE_VAL_TYPES, type.getName())]);
        }
    }

    private boolean isBuiltInFeature() {
        return this.isFsIdFeature || this.isUniqueIdFeature || this.isCoveredTextFeature || this.isTypeNameFeature;
    }

    private final void determineArray() throws CASRuntimeException {
        int startIndex = this.featureName.indexOf(91);
        if (startIndex == -1) {
            return;
        }
        int endIndex = this.featureName.indexOf(93);
        if (endIndex == -1) {
            throw new CASRuntimeException("INVALID_FEATURE_PATH", this.toString());
        }
        this.isArrayOrList = true;
        String arrayIndexString = this.featureName.substring(startIndex + 1, endIndex);
        this.featureName = this.featureName.substring(0, startIndex);
        if (arrayIndexString.equals("")) {
            this.arrayIndex = -2;
        } else if (LAST_ARRAY_ENTRY_MARKER.equalsIgnoreCase(arrayIndexString)) {
            this.arrayIndex = -1;
        } else {
            try {
                this.arrayIndex = Integer.parseInt(arrayIndexString);
            }
            catch (NumberFormatException e) {
                throw new CASRuntimeException("INVALID_FEATURE_PATH", this.toString());
            }
        }
    }

    private int getArrayIndex(int arraySize) {
        return -1 != this.arrayIndex ? this.arrayIndex : arraySize - 1;
    }

    private final String getFeatureInSnippet(String pathSnippet) {
        int typeIndex = pathSnippet.indexOf(58);
        if (typeIndex == -1) {
            return pathSnippet;
        }
        return pathSnippet.substring(typeIndex + 1);
    }

    private int getFsAtIndex(int currentFS, LowLevelCAS cas, int arraySize) {
        if (!this.isArrayType) {
            throw new IllegalStateException("FeaturePath is not an array");
        }
        int arrayInd = this.getArrayIndex(arraySize);
        int childFS = cas.ll_getRefArrayValue(currentFS, arrayInd, true);
        return childFS;
    }

    private int getFsAtListIndex(LowLevelCAS cas, int listFS) {
        if (this.arrayIndex == -2 || this.listType != 0) {
            throw new IllegalStateException("feature does not denote an fs list, or does not denote a singel array entry");
        }
        Object valueAtListIndex = this.getValueAtListIndex(cas, listFS);
        if (valueAtListIndex != null) {
            return (Integer)valueAtListIndex;
        }
        return 0;
    }

    private Object getHeadValue(LowLevelCAS cas, int listFS) {
        if (listFS == 0) {
            return null;
        }
        switch (this.listType) {
            case 3: {
                return cas.ll_getStringValue(listFS, this.headFeature);
            }
            case 1: {
                return cas.ll_getIntValue(listFS, this.headFeature);
            }
            case 2: {
                return Float.valueOf(cas.ll_getFloatValue(listFS, this.headFeature));
            }
            case 0: {
                return cas.ll_getRefValue(listFS, this.headFeature);
            }
        }
        return null;
    }

    private final String getTypeInSnippet(String pathSnippet) {
        if (pathSnippet == null) {
            return null;
        }
        int index = pathSnippet.indexOf(58);
        if (index == -1) {
            return null;
        }
        return pathSnippet.substring(0, index);
    }

    private Object getValueAtIndexRec(LowLevelCAS cas, int listFS, ArrayList list, int count) {
        if (listFS == 0) {
            return null;
        }
        int type = cas.ll_getFSRefType(listFS);
        if (this.isEmptyList(cas, type)) {
            return null;
        }
        int listTail = cas.ll_getRefValue(listFS, this.tailFeature);
        switch (this.arrayIndex) {
            case -2: {
                list.add(this.getHeadValue(cas, listFS));
                return this.getValueAtIndexRec(cas, listTail, list, ++count);
            }
            case -1: {
                Object result = this.getValueAtIndexRec(cas, listTail, list, ++count);
                if (result != null) {
                    return result;
                }
                return this.getHeadValue(cas, listFS);
            }
        }
        if (count == this.arrayIndex) {
            return this.getHeadValue(cas, listFS);
        }
        return this.getValueAtIndexRec(cas, listTail, list, ++count);
    }

    private Object getValueAtListIndex(LowLevelCAS cas, int listFS) {
        ArrayList arrayRes = new ArrayList();
        Object result = this.getValueAtIndexRec(cas, listFS, arrayRes, 0);
        if (arrayRes.isEmpty()) {
            return result;
        }
        return arrayRes;
    }

    private boolean isBracketsOnly() {
        return this.isBracketsOnly;
    }

    private boolean isEmptyList(LowLevelCAS cas, int type) {
        Type candidateType = cas.ll_getTypeSystem().ll_getTypeForCode(type);
        TypeSystem typeSystem = ((CASImpl)cas).getTypeSystem();
        boolean isEmpty = false;
        for (int i = 0; i < this.emptyListTypes.length && !isEmpty; ++i) {
            isEmpty = typeSystem.subsumes(this.emptyListTypes[i], candidateType);
        }
        return isEmpty;
    }

    static {
        EMPTY_LIST_TYPE_NAMES = new String[]{"uima.cas.EmptyFSList", "uima.cas.EmptyIntegerList", "uima.cas.EmptyFloatList", "uima.cas.EmptyStringList"};
        LIST_TYPE_NAMES = new String[]{"uima.cas.FSList", "uima.cas.IntegerList", "uima.cas.FloatList", "uima.cas.StringList"};
        SIMPLE_VAL_TYPES = new String[]{"uima.cas.String", "uima.cas.StringArray", "uima.cas.Integer", "uima.cas.IntegerArray", "uima.cas.Float", "uima.cas.FloatArray", "uima.cas.IntegerList", "uima.cas.FloatList", "uima.cas.StringList"};
        Arrays.sort(SIMPLE_VAL_TYPES);
        CONTAINER_TO_ELEMENTYPE_MAP = new HashMap<String, String>();
        CONTAINER_TO_ELEMENTYPE_MAP.put("uima.cas.IntegerArray", "uima.cas.Integer");
        CONTAINER_TO_ELEMENTYPE_MAP.put("uima.cas.StringArray", "uima.cas.String");
        CONTAINER_TO_ELEMENTYPE_MAP.put("uima.cas.FloatArray", "uima.cas.Float");
        CONTAINER_TO_ELEMENTYPE_MAP.put("uima.cas.IntegerList", "uima.cas.Integer");
        CONTAINER_TO_ELEMENTYPE_MAP.put("uima.cas.StringList", "uima.cas.String");
        CONTAINER_TO_ELEMENTYPE_MAP.put("uima.cas.FloatList", "uima.cas.Float");
        LIST_TO_ARRAYTYPE_MAP = new HashMap<String, String>();
        LIST_TO_ARRAYTYPE_MAP.put("uima.cas.IntegerList", "uima.cas.IntegerArray");
        LIST_TO_ARRAYTYPE_MAP.put("uima.cas.StringList", "uima.cas.StringArray");
        LIST_TO_ARRAYTYPE_MAP.put("uima.cas.FloatList", "uima.cas.FloatArray");
    }
}

